<%@page import="com.suncode.pwfl.administration.user.UserSettingsService" %>
<%@page import="com.suncode.pwfl.util.SpringContext" %>
<%@page import="org.springframework.context.i18n.LocaleContextHolder" %>
<%@page import="org.apache.commons.lang3.StringEscapeUtils" %>
<%@page import="com.suncode.pwfl.administration.user.UserContext" %>
<%@ page import="com.suncode.pwfl.license.trial.service.TrialService" %>
<%@ page import="com.suncode.pwfl.administration.configuration.SystemProperties" %>
<%@ page import="com.suncode.pwfl.administration.configuration.DefinedSystemParameter" %>
<%@ page import="com.suncode.pwfl.administration.configuration.SystemType" %>
<%@ page import="org.apache.commons.lang3.StringUtils" %>
<%@ page import="com.suncode.pwfl.i18n.MessageHelper" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="suncode-tiles" prefix="tiles" %>
<%@ taglib uri="/tags/c" prefix="c" %>
<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
    <meta http-equiv="pragma" content="no-cache" />
    <meta http-equiv="cache-control" content="no-cache"/>
    <meta http-equiv="expires" content="0"/>
    <meta http-equiv="X-UA-Compatible" content="IE=Edge"/>
    <meta name="csrf-token" content="${_csrf.token}"/>
    <meta name="csrf-token-header" content="${_csrf.headerName}"/>
    <meta name="csrf-token-parameter" content="${_csrf.parameterName}"/>

    <title><bean:message key="System_zarzadzania_procesami_biznesowymi"/></title>

    <link rel="icon" href="${pageContext.request.contextPath}/resources/images/plusworkflow_logo.png"
          type="image/x-icon"/>
    <link rel="shortcut icon" href="${pageContext.request.contextPath}/resources/images/plusworkflow_logo.png"/>

    <link rel="stylesheet" type="text/css" media="screen"
          href="${pageContext.request.contextPath}/style/style.css?v=3"/>
    <%
        String user = (String) session.getAttribute( "username" );
        String skinPath = SpringContext.getBean( UserSettingsService.class ).getSkinPathForUser( user );
    %>

    <link rel="stylesheet" type="text/css" media="print"
          href="${pageContext.request.contextPath}/style/style_print.css"/>
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/style/site.css"/>
    <link rel="stylesheet" type="text/css"
          href="${pageContext.request.contextPath}/resources/lib/jquery-plugins/tooltipster.bundle.min.css"/>

    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/lib/jquery.min.js"></script>

    <script type="text/javascript"
            src="${pageContext.request.contextPath}/resources/lib/jquery-plugins/idle-timer.min.js"></script>
    <script type="text/javascript"
            src="${pageContext.request.contextPath}/resources/lib/jquery-plugins/jquery.easytabs.min.js"></script>
    <script type="text/javascript"
            src="${pageContext.request.contextPath}/resources/lib/jquery-plugins/jquery.ba-hashchange.min.js"></script>
    <script type="text/javascript"
            src="${pageContext.request.contextPath}/resources/lib/jquery-plugins/tooltipster.bundle.min.js"></script>

    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/common.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/Logger.js"></script>
    <script type="text/javascript"
            src="${pageContext.request.contextPath}/resources/js/common/ServerLogger.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/I18N.js"></script>

    <script type="text/javascript">
        var userObject;
        <% if(UserContext.isActive()){%>
        userObject = JSON.parse("<%=StringEscapeUtils.escapeEcmaScript( UserContext.current().getUserJson() )%>");
        <%}%>

        PlusWorkflow.init({
            contextPath: '${pageContext.request.contextPath}',
            user: userObject
        });

        Suncode.init({
            contextPath: '${pageContext.request.contextPath}',
            user: userObject,
            locale: '<%=LocaleContextHolder.getLocale().getLanguage()%>',
            sessionTimeout: <c:out value="${pageContext.session.maxInactiveInterval}"/>
        });
        Suncode.initAutoLogout();
    </script>

    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/common-ui.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/dist/shared.js"></script>

    <script>
        jQuery(document).ready(function () {
            var finalUrl = '';

            if ('${activeTab}' == null || '${activeTab}' == "") {

                var url = window.location.href.split('#')[0];
                var regEx = url.match(/.+\.do/);
                if (regEx == null) {
                    regEx = url.match(/.+plugin.+/);
                    if (regEx != null) {
                        var splitUrl = regEx.toString().split("/");
                        finalUrl = splitUrl[splitUrl.length - 2];
                    }
                }
                else {
                    var splitUrl = regEx.toString().split("/");
                    var splitUrl2 = splitUrl[splitUrl.length - 1];
                    finalUrl = splitUrl2.split("?").shift();
                }
            }

            else {
                finalUrl = '${activeTab}';
            }

            jQuery('li.menu').each(function () {
                var href = jQuery(this).find('a.menu-link').attr('href');

                if (href.indexOf(finalUrl) >= 0) {
                    jQuery(this).addClass('active');
                    return false;
                }
            });
        });
        //# sourceURL=dynamicScript.js
    </script>

    <jsp:include page="/pages/util/extjs_header_base.jsp"></jsp:include>
    <link rel="stylesheet" type="text/css" media="screen"
          href="${pageContext.request.contextPath}/resources/css/<%=skinPath%>"/>

	<link rel="stylesheet" href="${pageContext.request.contextPath}/resources/lib/fontawesome/css/fontawesome-all.min.css">

</head>

<%
    TrialService trialService = SpringContext.getBean( TrialService.class );
    String systemTypeValue = SystemProperties.getString( DefinedSystemParameter.SYSTEM_TYPE );
    SystemType systemType = SystemType.fromString( systemTypeValue );
    String systemName = SystemProperties.getString( DefinedSystemParameter.SYSTEM_NAME );

    boolean showVersion = trialService.readLicense().isValid() || systemType != SystemType.PRODUCTION;
    boolean showBar = StringUtils.isNotBlank( systemName ) || showVersion;

    StringBuilder barStringBuilder = new StringBuilder();
    if ( showBar )
    {
        if ( StringUtils.isNotBlank( systemName ) )
        {
            barStringBuilder.append( systemName );
        }

        if ( StringUtils.isNotBlank( systemName ) && showVersion )
        {
            barStringBuilder.append( " - " );
        }

        if ( trialService.readLicense().isValid() )
        {
            barStringBuilder.append( MessageHelper.getMessage( "demoVersion" ) );
        }
        else if ( systemType != SystemType.PRODUCTION )
        {
            barStringBuilder.append( MessageHelper.getMessage( systemType.getMessageKey() ) );
        }
    }
%>

<body id="page_bg">
<div>
    <% if ( showBar )
    {%>
    <div id="version-bar">
        <div class="system-version-bar">
            <%=barStringBuilder.toString()%>
        </div>
    </div>
    <% } %>

    <div class="body-container">
        <tiles:insert name="body"/>
    </div>
    <div>
        <tiles:insert attribute="menu"/>
    </div>
</div>
</body>

</html>
