(function (Ext) {
  var messages = Suncode.context('dashboard').messages;

  Ext.define('Suncode.dashboard.settings.view.Settings', {
    extend: 'Ext.container.Container',
    requires: [
      'Suncode.dashboard.settings.view.DashboardGrid',
      'Suncode.dashboard.settings.view.CreateDashboardForm',
      'Suncode.dashboard.settings.view.EditDashboardForm',
    ],
    layout: 'border',
    margin: '10px 0',
    height: 770,
    minWidth: 800,
    style: {
      background: 0,
    },

    initComponent: function () {
      Ext.apply(this, {
        items: [
          {
            xtype: 'panel',
            region: 'west',
            layout: {
              type: 'vbox',
              align: 'stretch',
            },
            frame: true,
            title: messages('manager.west.title'),
            width: 580,
            minWidth: 580,
            collapsible: true,
            autoScroll: true,
            split: true,
            bodyStyle: {
              padding: '5px',
              border: '0',
            },
            defaults: {
              bodyPadding: 10,
              collapsible: true,
              titleCollapse: true,
              animCollapse: false,
            },
            items: [
              {
                xtype: 'edit-dashboard-form',
                cls: 'dashboard-panel-clear highlighted',
              },
              {
                xtype: 'dashboard-create-form',
                cls: 'dashboard-panel-clear',
              },
            ],
          },
          {
            xtype: 'panel',
            region: 'center',
            title: messages('settings.manager.title'),
            itemCls: 'dashboard-big-header',
            layout: {
              type: 'vbox',
              align: 'stretch',
            },
            frame: true,
            bodyStyle: {
              border: '0',
            },
            defaults: {
              cls: 'dashboard-panel-clear',
              collapsible: true,
              animCollapse: false,
            },
            items: [
              {
                xtype: 'dashboard-grid',
                title: messages('grid.user.title', Suncode.getCurrentUser()),
                flex: 1,
                itemId: 'ownedGrid',
                store: 'MyDashboards',
                editable: true,
                listeners: {
                  scope: this,
                  selectionchange: this.onOwnedSelectionChange,
                },
                style: {
                  margin: '5px',
                  marginBottom: '32px',
                },
              },
              {
                xtype: 'dashboard-grid',
                title: messages('grid.shared.title', Suncode.getCurrentUser()),
                flex: 1,
                itemId: 'sharedGrid',
                store: 'SharedDashboards',
                style: {
                  margin: '5px',
                  marginBottom: '32px',
                },
              },
            ],
            tbar: [
              {
                xtype: 'combo',
                emptyText: messages('dashboard.default.choose'),
                store: Ext.create('Suncode.dashboard.settings.store.Dashboards', {
                  autoDestroy: true,
                }),
                flex: 1,
                maxWidth: 576,
                itemId: 'defaultDashboardCombo',
                name: 'defaultDashboard',
                queryMode: 'remote',
                displayField: 'translatedName',
                valueField: 'id',
                value: this.defaultDashboard ? this.defaultDashboard.id : undefined,
                editable: true,
                minChars: 0,
                forceSelection: true,
                pageSize: 20,
                listeners: {
                  scope: this,
                  change: function () {
                    this.setDefaultButton.setDisabled(false);
                  }
                }
              },
              {
                xtype: 'button',
                cls: 'toolbar-button-overrides-secondary',
                width: '284px',
                itemId: 'setDefaultButton',
                text: messages('form.edit.set'),
                iconCls: 'dvnt-icon-star',
                disabled: true,
                scope: this,
                handler: this.setDefaultDashboard,
              },
            ],
          },
        ],
      });

      this.callParent();

      this.defaultDashboardCombo = this.down('#defaultDashboardCombo');
      this.setDefaultButton = this.down('#setDefaultButton');
      this.ownedGrid = this.down('#ownedGrid');
      this.sharedGrid = this.down('#sharedGrid');
      this.editForm = this.down('edit-dashboard-form');
    },

    onOwnedSelectionChange: function (grid, selected) {
      var me = this;

      if (Ext.isEmpty(selected)) {
        me.editForm.setVisible(false);
      } else {
        me.editForm.bind(selected[0]);
        me.editForm.setVisible(true);
      }
    },

    setDefaultDashboard: function (button) {
      var me = this;

      button.setDisabled(true);
      me.defaultDashboardCombo.setDisabled(true);
      button.setIconCls(Ext.baseCSSPrefix + 'mask-msg-text');

      const foundDashboard = me.defaultDashboardCombo.getStore()
          .getById(me.defaultDashboardCombo.getValue());
      if (!foundDashboard) {
        button.setIconCls('dvnt-icon-x-symbol');
        Ext.defer(function () {
          button.setIconCls('dvnt-icon-star');
        }, 3000);
        me.defaultDashboardCombo.setDisabled(false);
        button.setDisabled(false);
        return;
      }

      const dashboard = foundDashboard.data;
      const isSystemDashboard = dashboard.type === 'SYSTEM';

      Ext.Ajax.request({
        url: Suncode.context('dashboard').base + `/api/dashboards/${encodeURIComponent(dashboard.id)}/default`,
        method: 'POST',
        params: {
          system: isSystemDashboard,
        },
        success: function () {
          button.setIconCls('dvnt-icon-check-circle');
          Ext.defer(function () {
            button.setIconCls('dvnt-icon-star');
          }, 3000);
        },
        failure: function () {
          button.setIconCls('dvnt-icon-x-symbol');
          Ext.defer(function () {
            button.setIconCls('dvnt-icon-star');
          }, 3000);
        },
        callback: function () {
          me.defaultDashboardCombo.setDisabled(false);
          button.setDisabled(false);
        },
      });
    },
  });
})(Ext4);
