(function(Ext) {

	Ext.define('Suncode.pluginmanager.model.Plugin', {
		extend : 'Ext.data.Model',
		idProperty: 'key',
		
		fields : [ {
			name : 'key',
			type : 'string'
		},{
			name : 'running',
			type : 'boolean',
			defaultValue: false
		},{
			name : 'name',
			type : 'string'
		},{
			name : 'version',
			type : 'string'
		},{
			name : 'description',
			type : 'string'
		},{
			name : 'author',
			type : 'string'
		},{
			name : 'license',
			type : 'string'
		}, {
			name : 'updated',
			type : 'date',
			dateFormat: 'time'
		}, {
			name : 'systemStartupError',
			type : 'string'
		} ],

		getKey: function(){
	        return this.get('key');
	    },

		isRunning: function(){
			return this.get('running');
		},

		hasErrorWhileSystemStartup: function() {
			return !!this.get('systemStartupError')
		}
	});

})(Ext4);