Ext4.define('Suncode.passwordpolicy.view.GlobalProfileConfiguration', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.passwordpolicy-globalprofileconfiguration',

	text: PW.t('Ustawienie_profilu_globalnego'),

	bodyStyle: {
		border: 'none'
	},

	layout: 'column',

	bodyPadding: 10,

	initComponent: function () {
		var me = this;
		Ext4.apply(this, {
			items: [{
				xtype: 'panel',
				columnWidth: .8,
				layout: 'column',
				bodyStyle: {
					border: 'none'
				},
				items: {
					id: 'globalPasswordProfileCombo',
					xtype: 'combobox',
					fieldLabel: PW.t('Globalny_profil'),
					emptyText: PW.t('Nie_wybrano'),
					store: 'Suncode.passwordpolicy.store.PasswordProfileStore',
					displayField: 'name',
					forceSelection: true,
					allowBlank: true,
					width: 400,
					listeners: {
						select: function (combo, selectedProfiles) {
							if (selectedProfiles.length > 0) {
								me.setGlobalProfile(selectedProfiles[0]);
							}
						},
						change: function (combo, inputText) {
							if (!inputText) {
								me.setGlobalProfile(null);
							}
						}
					}
				}
			}, {
				xtype: 'button',
				text: PW.t('save'),
				iconCls: 'dvnt-icon-save',
				columnWidth: .2,
				id: 'global-profile-configuration-save-button',
				handler: function () {
					me.fireEvent('saveprofilesassignment');
				}
			}]
		});

		this.callParent(arguments);
		this.on('boxready', this.reset);
	},

	reset: function () {
		var me = this;
		var loadingMask = new Ext4.LoadMask({
			target: me
		});
		loadingMask.show();

		jQuery.ajax({
			url: 'api/password/policy/assignments/global',
			method: 'GET',
			success: function (data) {
				loadingMask.destroy();
				me.selectGlobalProfile(data);
			},
			error: function () {
				PW.Logger.error('Cannot get global password policy profile');
			}
		});
	},

	selectGlobalProfile: function (globalProfile) {
		var profileCombo = Ext4.getCmp('globalPasswordProfileCombo');
		var profileStore = profileCombo.getStore();

		if (!globalProfile.notAssigned) {
			var foundProfile;
			var foundProfileIndex = profileStore.findBy(function (profile) {
				var found = false;

				if (!!globalProfile.defaultProfile == !!profile.get('defaultProfile')) {
					if (globalProfile.defaultProfile) {
						found = profile.get('profileKey') == globalProfile.profileKey;
					}
					else {
						found = profile.get('id') == globalProfile.profileId;
					}
				}

				return found;
			});

			if (foundProfileIndex >= 0) {
				foundProfile = profileStore.getAt(foundProfileIndex);
			}

			if (foundProfile) {
				profileCombo.select(foundProfile);
				this.setGlobalProfile(foundProfile);
			}
			else {
				this.globalProfile = null;
				profileCombo.clearValue();
			}
		}
		else {
			this.globalProfile = null;
			profileCombo.clearValue();
		}
	},

	setGlobalProfile: function (value) {
		this.globalProfile = value;
		this.fireEvent('globalprofilechanged', this.globalProfile);
	}
});
