Ext4.define('Suncode.passwordpolicy.PasswordPolicyManager', {
    extend: 'Ext.app.Controller',

    views: ['Viewport'],

    stores: ['Suncode.passwordpolicy.store.PasswordProfileStore',
        'Suncode.passwordpolicy.store.ProfileAssignmentStore'],

    models: ['Suncode.passwordpolicy.model.PasswordProfile',
        'Suncode.passwordpolicy.model.ProfileAssignment'],

    refs: [{
        ref: 'profilesList',
        selector: 'passwordpolicy-profileslist'
    }, {
        ref: 'profileConfiguration',
        selector: 'passwordpolicy-profileconfiguration'
    }, {
        ref: 'profilesAssignment',
        selector: 'passwordpolicy-profilesassignment'
    }, {
        ref: 'viewport',
        selector: 'passwordpolicy-viewport'
    }, {
        ref: 'globalProfileConfiguration',
        selector: 'passwordpolicy-globalprofileconfiguration'
    }],

    init: function () {
        var me = this;
        me.eventbus.unlisten(me.id);
        this.control({
            'passwordpolicy-profileslist': {
                selectedprofilechanged: me.selectedProfileChanged,
                addprofile: me.showNewProfileWindow,
                deleteprofile: me.showDeleteProfileWindow,
                savepriorities: me.savePriorities
            },
            'passwordpolicy-profileconfiguration': {
                profilesaved: me.profileSaved
            },
            'passwordpolicy-globalprofileconfiguration': {
                saveprofilesassignment: me.saveProfilesAssignment,
                globalprofilechanged: me.globalProfileChanged
            }
        });
    },

    onLaunch: function () {
        this.reset();
    },

    reset: function () {
        this.getStore('Suncode.passwordpolicy.store.PasswordProfileStore').load();
        this.getStore('Suncode.passwordpolicy.store.ProfileAssignmentStore').load();
    },

    selectedProfileChanged: function (selectedProfiles) {
        if (selectedProfiles.length > 0) {
            var selected = selectedProfiles[0];
            this.getProfileConfiguration().loadProfileConfiguration(selected);
        }
        else {
            this.getProfileConfiguration().reset();
        }
    },

    showNewProfileWindow: function () {
        var me = this;
        var newProfileWindow = Ext4.create('Suncode.passwordpolicy.view.NewProfileConfigurationWindow');
        newProfileWindow.on('profileadded', function () {
            newProfileWindow.close();
            PW.ui.Message.success(PW.t('Profil_zostal_pomyslnie_dodany'));
            me.reset();
        }, this, {single: true});

        newProfileWindow.show();
    },

    selectProfile: function (profileId, isDefaultProfile) {
        var profilesListStore = this.getStore('Suncode.passwordpolicy.store.PasswordProfileStore');
        var changedProfileIndex = profilesListStore.findBy(function (record) {
            if (record.get('id') == profileId && record.get("defaultProfile") == isDefaultProfile) {
                return true;
            }
        });

        if (changedProfileIndex > 0) {
            var changedProfile = profilesListStore.getAt(changedProfileIndex);
            this.getProfilesList().getSelectionModel().select([changedProfile]);
        }
    },

    showDeleteProfileWindow: function () {
        var me = this;
        var selectedProfiles = this.getProfilesList().getSelectionModel().selected;

        if (selectedProfiles.length > 0) {
            var selectedProfile = selectedProfiles.getAt(0);

            Ext4.Msg.show({
                title: PW.t('warningTitle'),
                msg: PW.t('Czy_na_pewno_chcesz_usunac_profil', selectedProfile.data.profileKey),
                buttons: Ext4.Msg.YESNO,
                icon: Ext4.Msg.QUESTION,
                fn: function (button) {
                    if (button === 'yes') {
                        var mask = new Ext4.LoadMask({target: me.getViewport()});
                        mask.show();

                        jQuery.ajax({
                            method: 'DELETE',
                            url: 'api/password/policy/profile/' + selectedProfile.data.id,
                            complete: function () {
                                mask.destroy();
                                me.reset();
                            },
                            success: function () {
                                PW.ui.Message.success(PW.t('Profil_zostal_pomyslnie_usuniety'));
                            },
                            error: function () {
                                PW.ui.Message.error(PW.t('Blad_podczas_usuwania_profilu'));
                            }
                        });
                    }
                }
            });
        }
    },

    profileSaved: function (profileId) {
        var me = this;
        PW.ui.Message.success(PW.t('Pomyslnie_zapisano_profil'));

        var profilesListStore = this.getStore('Suncode.passwordpolicy.store.PasswordProfileStore');
        profilesListStore.on('load', function () {
            me.selectProfile(profileId, false);
        }, this, {single: true});

        this.reset();
    },

    savePriorities: function (priorities) {
        var profileIds = [];
        priorities.forEach(function (priority) {
            if (!priority.defaultProfile)
                profileIds.push(priority.id);
        });

        var me = this;
        var mask = new Ext4.LoadMask({target: this.getProfilesList()});
        mask.show();

        jQuery.ajax({
            url: 'api/password/policy/profiles/priorities/update',
            method: 'POST',
            data: JSON.stringify(profileIds),
            contentType: 'application/json',
            complete: function () {
                mask.destroy();
            },
            success: function () {
                PW.ui.Message.success(PW.t('Priorytety_profili_zostaly_zapisane'));
                me.reset();
            },
            error: function () {
                PW.ui.Message.error(PW.t('Wystapil_blad_podczas_zapisywania_priorytetow'));
            }
        })
    },

    saveProfilesAssignment: function () {
        var me = this;
        var gridMask = new Ext4.LoadMask({target: this.getProfilesAssignment()});
        var globalProfileMask = new Ext4.LoadMask({target: this.getGlobalProfileConfiguration()});
        gridMask.show();
        globalProfileMask.show();

        var data = {groupsAssignment: []};
        me.getStore('Suncode.passwordpolicy.store.ProfileAssignmentStore').each(function (assignment) {
            var item = {
                groupId: assignment.get('groupId'),
                groupName: assignment.get('groupName')
            };

            if (!assignment.get('profileKey')) {
                item.notAssigned = true;
            }
            else {
                item.notAssigned = false;
                item.groupId = assignment.get('groupId');
                item.groupName = assignment.get('groupName');
                item.profileId = assignment.get('profileId');
                item.profileKey = assignment.get('profileKey');
                item.defaultProfile = assignment.get('defaultProfile');
            }

            data.groupsAssignment.push(item);
        });

        data.globalProfile = {};
        var globalProfile = me.getGlobalProfileConfiguration().globalProfile;
        if (globalProfile) {
            data.globalProfile.notAssigned = false;

            var defaultProfile = globalProfile.get('defaultProfile');
            data.globalProfile.defaultProfile = defaultProfile;

            if (defaultProfile) {
                data.globalProfile.profileKey = globalProfile.get('profileKey');
            }
            else {
                data.globalProfile.profileId = globalProfile.get('id');
            }
        }
        else {
            data.globalProfile.notAssigned = true;
        }

        jQuery.ajax({
            url: 'api/password/policy/assignments/update',
            method: 'POST',
            data: JSON.stringify(data),
            contentType: 'application/json',
            complete: function () {
                gridMask.destroy();
                globalProfileMask.destroy();
            },
            success: function () {
                PW.ui.Message.success(PW.t('Pomyslnie_zapisano_przypisania_profili'));

                me.getGlobalProfileConfiguration().reset();
                me.reset();
            },
            error: function () {
                PW.ui.Message.error(PW.t('Wystapil_blad_przy_zapisywaniu_przypisan_profili'));
            }
        });
    },

    globalProfileChanged: function (globalProfile) {
        var assignment = this.getProfilesAssignment();

        if (globalProfile) {
            assignment.notChoosenProfileText = globalProfile.get('name');
        }
        else {
            assignment.notChoosenProfileText = PW.t('Nie_wybrano');
        }

        assignment.getView().refresh();
    }
});
