Ext.namespace( 'Ext.ux.plusmpm' );

function executeJasperReportCreation() {
    var reportName = document.getElementById( "reportName" ).value;
    var reportDefinitionPath = document.getElementById( "reportDefinitionPath" ).value;

    Ext.Ajax.request( {
        url: 'com.plusmpm.servlet.ValidateJasperReportCreation.customServlet',
        method: 'POST',
        params: {
            reportName: reportName,
            reportDefinitionPath: reportDefinitionPath
        },
        success: function( response ) {
            checkExtForm();
            document.forms["varForm"].action = "JasperReportCreate.do?source=jasper";
            document.forms["varForm"].submit();
        },
        failure: function( response ) {
            Ext.Msg.show( {
                msg: response.responseText,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            } );
        }
    } );
}

function checkExtForm() {
    var objParameterGrid = Ext.StoreMgr.get( 'reportParameterGrid' );
    var parametersId = "";
    var parametersName = "";
    var parametersType = "";
    var objListParameterValueGrid = Ext.StoreMgr.get( 'reportListParameterValueGrid' );
    var listParametersId = "";
    var listParametersValueId = "";
    var listParametersValueDisplay = "";
    var field = null;

    if ( objParameterGrid ) {
        for ( i = 0; i < objParameterGrid.data.length; i++ ) {
            var row = objParameterGrid.data.items[i];
            var param = row.data['parameterId'];
            if ( parametersId !== "" )
                parametersId += ";";
            parametersId += param;

            param = row.data['parameterName'];
            if ( parametersName !== "" )
                parametersName += ";";
            parametersName += param;

            param = row.data['parameterType'];
            if ( parametersType !== "" )
                parametersType += ";";
            parametersType += param;
        }

        hiddenObjParameterId = document.getElementById( "reportParametersId" );
        hiddenObjParameterId.value = parametersId;

        hiddenObjParameterName = document.getElementById( "reportParametersName" );
        hiddenObjParameterName.value = parametersName;

        hiddenObjParameterType = document.getElementById( "reportParametersType" );
        hiddenObjParameterType.value = parametersType;
    }

    if ( objListParameterValueGrid ) {
        for ( i = 0; i < objListParameterValueGrid.data.length; i++ ) {
            var row = objListParameterValueGrid.data.items[i];
            var param = row.data['parameterId'];
            if ( listParametersId !== "" )
                listParametersId += ";";
            listParametersId += param;

            param = row.data['parameterValueId'];
            if ( listParametersValueId !== "" )
                listParametersValueId += ";";
            listParametersValueId += param;

            param = row.data['parameterValueDisplay'];
            if ( listParametersValueDisplay !== "" )
                listParametersValueDisplay += ";";
            listParametersValueDisplay += param;
        }

        field = document.getElementById( "reportListParametersId" );
        field.value = listParametersId;

        field = document.getElementById( "reportListParametersValueId" );
        field.value = listParametersValueId;

        field = document.getElementById( "reportListParametersValueDisplay" );
        field.value = listParametersValueDisplay;
    }

    return false;
}

/**
 * Dodatkowe parametry konfiguracyjne: config.reportId : String
 */
Ext.ux.plusmpm.ReportParametersGrid = function( config ) {

    var proxy = new Ext.data.HttpProxy( {
        url: 'com.plusmpm.servlet.extension.GetJasperReportParameters.customServlet'
    } );

    var store = new Ext.data.JsonStore( {
        proxy: proxy,
        root: 'records',
        autoDestroy: true,
        storeId: 'reportParameterGrid',
        baseParams: {
            reportId: config.reportId
        },
        fields: [ {
            name: 'id',
            type: 'int'
        }, {
            name: 'parameterId',
            type: 'string'
        }, {
            name: 'parameterName',
            type: 'string'
        }, {
            name: 'parameterType',
            type: 'string'
        } ],
        idProperty: 'id',
        sortInfo: {
            field: 'id',
            direction: 'ASC'
        }
    } );

    store.load();

    var fm = Ext.form;
    var ctxMenu = null;
    var ctxMenuDeleteItem = null;
    var ctxMenuShowValuesItem = null

    var view = new Ext.grid.GridView( {
        autoFill: true,
        forceFit: true
    } );

    Ext.util.Format.comboRenderer = function( combo ) {
        return function( value ) {
            var record = combo.findRecord( combo.valueField, value );
            return record ? record.get( combo.displayField ) : combo.valueNotFoundText;
        }
    }

    var warningTitle = this.warningTitle;
    var conirmChangeListType = this.conirmChangeListType;
    var noParameterIdDefined = this.noParameterIdDefined;
    var notUniqueId = this.notUniqueId;

    // create the combo instance
    var combo = new Ext.form.ComboBox( {
        typeAhead: true,
        forceSelection: true,
        allowBlank : false,
        triggerAction: 'all',
        lazyRender: true,
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            id: 0,
            fields: [ 'valueText', 'displayText' ],
            data: [ [ 'string', 'Text' ], [ 'integer', 'Integer' ], [ 'float', 'Float' ], [ 'date', 'Date' ], [ 'list', 'List' ],
                            [ 'username', 'USERNAME' ] ]
        } ),
        valueField: 'valueText',
        displayField: 'displayText',
        oldValue: '',
        listeners: {
        	beforeselect: function( combo, record, index ) {
        		this.oldValue = combo.getValue();
        		
        	},
            select: function( combo, record, index ) {
                var comboValue = combo.getValue();
				var gridEditor = combo.gridEditor;
                var rowNumber = gridEditor.row;
                var comboRecord = store.getAt( rowNumber );
                
                if(this.oldValue === 'list') {
					if ( comboValue !== 'list' ) {
						combo.fireEvent( 'blur' );
	                    Ext.Msg.show( {
	                        title: warningTitle,
	                        msg: conirmChangeListType,
	                        buttons: Ext.Msg.YESNO,
	                        icon: Ext.Msg.WARNING,
	                        fn: function(btn) {
	                        	if(btn === 'no') {
	                        		combo.reset();
					                comboRecord.set( 'parameterType', 'list' );
	                        	}
	                        }
	                    } );
	                }
            	}
                else {
	                if ( comboValue !== 'list' ) {
	                    return;
	                }
	
	                combo.fireEvent( 'blur' );
	                var parameterId = comboRecord.get( 'parameterId' );
	
	                if ( parameterId === '' ) {
	                    comboRecord.set( 'parameterType', 'string' );
	                    Ext.Msg.show( {
	                        title: warningTitle,
	                        msg: noParameterIdDefined,
	                        buttons: Ext.Msg.OK,
	                        icon: Ext.Msg.WARNING
	                    } );
	                    return;
	                }
	
	                var counter = 0;
	                var controlIndex = 0;
	                var startIndex = 0;
	                while ( controlIndex !== -1 ) {
	                    controlIndex = store.find( 'parameterId', parameterId, startIndex );
	                    if ( controlIndex !== -1 ) {
	                        counter++;
	                        startIndex = controlIndex + 1;
	                    }
	                }
	
	                if ( counter > 1 ) {
	                    comboRecord.set( 'parameterId', '' );
	                    comboRecord.set( 'parameterName', '' );
	                    comboRecord.set( 'parameterType', 'string' );
	                    Ext.Msg.show( {
	                        title: warningTitle,
	                        msg: notUniqueId,
	                        buttons: Ext.Msg.OK,
	                        icon: Ext.Msg.WARNING
	                    } );
	                    return;
	                }
	
	                var window = new Ext.ux.plusmpm.ListParameterValueWindow( {
	                    parameterId: parameterId,
	                    comboRecord: comboRecord
	                } );
	            }
            }
        }
    } );

    var grid = new Ext.grid.EditorGridPanel( {
        id: 'report_parameters_grid',
        store: store,
        view: view,
        loadMask: true,
        columnLines: true,
        autoScroll: true,
        height: 300,
        renderTo: 'editor-grid',
        autoExpandColumn: 'parameterTypeId',
        columns: [ {
            header: this.reportParameterIdHeader,
            sortable: true,
            dataIndex: 'parameterId',
            width: 200,
            editor: new fm.TextField( {
                allowBlank: false,
                stripCharsRe: ';'
            } )
        }, {
            header: this.reportParameterNameHeader,
            sortable: true,
            dataIndex: 'parameterName',
            width: 200,
            editor: new fm.TextField( {
                allowBlank: false,
                stripCharsRe: ';'
            } )
        }, {
            id: 'parameterTypeId',
            header: this.reportParameterTypeHeader,
            sortable: true,
            dataIndex: 'parameterType',
            width: 200,
            editor: combo,
            renderer: Ext.util.Format.comboRenderer( combo )
        } ],
        clicksToEdit: 1,
        tbar: [ {
            xtype: 'button',
            id: 'add_parameter_button',
            cls: 'x-btn-text-icon',
            iconCls: 'dvnt-icon-plus-symbol',
            text: this.addParameter,
            handler: function() {
                var Paremeter = grid.getStore().recordType;
                var p = new Paremeter( {
                    id: 1,
                    parameterId: '',
                    parameterName: '',
                    parameterType: 'string'
                } );
                grid.stopEditing();
                store.add( p );
                var iCount = store.getCount();
                grid.startEditing( iCount - 1, 0 );
            }
        }, {
            xtype: 'button',
            id: 'remove_parameter_button',
            cls: 'x-btn-text-icon',
            iconCls: 'dvnt-icon-x-symbol',
            text: this.removeParameter,
            handler: function( oButton, oEvent ) {
                var index = grid.getSelectionModel().getSelectedCell();

                if ( !index ) {
                    return false;
                }

                var rowNumber = index[0];
                var record = store.getAt( rowNumber );
                var parameterType = record.get( 'parameterType' );

                if ( parameterType === 'list' ) {
                    var parameterId = record.get( 'parameterId' );
                    deleteValuesForParameter( parameterId );
                }

                grid.stopEditing();
                store.removeAt( rowNumber );
                grid.getView().refresh();
            }
        } ],
        listeners: {
            cellcontextmenu: function( grid, rowIndex, cellIndex, e ) {
                e.stopEvent();
                grid.getSelectionModel().select( rowIndex, cellIndex );
                var record = store.getAt( rowIndex );
                var parameterId = record.get( 'parameterId' );
                var parameterType = record.get( 'parameterType' );
                if ( parameterType === 'list' ) {
                    ctxMenuShowValuesItem.show();
                    e.parameterId = parameterId;
                    var values = getValuesForParameter( parameterId )
                    e.values = values;
                } else {
                    ctxMenuShowValuesItem.hide();
                }
                ctxMenu.showAt( e.getXY() );
            }
        }
    } );

    ctxMenu = new Ext.menu.Menu( {
        id: 'context_menu',
        renderTo: document.body
    } );

    ctxMenuDeleteItem = new Ext.menu.Item( {
        id: 'context_menu_delete_item',
        cls: 'x-btn-text-icon',
        icon: 'style/img/fam/delete.png',
        text: this.removeParameter
    } );
    ctxMenuDeleteItem.on( 'click', function( item, e ) {
        ctxMenu.hide();
        document.getElementById( 'remove_parameter_button' ).click();
    } );
    ctxMenu.addMenuItem( ctxMenuDeleteItem );

    ctxMenuShowValuesItem = new Ext.menu.Item( {
        id: 'context_menu_show_values_item',
        cls: 'x-btn-text-icon',
        icon: 'style/img/fam/page_white_wrench.png',
        text: this.showValuesItemText
    } );
    ctxMenuShowValuesItem.on( 'click', function( item, e ) {
        ctxMenu.hide();
        parameterId = e.parameterId;
        values = e.values;
        var window = new Ext.ux.plusmpm.ListParameterValueWindow( {
            parameterId: parameterId,
            values: values
        } );
    } );
    ctxMenu.addMenuItem( ctxMenuShowValuesItem );

    Ext.ux.plusmpm.ReportParametersGrid.superclass.constructor.call( this, config );
}; // end of Ext.ux.plusmpm.ProcessAssignmentsWindow constructor

Ext.extend( Ext.ux.plusmpm.ReportParametersGrid, Ext.Window, {

    reportParameterIdHeader: PW.t('reportParameterIdHeader'),

    reportParameterNameHeader: PW.t('reportParameterNameHeader'),

    reportParameterTypeHeader: PW.t('reportParameterTypeHeader'),

    addParameter: PW.t('addParameter'),

    removeParameter: PW.t('removeParameter'),

    windowTitle: PW.t('reportParameter'),

    falseText: PW.t('falseText'),

    trueText: PW.t('trueText'),

    warningTitle: PW.t('warningTitle'),

    noParameterIdDefined: PW.t('noParameterIdDefined'),

    showValuesItemText: PW.t('showValuesItemText'),

    notUniqueId: PW.t('notUniqueId'),
    
    conirmChangeListType: PW.t('conirmChangeListType'),

    initComponent: function() {
        Ext.ux.plusmpm.ReportParametersGrid.superclass.initComponent.call( this );
    }
} ); // end of Ext.extend

/**
 * Dodatkowe parametry konfiguracyjne: config.reportId : String
 */
Ext.ux.plusmpm.ReportListParametersValueGrid = function( config ) {

    var proxy = new Ext.data.HttpProxy( {
        url: 'com.plusmpm.servlet.extension.GetJasperReportListParametersValues.customServlet'
    } );

    var store = new Ext.data.JsonStore( {
        proxy: proxy,
        root: 'records',
        autoDestroy: true,
        storeId: 'reportListParameterValueGrid',
        baseParams: {
            reportId: config.reportId
        },
        fields: [ {
            name: 'parameterId',
            type: 'string'
        }, {
            name: 'parameterValueId',
            type: 'string'
        }, {
            name: 'parameterValueDisplay',
            type: 'string'
        } ]
    } );

    store.load();

    var view = new Ext.grid.GridView( {
        autoFill: true,
        forceFit: true
    } );

    var grid = new Ext.grid.GridPanel( {
        id: 'report_list_parameters_value_grid',
        store: store,
        view: view,
        columnLines: true,
        autoScroll: true,
        width: 600,
        height: 300,
        renderTo: 'editor-grid',
        hidden: true,
        columns: [ {
            header: this.reportParameterIdHeader,
            sortable: true,
            dataIndex: 'parameterId',
            width: 100
        }, {
            header: this.reportParameterValueIdHeader,
            sortable: true,
            dataIndex: 'parameterValueId',
            width: 250
        }, {
            header: this.reportParameterValueDisplayHeader,
            sortable: true,
            dataIndex: 'parameterValueDisplay',
            width: 250
        } ]
    } );

    Ext.ux.plusmpm.ReportListParametersValueGrid.superclass.constructor.call( this );
}; // end of Ext.ux.plusmpm.ReportListParametersValueGrid constructor

Ext.extend( Ext.ux.plusmpm.ReportListParametersValueGrid, Ext.Window, {

    reportParameterIdHeader: PW.t('reportParameterIdHeader'),

    reportParameterValueIdHeader: PW.t('reportParameterValueIdHeader'),

    reportParameterValueDisplayHeader: PW.t('reportParameterValueDisplayHeader'),

    initComponent: function() {
        Ext.ux.plusmpm.ReportListParametersValueGrid.superclass.initComponent.call( this );
    }
} ); // end of Ext.extend

/**
 * Dodatkowe parametry konfiguracyjne: config.parameterId : String
 * config.comboRecord : Ext.data.Record config.values : Ext.data.Record[]
 */
Ext.ux.plusmpm.ListParameterValueWindow = function( config ) {

    var valueWindow = null;
    var values = config.values;

    var reader = new Ext.data.JsonReader( {
        id: 'reportOneListParameterValueReader',
        fields: [ {
            name: 'parameterValueId',
            type: 'string'
        }, {
            name: 'parameterValueDisplay',
            type: 'string'
        } ]
    } );

    var store = new Ext.data.Store( {
        autoDestroy: true,
        storeId: 'reportOneListParameterValueGrid',
        reader: reader,
        fields: [ {
            name: 'parameterValueId',
            type: 'string'
        }, {
            name: 'parameterValueDisplay',
            type: 'string'
        } ]
    } );

    if ( values && values.length > 0 ) {
        for ( var i = 0; i < values.length; i++ ) {
            store.add( values[i] );
        }

        store.commitChanges();
    }

    var oneListParameterValue = Ext.data.Record.create( [ {
        name: 'parameterValueId',
        type: 'string'
    }, {
        name: 'parameterValueDisplay',
        type: 'string'
    }, ] );

    var listParameterValue = Ext.data.Record.create( [ {
        name: 'parameterId',
        type: 'string'
    }, {
        name: 'parameterValueId',
        type: 'string'
    }, {
        name: 'parameterValueDisplay',
        type: 'string'
    }, ] );

    var view = new Ext.grid.GridView( {
        autoFill: true,
        forceFit: true
    } );

    var grid = new Ext.grid.EditorGridPanel( {
        id: 'report_one_list_parameter_value_grid',
        store: store,
        view: view,
        columnLines: true,
        autoScroll: true,
        width: 400,
        height: 250,
        columns: [ {
            header: this.reportParameterValueIdHeader,
            sortable: true,
            dataIndex: 'parameterValueId',
            width: 250,
            editor: new Ext.form.TextField( {
                allowBlank: false,
                stripCharsRe: ';'
            } )
        }, {
            header: this.reportParameterValueDisplayHeader,
            sortable: true,
            dataIndex: 'parameterValueDisplay',
            width: 250,
            editor: new Ext.form.TextField( {
                allowBlank: false,
                stripCharsRe: ';'
            } )
        } ],
        tbar: [ {
            id: 'add_list_value_button',
            text: this.addValue,
            handler: function() {
                var record = new oneListParameterValue( {
                    parameterValueId: '',
                    parameterValueDisplay: ''
                } );
                grid.stopEditing();
                store.add( record );
                var iCount = store.getCount();
                grid.startEditing( iCount - 1, 0 );
            }
        }, {
            id: 'remove_list_value_button',
            text: this.removeValue,
            handler: function( oButton, oEvent ) {
                var index = grid.getSelectionModel().getSelectedCell();
                if ( !index ) {
                    return false;
                }
                grid.stopEditing();
                store.removeAt( index[0] );
                grid.getView().refresh();
            }
        } ],
        listeners: {
            afteredit: function( obj ) {
                var record = obj.record;
                record.commit();
            }
        }
    } );

    var valueForm = new Ext.FormPanel( {
        id: 'list_parameter_value_panel',
        frame: true,
        layout: 'form',
        labelWidth: 200,
        labelAlign: 'top',
        buttonAlign: 'center'
    } );

    valueForm.add( grid );

    var warningTitle = this.warningTitle;
    var noValuesAdded = this.noValuesAdded;
    var emptyValueFound = this.emptyValueFound;
    var notUniqueId = this.notUniqueId;

    var saveValuesButton = new Ext.Button( {
        id: 'save_list_parameter_values_button',
        text: this.saveValuesButtonLabel,
        cls: 'x-btn-text',
        handler: function() {
            var records = grid.getStore().getRange();

            if ( records.length == 0 ) {
                Ext.Msg.show( {
                    title: warningTitle,
                    msg: noValuesAdded,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                } );
                return;
            } else {
                var correct = true;
                for ( var i = 0; i < records.length; i++ ) {
                    var testValue = records[i].get( 'parameterValueId' );

                    if ( !testValue || testValue === '' ) {
                        Ext.Msg.show( {
                            title: warningTitle,
                            msg: emptyValueFound,
                            buttons: Ext.Msg.OK,
                            icon: Ext.Msg.WARNING
                        } );
                        correct = false;
                        break;
                    }

                    var counter = 0;
                    var controlIndex = 0;
                    var startIndex = 0;
                    while ( controlIndex !== -1 ) {
                        controlIndex = store.findExact( 'parameterValueId', testValue, startIndex );
                        if ( controlIndex !== -1 ) {
                            counter++;
                            startIndex = controlIndex + 1;
                        }
                    }

                    if ( counter > 1 ) {
                        Ext.Msg.show( {
                            title: warningTitle,
                            msg: notUniqueId,
                            buttons: Ext.Msg.OK,
                            icon: Ext.Msg.WARNING
                        } );
                        correct = false;
                        break;
                    }
                }

                if ( !correct ) {
                    return;
                }
            }

            deleteValuesForParameter( config.parameterId );
            var reportListParametersValueGrid = Ext.getCmp( 'report_list_parameters_value_grid' );
            var allListValuesStore = reportListParametersValueGrid.getStore();

            for ( var i = 0; i < records.length; i++ ) {
                var record = new listParameterValue( {
                    parameterId: config.parameterId,
                    parameterValueId: records[i].get( 'parameterValueId' ),
                    parameterValueDisplay: records[i].get( 'parameterValueDisplay' )
                } );

                allListValuesStore.add( record );
            }

            allListValuesStore.commitChanges();
            valueWindow.close();
        }
    } );

    var closeButton = new Ext.Button( {
        id: 'close_list_parameter_value_window_button',
        text: this.closeButtonLabel,
        cls: 'x-btn-text',
        handler: function() {
            valueWindow.close();
            var comboRecord = config.comboRecord;

            if ( comboRecord ) {
                comboRecord.set( 'parameterType', 'string' );
            }
        }
    } );

    valueForm.addButton( saveValuesButton );
    valueForm.addButton( closeButton );

    valueWindow = new Ext.Window( {
        id: 'reports_list_parameter_value_window',
        modal: true,
        autoWidth: true,
        autoHeight: true,
        title: this.parameterValueWindowTitle + ' ' + config.parameterId,
        items: valueForm
    } );

    Ext.ux.plusmpm.ListParameterValueWindow.superclass.constructor.call( this, config );

    valueWindow.show();
}; // end of Ext.ux.plusmpm.ListParameterValueWindow constructor

Ext.extend( Ext.ux.plusmpm.ListParameterValueWindow, Ext.Window, {

    parameterValueWindowTitle: PW.t('parameterValueWindowTitle'),

    saveValuesButtonLabel: PW.t('saveValuesButtonLabel'),

    closeButtonLabel: PW.t('closeButtonLabel'),

    reportParameterValueIdHeader: PW.t('reportParameterValueIdHeader'),

    reportParameterValueDisplayHeader: PW.t('reportParameterValueDisplayHeader'),

    addValue: PW.t('addValue'),

    removeValue: PW.t('removeValue'),

    warningTitle: PW.t('warningTitle'),

    noValuesAdded: PW.t('noValuesAdded'),

    emptyValueFound: PW.t('emptyValueFound'),

    notUniqueId: PW.t('notUniqueValueId'),

    initComponent: function() {
        Ext.ux.plusmpm.ReportListParametersValueGrid.superclass.initComponent.call( this );
    }
} ); // end of Ext.extend

function showReportParametersGrid( reportId ) {
    var reportParametersGrid = document.getElementById( 'report_parameters_grid' );
    var reportListParametersValueGrid = document.getElementById( 'report_list_parameters_value_grid' );

    if ( !reportParametersGrid ) {
        var window = new Ext.ux.plusmpm.ReportParametersGrid( {
            reportId: reportId
        } );
    }

    if ( !reportListParametersValueGrid ) {
        var window = new Ext.ux.plusmpm.ReportListParametersValueGrid( {
            reportId: reportId
        } );
    }
}

function deleteValuesForParameter( parameterId ) {
    var allListValuesGrid = Ext.getCmp( 'report_list_parameters_value_grid' );
    var allListValuesStore = allListValuesGrid.getStore();
    var rowNumberToDelete = 0;

    while ( rowNumberToDelete !== -1 ) {
        rowNumberToDelete = allListValuesStore.find( 'parameterId', parameterId );
        if ( rowNumberToDelete !== -1 ) {
            allListValuesStore.removeAt( rowNumberToDelete );
        }
    }

    allListValuesStore.commitChanges();
}

function getValuesForParameter( parameterId ) {
    var values = new Array();
    var allListValuesGrid = Ext.getCmp( 'report_list_parameters_value_grid' );
    var allListValuesStore = allListValuesGrid.getStore();
    var rowNumberToGet = 0;
    var startIndex = 0;

    while ( rowNumberToGet !== -1 ) {
        rowNumberToGet = allListValuesStore.find( 'parameterId', parameterId, startIndex );
        if ( rowNumberToGet !== -1 ) {
            var record = allListValuesStore.getAt( rowNumberToGet );
            values.push( record );
            startIndex = rowNumberToGet + 1;
        }
    }

    return values;
}