Ext.namespace('Ext.ux.plusmpm');

Ext.ux.plusmpm.PluginUploadFormPanel = function(config) {
	
	var items = [{
        xtype      : 'fileuploadfield',
        fieldLabel : this.fileLabel,
        name       : 'theFile',
        buttonText : this.fileChooseButtonText,
        emptyText  : this.fileChooseLabel
    }];
	
	var buttons = [{
		text    : this.installButtonText,
        handler : this.submitButtonHandler,
        scope   : this
    },{
        text    : this.resetButtonText,
        handler : this.resetButtonHandler,
        scope   : this
    }];
		
	config = Ext.apply({
		items      : items,
		buttons    : buttons,
		fileUpload : true,
	    width      : 800,
	    autoHeight : true,
	    frame      : false,
	    border	   : false,
	    bodyStyle  : 'padding: 10px 10px 0 10px;',
	    labelWidth : 250,
	    defaults   : {
	    	anchor     : '100%'
	    }
	}, config);

	Ext.ux.plusmpm.PluginUploadFormPanel.superclass.constructor.call(this, config);
	
}; // end of Ext.ux.plusmpm.PluginUploadFormPanel constructor

Ext.extend(Ext.ux.plusmpm.PluginUploadFormPanel, Ext.form.FormPanel, {
			
	fileLabel : PW.t('fileLabel'),

	fileChooseLabel : PW.t('fileChooseLabel'),
	
	fileChooseButtonText : PW.t('fileChooseButtonText'),
	
	fileUploadWaitMsg : PW.t('fileUploadWaitMsg'),

	title : PW.t('module-upload-title'),

	installButtonText : PW.t('installButtonText'),

	resetButtonText : PW.t('resetButtonText'),

	submitButtonHandler : function(button, eventObject)
	{
        if(this.getForm().isValid())
        {
        	this.getForm().submit({
                url     : 'com.plusmpm.servlet.plugins.InstallPluginServlet.customServlet',
                waitMsg : this.fileUploadWaitMsg,
                success : function(form, action)
                {
                	new AjaxJspTag.PreFunctionUpdateInvoke({
                		href : "PluginsConfiguration.do?source=displayTag",
                		id   : "plugins-table"
                	});
                },
                failure : function(form, action)
                {
                	alert(action.result.msg);
                }
            });
        }
	},
	
	resetButtonHandler : function(button, eventObject)
	{
		this.getForm().reset();
	}
}); // end of Ext.extend
