/**
 * Rozszerzenia standardowej biblioteki Ext JS
 * Copyright(c) 2009 Plus MPM s.c.
 */
Ext.BLANK_IMAGE_URL = Suncode.getAbsolutePath('/style/img/s.gif');

Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

Ext.apply(Ext.util.Format, {

	mpm_numberEU:function(value, metaData, record, rowIndex, colIndex, store)
	{
		//this.format dotyczy przestrzeni(scope) instancji obiektu, w ktorym jest uzywana
		var sFormatedValue = Ext.util.Format.number(value, this.format);
		sFormatedValue = sFormatedValue.replace(/\,/g, " ");
		sFormatedValue = sFormatedValue.replace(/\./g, this.editor.decimalSeparator );
		return sFormatedValue;
	} //end mpm_numberEU
}); //end Ext.apply

Ext.override(Ext.Component, {

    mpm_restoreState:function()
    {
        this.initState(null);
    }, //end mpm_restoreState

    mpm_clearState:function()
    {
        Ext.state.Manager.clear(this.getStateId());
    } //end mpm_clearState
}); //end Ext.override

Ext.override(Ext.data.Store, {

    mpm_hasPhantomRecords:function()
    {
    	var bHasPhantomRecords = false;
     	this.each(function(oNextRecord){
	        if(oNextRecord.phantom === true)
			{
				bHasPhantomRecords = true;
				return false;
			} //end if
		}); //end each
        return bHasPhantomRecords;
    }, //end mpm_hasPhantomRecords

    mpm_sum : function(property, start, end) {
		var rs = this.data.items, v = 0;
		start = start || 0;
		end = (end || end === 0) ? end : rs.length - 1;

		for ( var i = start; i <= end; i++) {
			v += parseInt(rs[i].data[property] * 10000 || 0);
		}
		return v / 10000;
	}
}); // end Ext.override

/**
 * Fix for ExtJs 3.2.2 - invalid state restore in Ext.grid.ColumnModel
 * */
Ext.override(Ext.grid.ColumnModel, {
    setState : function(col, state){
    	// code copied from ExtJs 3.3.0
        var def = Ext.apply(this.defaults, {});
        delete def.sortable;
        
        state = Ext.applyIf(state, def);
        if(state.hidden == undefined)
        	state.hidden = false;
        Ext.apply(this.config[col], state);
    } //end setState
}); //end Ext.override

/**
 * Zablokowanie BACKSPACE jako klawisza cofania do poprzedniej strony.
 * */
var extKeyMap_DisableBackspace = new Ext.KeyMap(document, [{
    key     : [Ext.EventObject.BACKSPACE],
    handler : function (nKeyCode, extEventObject) {
		var sTagName = extEventObject.getTarget().tagName;
		var sType = extEventObject.getTarget().type;
		var sReadOnly = extEventObject.getTarget().readOnly;
        if ( (sType !== "text" && sType !== "search" && sTagName !== "TEXTAREA" && sType !== "password" && sType !== "number" && sType !== "date") || sReadOnly===true) {
        	extEventObject.stopEvent();
        } //end if

    } //end Ext.KeyMap handler
}]); //end extKeyMap_DisableBackspace definition

/**
 * Fix for ExtJs 3.2.2 - unmask
 * */
Ext.override(Ext.Element, {
   unmask : Ext.Element.prototype.unmask.createSequence(function(){
       this.removeClass(['x-masked', 'x-masked-relative']);
   })
});

/**
 * Ustawienia tabIndex=-1 dla wyłączonych (disabled) przycisków
 */
Ext.override(Ext.Button, {
    
    setTabIndex: function(tabIndex){
        this.tabIndex = tabIndex;
        
        if(this.btnEl){
            this.btnEl.dom.tabIndex = this.tabIndex;
        }
    },
    
    onDisable : function(){
        this.onDisableChange(true); // oryginalna funkcja
        this.oldTabIndex = this.tabIndex;
        this.setTabIndex(-1);
    },
    
    // private
    onEnable : function(){
        this.onDisableChange(false); // oryginalna funkcja
        this.setTabIndex(this.oldTabIndex);
    }
    
}); //end Ext.override

Ext.override(Ext.Window, {
    
    frame: false
    
}); //end Ext.override

//Dodanie klasy selectable, aby można było zaznaczać tekst w komórkach tabeli
if (!Ext.grid.GridView.prototype.templates) {
    Ext.grid.GridView.prototype.templates = {};
}
Ext.grid.GridView.prototype.templates.cell = new Ext.Template(
    '<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} x-selectable {css}" style="{style}" tabIndex="0" {cellAttr}>',
        '<div class="x-grid3-cell-inner x-grid3-col-{id}" {attr}>{value}</div>',
        '</td>'
);

Ext.override(Ext.data.Connection, {

  // private
  doFormUpload : function(o, ps, url){
    var id = Ext.id(),
      doc = document,
      frame = doc.createElement('iframe'),
      form = Ext.getDom(o.form),
      hiddens = [],
      hd,
      encoding = 'multipart/form-data',
      buf = {
        target: form.target,
        method: form.method,
        encoding: form.encoding,
        enctype: form.enctype,
        action: form.action
      };

    /*
     * Originally this behaviour was modified for Opera 10 to apply the secure URL after
     * the frame had been added to the document. It seems this has since been corrected in
     * Opera so the behaviour has been reverted, the URL will be set before being added.
     */
    Ext.fly(frame).set({
      id: id,
      name: id,
      cls: 'x-hidden',
      src: Ext.SSL_SECURE_URL
    });

    doc.body.appendChild(frame);

    // This is required so that IE doesn't pop the response up in a new window.
    if(Ext.isIE){
      document.frames[id].name = id;
    }


    Ext.fly(form).set({
      target: id,
      method: "POST",
      enctype: encoding,
      encoding: encoding,
      action: url || buf.action
    });

    // add dynamic params
    Ext.iterate(Ext.urlDecode(ps, false), function(k, v){
      hd = doc.createElement('input');
      Ext.fly(hd).set({
        type: 'hidden',
        value: v,
        name: k
      });
      form.appendChild(hd);
      hiddens.push(hd);
    });

    // PWFL-11449
    if (!Suncode.isExternalUrl(url || buf.action)) {
      hd = doc.createElement('input');
      Ext.fly(hd).set({
        type: 'hidden',
        value: Suncode.getCsrfToken(),
        name: Suncode.getCsrfParameterName()
      });
      form.appendChild(hd);
      hiddens.push(hd);
    }

    function cb(){
      var me = this,
        // bogus response object
        r = {responseText : '',
          responseXML : null,
          argument : o.argument},
        doc,
        firstChild;

      try{
        doc = frame.contentWindow.document || frame.contentDocument || window.frames[id].document;
        if(doc){
          if(doc.body){
            if(/textarea/i.test((firstChild = doc.body.firstChild || {}).tagName)){ // json response wrapped in textarea
              r.responseText = firstChild.value;
            }else{
              r.responseText = doc.body.innerHTML;
            }
          }
          //in IE the document may still have a body even if returns XML.
          r.responseXML = doc.XMLDocument || doc;
        }
      }
      catch(e) {}

      Ext.EventManager.removeListener(frame, "load", cb, me);

      me.fireEvent("requestcomplete", me, r, o);

      function runCallback(fn, scope, args){
        if(Ext.isFunction(fn)){
          fn.apply(scope, args);
        }
      }

      runCallback(o.success, o.scope, [r, o]);
      runCallback(o.callback, o.scope, [o, true, r]);

      if(!me.debugUploads){
        setTimeout(function(){Ext.removeNode(frame);}, 100);
      }
    }

    Ext.EventManager.on(frame, "load", cb, this);
    form.submit();

    Ext.fly(form).set(buf);
    Ext.each(hiddens, function(h) {
      Ext.removeNode(h);
    });
  }

});

Ext.override(Ext.form.BasicForm, {
  submit : function(options){
    options = options || {};
    if(this.standardSubmit){
      var v = options.clientValidation === false || this.isValid();
      if(v){
        var el = this.el.dom;
        if(this.url && Ext.isEmpty(el.action)){
          el.action = this.url;
        }

        // PWFL-11449
        if (!Suncode.isExternalUrl(el.action)) {
          Suncode.applyCsrfTokenToForm(el);
        }

        el.submit();
      }
      return v;
    }
    var submitAction = String.format('{0}submit', this.api ? 'direct' : '');
    this.doAction(submitAction, options);
    return this;
  },
});
