/** ******************************************************** */
/* Ext.ux.plusmpm.NotificationPopupWindow */
/** ****************************************************** */

Ext.ux.plusmpm.NotificationTranslationPanel = function( config ) {

    // writer służący do zapisywania danych po stronie serwera
    var writer = new Ext.data.JsonWriter( {
        encode: true,
        writeAllFields: true
    } );

    var addButton = new Ext.Button( {
        id: 'translationAddButton',
        text: this.specify_notifications,
        handler: function() {
            this.store.load( {
                params: {
                    processId: this.processId,
                    type: 'empty'
                }
            } );
            Ext.getCmp( 'translationAddButton' ).setVisible( false );
            Ext.getCmp( 'translationDeleteButton' ).setVisible( true );

        },
        iconCls: 'dvnt-icon-plus-symbol',
        scope: this
    } );
    addButton.setVisible( false );

    var deleteButton = new Ext.Button( {
        id: 'translationDeleteButton',
        text: this.remove_specify,
        handler: function() {
            this.store.removeAll();
            this.store.save();

            Ext.getCmp( 'translationAddButton' ).setVisible( true );
            Ext.getCmp( 'translationDeleteButton' ).setVisible( false );
        },
        iconCls: 'dvnt-icon-x-symbol',
        scope: this
    } );
    deleteButton.setVisible( false );

    var enableNotifs = new Ext.Button( {
        id: 'enableNotifsButton',
        text: 'Włącz powiadomienia w systemie',
        handler: function() {
            this.store.removeAll();
            this.store.save();

            Ext.getCmp( 'enableNotifsButton' ).setVisible( true );
            Ext.getCmp( 'disableNotifsButton' ).setVisible( false );
        },
        iconCls: 'dvnt-icon-x-symbol',
        scope: this
    } );
    enableNotifs.setVisible( false );

    var disableNotifs = new Ext.Button( {
        id: 'disableNotifsButton',
        text: 'Włącz powiadomienia w systemie',
        handler: function() {
            this.store.removeAll();
            this.store.save();

            Ext.getCmp( 'enableNotifsButton' ).setVisible( true );
            Ext.getCmp( 'disableNotifsButton' ).setVisible( false );
        },
        iconCls: 'dvnt-icon-x-symbol',
        scope: this
    } );
    disableNotifs.setVisible( false );

    var tb = new Ext.Toolbar( {
        items: [ {
            text: this.edit,
            handler: function() {
                var cell = this.selModel.getSelectedCell();
                var record = this.store.getAt( cell[0] );
                var fieldName = this.colModel.getDataIndex( cell[1] );
                var data = record.get( fieldName );

                new Ext.ux.plusmpm.AddingNewVariableForm( {
                    processId: this.processId,
                    record: record,
                    field: fieldName
                } ).show();
            },
            scope: this,
            iconCls: 'dvnt-icon-edit-form',
            disabled: true,
            ref: 'editButton'
        }, {
            text: this.save,
            handler: function() {
                this.store.save();
            },
            scope: this,
            iconCls: 'dvnt-icon-save',
            disabled: true,
            ref: 'saveButton'
        }, {
            text: this.cancel,
            handler: function() {
                this.store.rejectChanges();
            },
            scope: this,
            iconCls: 'dvnt-icon-x-circle',
            disabled: true,
            ref: 'cancelButton'
        }, {
            xtype: 'tbfill'
        }, disableNotifs, enableNotifs, addButton, deleteButton ]
    } );

    var messagesStore = new Ext.data.JsonStore( {
        autoSave: false,
        autoDestroy: true,
        batch: false,
        successProperty: 'success',
        messageProperty: 'message',
        writer: writer,
        root: 'records',
        url: 'com.plusmpm.servlet.notifications.NotificationConfigurationGridServlet.customServlet',
        fields: [ {
            name: 'id',
            type: 'int'
        }, {
            name: 'activityDeliver',
            type: 'string'
        }, {
            name: 'activityEnd',
            type: 'string'
        }, {
            name: 'processEnd',
            type: 'string'
        }, {
            name: 'lang',
            type: 'string'
        }, {
            name: 'enabled',
            type: 'bool'
        }, {
            name: 'processDefId',
            type: 'string'
        } ],
        listeners: {
            load: function (store) {
                store.each(function (record) {
                    const encodedActivityDeliver = Ext.util.Format.htmlEncode(record.get('activityDeliver'));
                    record.set('activityDeliver', encodedActivityDeliver);
                    const encodedActivityEnd = Ext.util.Format.htmlEncode(record.get('activityEnd'));
                    record.set('activityEnd', encodedActivityEnd);
                    const encodedProcessEnd = Ext.util.Format.htmlEncode(record.get('processEnd'));
                    record.set('processEnd', encodedProcessEnd);
                });
                store.commitChanges();
            }
        }
    } );

    messagesStore.on( 'save', function( store, batch, data ) {
        store.commitChanges();
    } );

    var view = new Ext.grid.GridView( {
        autoFill: true,
        forceFit: true
    } );

    messagesStore.on( 'exception', function( misc ) {
        Ext.Msg.show( {
            title: this.error,
            msg: this.error_appear,
            buttons: Ext.Msg.OK,
            icon: Ext.MessageBox.WARNING
        } );
    } );

    config = Ext.apply( {

        store: messagesStore,
        disabled: true,
        loadMask: true,
        view: view,
        stateful: true,
        tbar: tb,
        stateId: 'notification-configuration-grid',
        columns: [ {
            width: 20,
            header: this.language_version,
            sortable: true,
            dataIndex: 'lang',
            editable: false
        }, {
            width: 100,
            header: this.end_of_task,
            sortable: true,
            dataIndex: 'activityEnd',
            editable: true,
            editor: new Ext.form.TextArea( {} )
        }, {
            width: 100,
            header: this.end_of_process,
            sortable: true,
            dataIndex: 'processEnd',
            editable: true,
            editor: new Ext.form.TextArea( {} )
        }, {
            width: 100,
            header: this.activity_delivered,
            sortable: true,
            dataIndex: 'activityDeliver',
            editable: true,
            editor: new Ext.form.TextArea( {} )
        } ],

        sm: new Ext.grid.CellSelectionModel( {
            listeners: {
                scope: this,
                selectionchange: function( selectionModel ) {
                    var disabled = !( selectionModel.hasSelection() );

                    this.getTopToolbar().cancelButton.setDisabled( disabled );
                    this.getTopToolbar().saveButton.setDisabled( disabled );
                    this.getTopToolbar().editButton.setDisabled( disabled );
                }
            }
        } ),

        processId: null,

        initForProcess: function( procDefId ) {
            this.enable();
            this.store.load( {
                params: {
                    processId: this.processId
                },
                callback: function( recs ) {

                    Ext.getCmp( 'enableNotifsButton' ).setVisible( false );
                    Ext.getCmp( 'disableNotifsButton' ).setVisible( false );

                    if ( recs.length == 0 ) {
                        Ext.getCmp( 'translationAddButton' ).setVisible( true );
                        Ext.getCmp( 'translationDeleteButton' ).setVisible( false );
                    }
                    else {
                        Ext.getCmp( 'translationAddButton' ).setVisible( false );
                        Ext.getCmp( 'translationDeleteButton' ).setVisible( true );
                    }
                }
            } );
        },

        initForDefault: function() {
            this.store.load( {
                params: {
                    processId: 'default_configuration'
                },
                callback: function() {
                    Ext.getCmp( 'translationAddButton' ).setVisible( false );
                    Ext.getCmp( 'translationDeleteButton' ).setVisible( false );
                }
            } );
        },

        onNodeSelectionChangeEventHandler: function( selectionModel, treeNode ) {
            this.processId = treeNode.id;
            if ( treeNode.attributes.type == 'WORKFLOW_PROCESS' ) {
                this.enable();
                this.initForProcess();
            }
            else
                if ( treeNode.isRoot ) {
                    this.enable();
                    this.initForDefault();
                }
                else {
                    this.disable();
                }
        }

    }, config );

    Ext.ux.plusmpm.NotificationTranslationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.NotificationTranslationPanel, Ext.grid.EditorGridPanel, {

    messageText: PW.t('messageText'),
    dateText: PW.t('dateText'),
    senderText: PW.t('senderText'),
    titleMessage: PW.t('titleMessage'),
    specify_notifications: PW.t('specify_notifications'),
    remove_specify: PW.t('remove_specify'),
    language_version: PW.t('language_version'),
    end_of_task: PW.t('end_of_task'),
    end_of_process: PW.t('end_of_process'),
    activity_delivered: PW.t('activity_delivered'),
    edit: PW.t('edit'),
    save: PW.t('save'),
    cancel: PW.t('cancel'),
    error_appear: PW.t('error_appear'),
    error: PW.t('error')
} );

Ext.ux.plusmpm.NotificationPanel = function( config ) {

    var translationPanel = new Ext.ux.plusmpm.NotificationTranslationPanel( {
        region: "center",
        height: 400
    } );

    var treePanel = new Ext.ux.plusmpm.NotificationConfigurationTreePanel( {
        region: 'west',
        split: true,
        collapsible: true,
        ref: 'treePanel'
    } );
    treePanel.getSelectionModel().on( "selectionchange", translationPanel.onNodeSelectionChangeEventHandler, translationPanel );

    config = Ext.apply( {
        renderTo: config.renderTo,
        disabled: config.disabled,
        height: 450,
        style: "text-align: left;",
        items: [ translationPanel, treePanel ]

    }, config );

    Ext.ux.plusmpm.NotificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.NotificationPanel, Ext.Panel, {
    layout: 'border',
    border: false,

    disableNotifs: function( callback ) {
        Ext.Ajax.request( {
            url: 'com.plusmpm.servlet.notifications.NotificationConfigurationGridServlet.customServlet',
            success: callback,
            params: {
                xaction: 'globalConfig',
                value: 'disable'
            }
        } );
    },

    enableNotifs: function( callback ) {
        Ext.Ajax.request( {
            url: 'com.plusmpm.servlet.notifications.NotificationConfigurationGridServlet.customServlet',
            success: callback,
            params: {
                xaction: 'globalConfig',
                value: 'enable'
            }
        } );
    }

} );

/**
 * Wymagane parametry:
 */
Ext.ux.plusmpm.NotificationConfigurationTreePanel = function( config ) {

    var loader = new Ext.tree.TreeLoader( {
        dataUrl: 'com.plusmpm.servlet.notifications.NotificationConfigurationTreeServlet.customServlet',
        requestMethod: 'GET'
    } );
    loader.on( "beforeload", function( treeLoader, node ) {
        if ( node.attributes.type )
            this.baseParams.type = node.attributes.type;
    } );

    config = Ext.apply( {
        autoScroll: true,
        useArrows: true,
        animate: true,
        loader: loader,
        enableDD: true,
		width: 200,

        root: new Ext.tree.AsyncTreeNode( {
            expanded: true,
            leaf: false,
            text: this.rootText,
            id: "default_configuration",
            type: "root"
        } ),

        tools: [ {
            id: 'refresh',
            handler: this.onRefresh,
            scope: this
        } ]

    }, config );

    Ext.ux.plusmpm.NotificationConfigurationTreePanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManagerTreePanel constructor

Ext.extend( Ext.ux.plusmpm.NotificationConfigurationTreePanel, Ext.tree.TreePanel, {

    title: PW.t('settings'),
    rootText: PW.t('globalSettings'),

    onRefresh: function() {
        this.getRootNode().select();
        this.getRootNode().reload();
    },

    initComponent: function() {

        Ext.ux.plusmpm.NotificationConfigurationTreePanel.superclass.initComponent.call( this );
    }

} ); // end of Ext.extend

Ext.ux.plusmpm.AddingNewVariableForm = function( config ) {
	
    var processId = config.processId;

    var field = config.field;
    var record = config.record;
    var value = record.get( field );
    
    // writer służący do zapisywania danych po stronie serwera
    var writer = new Ext.data.JsonWriter( {
        encode: true,
        writeAllFields: true
    } );

    var tmpl = "<div class=\"constants-item\"><table width = \"100%\"><tr style=\"height: 15px\">";
	tmpl = tmpl.concat( "<td width=\"100px\" style=\"text-align: center; font-weight: bold;\">" );
	tmpl = tmpl.concat( this.constants );
	tmpl = tmpl.concat( "</td>" );
	tmpl = tmpl.concat( "</tr>" );
	tmpl = tmpl.concat( "</table>" );
	tmpl = tmpl.concat( "</div>" );
	tmpl = tmpl.concat( "<tpl for=\".\">" );
	tmpl = tmpl.concat( "<tpl if=\"xindex === 15\">" );
	tmpl = tmpl.concat( "<div class=\"variables-item\"><table width = \"100%\"><tr style=\"height: 15px\">" );
	tmpl = tmpl.concat( "<td width=\"100px\" style=\"text-align: center; font-weight: bold;\">" );
	tmpl = tmpl.concat( this.variables );
	tmpl = tmpl.concat( "</td>" );
	tmpl = tmpl.concat( "</tr>" );
	tmpl = tmpl.concat( "</table>" );
	tmpl = tmpl.concat( "</div>" );
	tmpl = tmpl.concat( "</tpl>" );		
	tmpl = tmpl.concat( "<div class=\"search-item\"><table width = \"100%\"><tr style=\"height: 15px\">" );
    tmpl = tmpl.concat( "<td width=\"100px\">{variableName}</td>" );
    tmpl = tmpl.concat( "</tr></table></div></tpl>" );

    var oComboBox_tpl = new Ext.XTemplate( tmpl );

    var addingButton = new Ext.Button( {
        text: this.add_variable,
        handler: function() {
            if ( combo.getValue() != '' ) {
				var content = area.getValue();
				
				if ( area.cursorPos === null ) {
					area.setValue( content + '${' + combo.getValue() + '}' );
					return;
				}
				
				var part1 = content.substring(0, area.cursorPos);
				var part2 = '';
				
				if ( area.cursorPos < content.length ) {
					part2 = content.substring( area.cursorPos, content.length );
				}
				
				area.setValue( part1 + '${' + combo.getValue() + '}' + part2 );
            } else {
                Ext.Msg.show( {
                    title: this.warning,
                    msg: this.adding_variable_warning,
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.INFO
                } );
            }
        },
        scope: this,
        iconCls: 'dvnt-icon-plus-symbol'
    } );

    var saveButton = new Ext.Button( {
        text: this.save_and_close,
        handler: function() {
            record.set( field, area.getValue() );
            this.close();
        },
        scope: this,
        iconCls: 'dvnt-icon-save'
    } );

    var cancelButton = new Ext.Button( {
        text: this.cancel,
        handler: function() {
            this.close();
        },
        scope: this,
        iconCls: 'dvnt-icon-x-circle'
    } );

    var area = new Ext.form.TextArea( {
        layout: 'fit',
        value: value,
		enableKeyEvents: true,
		cursorPos: null,
        minHeight: 200,
		onClick: function() {
			this.fireEvent( 'keyup', this );
		},
		listeners : {
			render: function( field ) {
                field.getEl().on( 'click', field.onClick, field );
            },
			keyup : function( field, e) {
				if (Ext.isIE) {
					var bookmark = document.selection.createRange().getBookmark();
					var selection = field.el.dom.createTextRange();
					selection.moveToBookmark(bookmark);

					var before = field.el.dom.createTextRange();
					before.collapse(true);
					before.setEndPoint("EndToStart", selection);

					var selLength = selection.text.length;

					var selectionStart = before.text.length;
					field.cursorPos = selectionStart + selLength;
				} else {
					field.cursorPos = field.el.dom.selectionEnd;
				}
			}
		}
    } );

    var comboStore = new Ext.data.JsonStore( {
        autoDestroy: true,
        writer: writer,
        url: 'com.plusmpm.servlet.notifications.NotificationConfigurationVariablesServlet.customServlet',
        baseParams: {
            processId: processId
        },
        fields: [ {
            name: 'variableId',
            type: 'string'
        }, {
            name: 'variableName',
            type: 'string'
        }, {
            name: 'variableType',
            type: 'string'
        } ],
		listeners: {
			load: function( store, records, options ) {
				store.sort( [ {
					field: 'variableType',
					direction: 'ASC'
				}, {
					field: 'variableName',
					direction: 'ASC'
				} ] );
			}
		}
    } );

    var combo = new Ext.form.ComboBox( {
        typeAhead: true,
        triggerAction: 'all',
        lazyRender: true,
        mode: 'remote',
        store: comboStore,
        tpl: oComboBox_tpl,
        itemSelector: 'div.search-item',
        displayField: 'variableName',
		valueField: 'variableId',
		width: 250
    } );

    var bb = new Ext.Toolbar( {
        items: [ combo, ' ', addingButton ]
    } );

    var tb = new Ext.Toolbar( {
        items: [ saveButton, '->', cancelButton ]
    } );

    config = Ext.apply( {
        layout: 'fit',
        height: 300,
        width: 450,
        minHeight: 300,
        minWidth: 200,
        padding: 10,
        closable: true,
        modal: true,
        bbar: bb,
        tbar: tb,
        stateful: true,
        stateId: 'notication-variable-window',
        constrainHeader: true,
        title: this.title_text,
        items: [ area ]

    }, config );

    Ext.ux.plusmpm.AddingNewVariableForm.superclass.constructor.call( this, config );
}; // End of Ext.ux.plusmpm.AddingNewVariableForm

Ext.extend( Ext.ux.plusmpm.AddingNewVariableForm, Ext.Window, {
    adding_variable_warning: PW.t('adding_variable_warning'),
    warning: PW.t('warning'),
    save_and_close: PW.t('save_and_close'),
    cancel: PW.t('cancel'),
    title_test: PW.t('title_test'),
    add_variable: PW.t('add_variable'),
	constants: PW.t('constants'),
	variables: PW.t('variables')
} );
