(function(Ext) {
	
	Ext.define('Suncode.datasourcemanager.view.DataSourceTree', {
		extend: 'Ext.tree.Panel',
		alias: 'widget.data-source-tree',
		title: PW.t('data-sources'),
		mixins: {
			treeFilter: 'Suncode.datasourcemanager.mixins.TreeFilter'
		},
		width : 470,
		region : 'west',
		layout : {
			type : 'vbox',
			align : 'stretch'
		},
        bodyStyle : {
			padding : '5px'
		},
		autoScroll: true,
		multiSelect: true,
        displayField: 'name',
        rootVisible: false,
        
        initComponent: function() {
			this.store = Ext.create('Suncode.datasourcemanager.store.DataSourceStore')
        	this.callParent();

        	this.on('select', function(tree, record) {
    			this.fireEvent('selectdatasource', record);
    		});
        	this.on('load', function(store, root, records) {
        		this.addTooltip(root.childNodes);
    		});
        },
        
        addTooltip: function(nodes){
        	if(Ext.isEmpty(nodes)) return;
    		
			Ext.each(nodes, function(node){
				var description = node.get('description'); 
				if(!Ext.isEmpty(description)){
					node.set('qtip', description);
				}
				
				this.addTooltip(node.childNodes);
			}, this);
        },
        
        refresh: function(data) {
            if(!data) {
                this.getStore().load();
                return;
            }
            
        	var me = this;
        	this.getStore().load({
        		callback: function(){
					me.getStore().getRootNode().cascadeBy(function(node){
						var nodeId = node.get('id').split('#')[1];

						if(nodeId && nodeId === data.id){
							me.selectPath(node.getPath());
						}
					});
        		}
        	});
        },
        
        updateSelected: function(data){
        	Ext.suspendLayouts();

        	this.getStore().getRootNode().cascadeBy(function(node){
        		var nodeId = node.get('id').split('#')[1];
        		
        		if(nodeId && nodeId == data.id){
        			node.set('name', data.name);
        			node.commit();
        		}
        	});

			this.cascadeDown(this.getStore().originalRoot, node => {
				const nodeId = node.id.split('#')[1];

				if(nodeId && nodeId === data.id){
					node.name = data.name
				}
			})
        	
        	Ext.resumeLayouts();
        },

		cascadeDown(node, callback){
			if (!node.children) {
				return
			}

			node.children.forEach(childNode => {
				callback(childNode)
				this.cascadeDown(childNode, callback)
			})
		},

		getParentId(id){
			const me = this;
			let parentNodeId = null;
			me.getStore().getRootNode().cascadeBy(function(node){
				const nodeId = node.get('id').split('#')[1];

				if(nodeId && nodeId === id && !!node.parentNode){
					parentNodeId = node.parentNode.id.split('#')[1];
				}
			});

			return parentNodeId;
		},

		expandPathById(id){
			const me = this;
			me.getStore().getRootNode().cascadeBy(function(node){
				const nodeId = node.get('id').split('#')[1];

				if(nodeId && nodeId === id){
					me.expandPath(node.getPath());
				}
			});
		}

	});
	
})(Ext4);