(function(Ext) {

    Ext.define('Suncode.datasourcemanager.component.ExecutionParametersWindow', {
        extend: 'Ext.window.Window',
        xtype: 'executionparameterswindow',

        title: PW.t('datasources-parameters-window-title'),
        width: 500,
        modal: true,
        frame: false,
        layout: 'fit',

        temporaryDataSource: undefined,
        notInvalidateDataSource: false,

        constructor: function( temporaryDataSource ) {
            this.temporaryDataSource = temporaryDataSource;

            this.callParent(arguments);
        },

        initComponent: function () {
            var dataSource = this.temporaryDataSource.dataSource;
            var parameters = [];
            Ext.each(dataSource.inputParameters, function(parameter, index) {
                parameters.push({
                    xtype: 'textfield',
                    name: parameter.id,
                    fieldLabel: parameter.name
                });
            });

            this.items = [{
                xtype: 'form',
                layout: 'form',
                frame: false,
                border: false,
                bodyPadding: 10,
                defaults: {
                    labelWidth: 150
                },
                items: parameters
            }];

            this.buttons = []
            if(dataSource.inputParameters.length > 0){
                this.buttons.push(                {
                        text: PW.t('importuj'),
                        xtype: "filebutton",
                        cls: "x4-window-default",
                        style: "overflow: hidden;",
                        listeners: {
                            change: {
                                element: 'fileInputEl',
                                fn: this.onInputChange,
                                scope: this
                            }
                        }
                    },
                    {
                        text: PW.t('eksportuj'),
                        handler: this.saveParameters,
                        scope: this
                    },)
            }

            this.buttons.push({
                text: PW.t('datasources-execute'),
                handler: this.onExecuteButtonClick,
                scope: this
            }, {
                text: PW.t('cancel'),
                handler: this.close,
                scope: this
            })

            this.callParent(arguments);
        },

        listeners: {
            boxready: function(window) {
                if (window.getLocalY() <= 0) {
                    window.setLocalY(10);
                }
            },
        },

        onExecuteButtonClick: function(){
            var form = this.down('form');
            this.fireEvent('executeDataSource', this, form);
        },

        onInputChange: function (event) {
            let files = event.browserEvent.target.files

            if (files.length === 1) {
                let file = files.item(0)

                let reader = new FileReader();
                reader.onload = this.importParameters.bind(this);
                reader.readAsText(file)
            }
        },

        importParameters: function (event) {
            let form = this.down('form');

            try {
                let parametersMap = JSON.parse(event.target.result)
                form.getForm().setValues(parametersMap)
            } catch (error) {
                PW.ui.Message.error(PW.t('datasources-parameter-import-error'));
            }
        },

        saveParameters: function () {
            let form = this.down('form');
            this.saveFile(JSON.stringify(form.getForm().getValues()))
        },

        saveFile: function (data) {
            let file = new Blob([data], {type: "application/json"});
            let filename = "parameters.json"

            //IE10+
            if (window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveOrOpenBlob(file, filename)
            } else {
                let a = document.createElement("a")
                let url = URL.createObjectURL(file);

                a.href = url;
                a.download = filename;
                document.body.appendChild(a);
                a.click();
                setTimeout(function () {
                    document.body.removeChild(a);
                    window.URL.revokeObjectURL(url);
                }, 0);
            }
        }
    });

})(Ext4);
