(function (Ext) {
  var messages = Suncode.context('dashboard').messages;

  Ext.define('Suncode.dashboard.administration.model.User', {
    extend: 'Ext.data.Model',
    fields: [
      {
        name: 'id',
        mapping: 'objectId',
        type: 'int',
      },
      {
        name: 'username',
        mapping: 'userName',
        type: 'string',
      },
      {
        name: 'fullName',
        type: 'string',
      },
      {
        name: 'name',
        convert: function (value, record) {
          return record.data.fullName + ' (' + record.data.username + ')';
        },
      },
    ],
  });

  Ext.define('Suncode.dashboard.administration.model.Group', {
    extend: 'Ext.data.Model',
    fields: [
      {
        name: 'id',
        mapping: 'objectId',
        type: 'int',
      },
      {
        name: 'name',
        type: 'string',
      },
    ],
  });

  Ext.define('Suncode.dashboard.administration.view.ChooseUserOrGroup', {
    extend: 'Suncode.dashboard.administration.view.StatusForm',
    alias: 'widget.choose-user-or-group',
    scope: this,
    title: messages('manager.west.choose'),
    bodyStyle: {
      border: '0',
    },
    initComponent: function () {
      Ext.apply(this, {
        cls: 'dashboard-choose-panel',
        style: {
          margin: '5px',
        },
        items: [
          {
            xtype: 'fieldset',
            cls: 'choose-fieldset',
            title: messages('manager.west.choose'),
            defaults: {
              flex: 1,
            },
            scope: this,
            layout: 'hbox',
            items: [
              {
                xtype: 'radiogroup',
                itemId: 'radios',
                items: [
                  {
                    boxLabel: messages('users'),
                    name: 'manage',
                    inputValue: 'users',
                    id: 'users-radio',
                    checked: true,
                  },
                  {
                    boxLabel: messages('groups'),
                    name: 'manage',
                    inputValue: 'groups',
                    id: 'groups-radio',
                  },
                ],
                listeners: {
                  scope: this,
                  change: this.onRadioChange,
                },
              },
            ],
          },
          {
            xtype: 'combo',
            itemId: 'ug-combo',
            isFormField: false,
            valueField: 'id',
            displayField: 'name',
            queryMode: 'remote',
            forceSelection: true,
            allowBlank: false,
            minChars: 1,
            pageSize: 20,
            listeners: {
              scope: this,
              change: this.onComboChange,
            },
          },
        ],
      });

      this.callParent();
      this.initStores();
    },

    initStores: function () {
      this.usersStore = new Ext.data.Store({
        model: 'Suncode.dashboard.administration.model.User',
        folderSort: true,
        sorters: [{ property: 'name', direction: 'ASC' }],
        proxy: {
          type: 'ajax',
          url: Suncode.getAbsolutePath('/api/users/query'),
          reader: {
            type: 'json',
            root: 'data',
          },
        },
      });

      this.groupsStore = new Ext.data.Store({
        model: 'Suncode.dashboard.administration.model.Group',
        folderSort: true,
        sorters: [{ property: 'name', direction: 'ASC' }],
        proxy: {
          type: 'ajax',
          url: Suncode.getAbsolutePath('/api/groups/query'),
          reader: {
            type: 'json',
            root: 'data',
          },
        },
      });

      var combo = this.down('#ug-combo');
      combo.emptyText = messages('form.share.user.empty');
      combo.bindStore(this.usersStore);
    },

    onRadioChange: function (radio, newValue) {
      var mainPanel = this.up().up();

      mainPanel.defaultDashboardCombo.reset();
      mainPanel.defaultDashboardCombo.setDisabled(true);
      mainPanel.createForm.setVisible(false);
      mainPanel.chosenType = newValue.manage;

      var combo = this.down('#ug-combo');

      combo.emptyText = ' ';
      delete combo.lastQuery;

      if (newValue.manage === 'users') {
        combo.emptyText = messages('form.share.user.empty');
        combo.bindStore(this.usersStore);
      } else {
        combo.emptyText = messages('form.share.group.empty');
        combo.bindStore(this.groupsStore);
        mainPanel.ownedGrid.setVisible(false);
        mainPanel.sharedGrid.setVisible(false);
      }
      combo.reset();
    },

    onComboChange: function (combo, newValue, oldValue) {
      if (newValue && !(typeof newValue == 'string' || newValue instanceof String)) {
        var mainPanel = this.up().up(),
          checked = combo.up().down('#radios').getChecked()[0].inputValue,
          defaultDashboardCombo = mainPanel.defaultDashboardCombo;

        //hide edit-dashboard-form
        mainPanel.editForm.setVisible(false);

        var dashboardGrid = mainPanel.ownedGrid;
        var sharedGrid = mainPanel.sharedGrid;

        if (checked === 'users') {
          mainPanel.chosenUser = newValue;
          mainPanel.createForm.setVisible(true);

          var record = combo.getStore().getById(newValue);
          var username = record.data.username;

          mainPanel.chosenUsername = username;
            var dashboardStore = Ext.getStore('MyDashboards');
            dashboardStore.setUserParameter(username);

            var sharedStore = Ext.getStore('SharedDashboards');
            sharedStore.setUserParameter(username);

            dashboardGrid.setTitle(messages('grid.user.title', username));
          dashboardGrid.setVisible(true);

          sharedGrid.setTitle(messages('grid.shared.title', username));
          sharedGrid.setVisible(true);

          Ext.StoreManager.lookup('MyDashboards').load({
            url: Suncode.context('dashboard').base + '/api/dashboards/query',
            params: {
              user: username,
            },
          });

          Ext.StoreManager.lookup('SharedDashboards').load({
            url: Suncode.context('dashboard').base + '/api/dashboards/query',
            params: {
              user: username,
            },
          });

          var store = new Ext.data.Store({
            model: 'Suncode.dashboard.administration.model.Dashboard',
            sorters: [{ property: 'translatedName', direction: 'ASC' }],
            proxy: {
                type: 'ajax',
                url: Suncode.context('dashboard').base + '/api/dashboards/query',
                extraParams: {
                    type: 'all',
                    user: username,
                },
                simpleSortMode: true,
                reader: {
                    type: 'json',
                    root: 'data',
                },
            },
          });

            delete defaultDashboardCombo.lastQuery;
            defaultDashboardCombo.bindStore(store);
            store.on('load', function (store) {
                store.each(function (record) {
                    const encodedName = Ext.util.Format.htmlEncode(record.get('translatedName'));
                    record.set('translatedName', encodedName);
                });
            });
            mainPanel.getDefaultDashboard();
            defaultDashboardCombo.setDisabled(false);

            var importCombo = mainPanel.createForm.down('#import');
            delete importCombo.lastQuery;
            importCombo.bindStore(store);
        } else if (checked === 'groups') {
          mainPanel.chosenGroup = newValue;

          var group = combo.getStore().getById(newValue);

          var store = new Ext.data.Store({
            model: 'Suncode.dashboard.administration.model.Dashboard',
            proxy: {
                type: 'ajax',
                url: Suncode.context('dashboard').base + '/api/dashboards/query',
                extraParams: {
                    type: 'all',
                    group: group.get('name'),
                },
                method: 'GET',
                simpleSortMode: true,
                reader: {
                    type: 'json',
                    root: 'data',
                },
            },
          });

            delete defaultDashboardCombo.lastQuery;
            defaultDashboardCombo.bindStore(store);
            store.on('load', function (store) {
                store.each(function (record) {
                    const encodedName = Ext.util.Format.htmlEncode(record.get('translatedName'));
                    record.set('translatedName', encodedName);
                });
            });
            mainPanel.getDefaultDashboard();
            defaultDashboardCombo.setDisabled(false);
        }
      }
    },
  });
})(Ext4);
