(function (Ext) {
  /**
   * Rozszerzenie standardowej aplikacji o możliwość zniszczenia jej poprzez
   * wywołanie funkcji #destroy.
   *
   * Podczas niszczenia aplikacji, niszczone są następujące komponenty:
   * 	- controllers: wywołanie metody destroy kontrolera, unlisting controllera w EventBus
   * 	- stores: zniszczenie wszystkich stworzonych store's
   *
   * Dodatkowo usuwane są: referencja do aplikacji, metoda #getApplication
   */
  Ext.define('Favourites.support.DestroyableApplication', {
    extend: 'Ext.app.Application',

    statics: {
      destroyApp: function (name) {
        var ns = Ext.namespace(name);
        if (Ext.isFunction(ns.getApplication)) {
          Ext.destroy(ns.getApplication());
        }
      },
    },

    destroy: function () {
      var me = this,
        ns;

      if (me.viewport) {
        Ext.destroy(me.viewport);
      }

      // wszystkie story
      // unlisting controllerów
      me.controllers.each(function (controller) {
        controller.eventbus.unlisten(controller.id);
        Ext.destroy(controller);
      });

      // referencja applikacji
      ns = Ext.namespace(me.name);
      delete ns[me.appProperty];
      delete ns['$application'];
      delete ns['getApplication'];
    },
  });
})(Ext4);
