jQuery.extend(PW, {
	/**
	 * Helper class for console logging.
	 * 
	 * AlternateClassName: `Logger`.
	 * 
	 * @class PW.Logger
	 */
	Logger : {
		/**
		 * Method to log errors.
		 * 
		 * Typical usage:
		 * 
		 * try { // ... } catch(e){ Logger.error("Unexpected error occurred", e); }
		 * 
		 * @method error
		 * @param {String}
		 *            text Text to log.
		 */
		error : function(text) {
			if (Ext.isDefined(console) && Ext.isFunction(console.error)) {
				console.error.apply(null, arguments);
			}
		},
		
		/**
		 * Method to log debug messages.
		 * 
		 * try { // ... } catch(e){ Logger.error("Unexpected error occurred", e); }
		 * 
		 * @method debug
		 * @param {String}
		 *            text Text to log.
		 */
		debug : function(text) {
			if (Ext.isDefined(console) && Ext.isFunction(console.log)) {
				console.log.apply(null, arguments);
			}
		},

		/**
		 * Method to log trace messages. Outputs logs only when in `devMode`
		 * @method trace
		 */
		 trace : function() {
			if (window.devMode && Ext.isDefined(console)) {
				(console.debug || console.log).apply(null, arguments);
			}
		}
	}
});

Logger = PW.Logger;
