<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.suncode.pwfl.SystemVersion" %>

<script type="text/javascript" src="${pageContext.request.contextPath}/resources/lib/vue.min.js"></script>

<div class="change-password-card">
    <div class="logo-text-container">
        <div id="login-logo">
            <img src="${pageContext.request.contextPath}/resources/images/plusworkflow_color_full.png"/>
        </div>
        <div class="system-version">
            <%=SystemVersion.getVersionIdentifier() %>
        </div>
    </div>

    <div id="message" class="message-box info">
    </div>

    <div id="login-form" style="display: none">
        <div id="changePasswordForm"
             class="gl-grid-middle">
            <template v-if="!recoveryUpdate">
                <div class="gl-col-4">
                    <label class="dvnt-table-black dvnt-body1">
                        <bean:message key="Obecne_haslo"/>
                    </label>
                </div>
                <div class="gl-col-8">
                    <table class="form" style="width: 100%">
                        <tbody>
                        <tr>
                            <td>
                                <div class="triggers">
                                    <a id="showHideCurrentPassword" class="trigger first dvnt-icon-show hide-password-trigger z-index-1"></a>

                                    <div class="dvnt-input-text-wrapper">
                                        <input id="currentPassword"
                                               v-model="currentPassword"
                                               @keyup.enter="tryChangePassword"
                                               type="password"
                                               autocomplete="off">
                                    </div>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </template>
            <template v-if="recoveryUpdate">
                <div class="gl-col-4">
                    <label class="dvnt-table-black dvnt-body1">
                        <bean:message key="Kod"/>
                    </label>
                </div>
                <div class="gl-col-8">
                    <div class="dvnt-input-text-wrapper">
                        <input v-model="uuid"
                               @keyup.enter="tryChangePassword"
                               type="text"
                               autocomplete="off"
                               class="password-recovery-code">
                    </div>
                </div>
            </template>
            <div class="gl-col-4">
                <label class="dvnt-table-black dvnt-body1">
                    <bean:message key="Nowe_haslo"/>
                </label>
            </div>
            <div class="gl-col-8">
                <table class="form" style="width: 100%">
                    <tbody>
                    <tr>
                        <td>
                            <div class="triggers">
                                <a id="showHideNewPassword" class="trigger first dvnt-icon-show hide-password-trigger z-index-1"></a>

                                <div class="dvnt-input-text-wrapper">
                                    <input id="newPassword"
                                           v-model="newPassword"
                                           @keyup.enter="tryChangePassword"
                                           type="password"
                                           autocomplete="off">
                                </div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="gl-col-4">
                <label class="dvnt-table-black dvnt-body1">
                    <bean:message key="Potwierdz_haslo"/>
                </label>
            </div>
            <div class="gl-col-8">
                <table class="form" style="width: 100%">
                    <tbody>
                    <tr>
                        <td>
                            <div class="triggers">
                                <a id="showHideNewPasswordConfirmed" class="trigger first dvnt-icon-show hide-password-trigger z-index-1"></a>
                                <div class="dvnt-input-text-wrapper">
                                    <input id="newPasswordConfirmed"
                                           v-model="newPasswordConfirmed"
                                           @keyup.enter="tryChangePassword"
                                           type="password"
                                           autocomplete="off">
                                </div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <div v-show="newPassword.length > 0" class="password-meter-container">
                    <div class="meter-outer">
                        <div class="meter-inner" :style="dynamicStyleObject"></div>
                    </div>
                    <p>{{passwordStrengthText}}</p>
                </div>
            </div>
            <div class="gl-col-6"></div>
            <div class="gl-col-6">
                <input @click="tryChangePassword"
                       class="dvnt-button-primary"
                       type="button"
                       value="<bean:message key="Zmien_haslo"/>">

            </div>
        </div>
    </div>
</div>

<script src="scripts/change-password/changePasswordApp.js"></script>
<script>
    function redirectToLoginPage() {
        var contextPath = Suncode.getContextPath()
        if (!contextPath) {
            contextPath = '/';
        }

        window.location.href = contextPath;
    }

    var username = <%=session.getAttribute( "changePasswordUser" ) == null ? null : "'" + session.getAttribute( "changePasswordUser" ) + "'" %>;
    if (!username) {
        redirectToLoginPage();
    } else {
        var changePasswordApp = getChangePasswordApp();
        changePasswordApp.username = username;
        changePasswordApp.recoveryUpdate = <%=request.getAttribute( "recoveryUpdate" )%>;

        var messageTarget = Ext.get('message');
        if (changePasswordApp.recoveryUpdate) {
            messageTarget.update(PW.t('Formularz_zmiany_hasla'));
        } else {
            messageTarget.update(PW.t('Zostales_przekierowany'));
        }

        changePasswordApp.onPasswordChanged = function () {
            setTimeout(function () {
                redirectToLoginPage();
            }, 1500);

            jQuery('#message').hide();
        }

        changePasswordApp.$mount('#changePasswordForm');
        jQuery('#login-form').show();
    }

    jQuery(document).ready(function () {
        jQuery("#showHideCurrentPassword").on('click', function (event) {
            showHidePassword(event, '#currentPassword')
        });

        jQuery("#showHideNewPassword").on('click', function (event) {
            showHidePassword(event, '#newPassword')
        });

        jQuery("#showHideNewPasswordConfirmed").on('click', function (event) {
            showHidePassword(event, '#newPasswordConfirmed')
        });

        function showHidePassword(event, passwordInputId) {
            event.preventDefault();
            const passwordInput = jQuery(passwordInputId)[0];
            const hideIconClass = 'dvnt-icon-hide';
            const showIconClass = 'dvnt-icon-show';

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                jQuery(this).removeClass(showIconClass);
                jQuery(this).addClass(hideIconClass);
            } else {
                passwordInput.type = 'password';
                jQuery(this).removeClass(hideIconClass);
                jQuery(this).addClass(showIconClass);
            }
        }
    });
</script>