<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@page language="Java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://ajaxtags.org/tags/ajax" prefix="ajax"%>

<%@page import="org.springframework.context.i18n.LocaleContextHolder"%>

<link rel="stylesheet" type="text/css" media="all" href="style/calendar-system.css" title="win2k-cold-1" />

<script type="text/javascript" src="scripts/calendar.js"></script>
<script type="text/javascript" src="scripts/lang/calendar-<%=LocaleContextHolder.getLocale().getLanguage()%>.js"></script>
<script type="text/javascript" src="scripts/calendar-setup.js"></script>

<%
    int i = 0;
%>

<div class="content-container">
	<div class="content-header">
		<p><bean:message key="Nazwa_raportu"/>: <c:out value="${reportName}"/></p>
	</div>
	<div id="portlet_3" class="portlet-panel">
		<div id="portlet_3Title" class="portlet-panel-title"><bean:message key="Parametry_raportu"/></div>
		<div id="portlet_3Content" class="portlet-panel-content" >
			<html:form action="ShowJasperRaportResult.do?source=params" method="GET" styleId="varForm">
			<input type="hidden" name="reportId" id="reportId" value='<c:out value="${reportId}"/>'>
			<input type="hidden" name="reportType" id="reportType" value='<c:out value="${reportType}"/>'>
			<table class="form-table">
				<c:forEach var="reportVariable" items="${alReportVariable}">
				<c:choose>
					<c:when test='${reportVariable.sortType == "string" || reportVariable.sortType == "integer"
					|| reportVariable.sortType == "float" || reportVariable.sortType == "date" || reportVariable.sortType == "list"}'>
						<tr>
							<td>
								<c:out value="${reportVariable.viewname}"/>
							</td>
								<c:choose>
									<c:when test='${reportVariable.sortType == "string" || reportVariable.sortType == "integer" || reportVariable.sortType == "float"}'>
										<td>
											<INPUT type="text" name="variable[<%=i%>].value" id='<c:out value="${reportVariable.name}"/>'>
										</td>
									</c:when>
									<c:when test='${reportVariable.sortType == "date"}'>
										<td class="triggers">
											<INPUT type="text" name="variable[<%=i%>].value" readonly="true" id='<c:out value="${reportVariable.name}"/>' class="date">
											<a id="date_img_<%=i%>" class="trigger date-time-trigger"></a>
											<script type="text/javascript">
												Calendar.setup({
													inputField     :    "<c:out value='${reportVariable.name}'/>",     // id of the input field
													ifFormat       :    "%Y-%m-%d %H:%M:%S",      // format of the input field
													button         :    "date_img_<%=i%>",  // trigger for the calendar (button ID)
													align          :    "Tr",           // alignment (defaults to "Bl")
													singleClick    :    true,
													showsTime		:	true
												});
											</script>
										</td>
									</c:when>
									<c:when test='${reportVariable.sortType == "list"}'>
										<td>
											<SELECT name="variable[<%=i%>].value" id='<c:out value="${reportVariable.name}"/>'>
												<c:forEach var="reportListVariableValue" items="${allReportListVariableValues}">
												<c:choose>
													<c:when test='${reportVariable.id == reportListVariableValue.variableId}'>
														<OPTION value='<c:out value="${reportListVariableValue.listValueId}"/>'><c:out value="${reportListVariableValue.listValueDisplay}"/></OPTION>
													</c:when>
												</c:choose>
												</c:forEach>
											</SELECT>
										</td>
									</c:when>
								</c:choose>
						</tr>
					</c:when>
				</c:choose>
				<INPUT type="hidden" id="varType<%=i%>" name="variable[<%=i%>].sortType" value='<c:out value="${reportVariable.sortType}"/>'/>
				<INPUT type="hidden" id="varName<%=i%>" name="variable[<%=i%>].name" value='<c:out value="${reportVariable.name}"/>'/>
				<INPUT type="hidden" id="varViewName<%=i%>" name="variable[<%=i%>].viewname" value='<c:out value="${reportVariable.viewname}"/>'/>
				<%
					i++;
				%>
				</c:forEach>
				<tr class="buttons">
					<td></td>
					<td>
						<bean:define id="Utworz"><bean:message key="Utworz"/></bean:define>
						<html:submit title="<%=Utworz%>" value="<%=Utworz%>" styleClass="button"/>
					</td>
				</tr>
			</table>
			</html:form>
		</div>
	</div>
</div>

