<%@page import="com.suncode.pwfl.util.SpringContext"%>
<%@page import="org.apache.commons.lang3.StringUtils"%>
<%@ page import="com.suncode.pwfl.administration.configuration.SystemProperties" %>
<%@ page import="com.suncode.pwfl.administration.configuration.DefinedSystemParameter" %>
<%@ page import="com.suncode.pwfl.administration.configuration.SystemType" %>
<%@ page import="com.suncode.pwfl.license.trial.service.TrialService" %>
<%@ page import="com.suncode.pwfl.i18n.MessageHelper" %>
<%@ page import="com.suncode.pwfl.administration.systemMessage.SystemMessageService" %>
<%@ page import="java.util.List" %>
<%@ page import="com.suncode.pwfl.administration.systemMessage.SystemMessage" %>
<%@ page import="com.suncode.pwfl.administration.user.UserContext" %>
<%@ page import="com.suncode.pwfl.administration.systemMessage.SystemMessageType" %>
<%@ page import="com.suncode.pwfl.administration.systemMessage.SystemMessageDto" %>
<%@ page import="java.util.stream.Collectors" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="suncode-tiles" prefix="tiles"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<jsp:include page="/pages/util/head_resources.jsp"></jsp:include>
</head>

<%
	TrialService trialService = SpringContext.getBean( TrialService.class );
	String systemTypeValue = SystemProperties.getString( DefinedSystemParameter.SYSTEM_TYPE );
	SystemType systemType = SystemType.fromString( systemTypeValue );
	String systemName = SystemProperties.getString( DefinedSystemParameter.SYSTEM_NAME );

	boolean showVersion = trialService.readLicense().isValid() || systemType != SystemType.PRODUCTION;
	boolean showSystemBar = StringUtils.isNotBlank( systemName ) || showVersion;

	StringBuilder barStringBuilder = new StringBuilder();
	if ( showSystemBar )
	{
		if ( StringUtils.isNotBlank( systemName ) )
		{
			barStringBuilder.append( systemName );
		}

		if ( StringUtils.isNotBlank( systemName ) && showVersion )
		{
			barStringBuilder.append( " - " );
		}

		if ( trialService.readLicense().isValid() )
		{
			barStringBuilder.append( MessageHelper.getMessage( "demoVersion" ) );
		}
		else if ( systemType != SystemType.PRODUCTION )
		{
			barStringBuilder.append( MessageHelper.getMessage( systemType.getMessageKey() ) );
		}
	}

	SystemMessageService systemMessageService = SpringContext.getBean( SystemMessageService.class );

	boolean showAfterLoginSystemMessages = session.getAttribute( "showSystemMessages" ) != null;
	String userName = UserContext.current().getUser().getUserName();

	List<SystemMessageDto> systemMessages = systemMessageService.getNewSystemMessagesForUser( userName, showAfterLoginSystemMessages );
	List<SystemMessageDto> windowSystemMessages = systemMessages.stream()
			.filter( systemMessage -> systemMessage.getMessageType() == SystemMessageType.WINDOW )
			.collect( Collectors.toList() );

	boolean shouldShowSystemMessages = windowSystemMessages.size() > 0;
	if ( showAfterLoginSystemMessages && !shouldShowSystemMessages )
	{
		session.removeAttribute( "showSystemMessages" );
	}

	List<SystemMessageDto> bannerSystemMessages = systemMessages.stream()
			.filter( systemMessage -> systemMessage.getMessageType() == SystemMessageType.BANNER )
			.collect( Collectors.toList() );

	boolean showBar = showSystemBar || !bannerSystemMessages.isEmpty();
%>

<script type="text/javascript">
	function closeMessage(messageId) {
		const message = jQuery('#system-message-' + messageId);
		const systemMessagesInnerContainer = message.parent()

		if (!this.widthSet) {
			const maxWidth = message.width();
			systemMessagesInnerContainer.children().width(maxWidth)
			this.widthSet = true;
		}

		message.remove()

		const lastMessage = systemMessagesInnerContainer.children().length === 0
		if (lastMessage) {
			systemMessagesInnerContainer.parent().remove()
		}

		const url = Suncode.getAbsolutePath("/api/systemMessage/" + messageId + "/read?lastMessage=" + lastMessage);
		jQuery.ajax({
			type: "POST",
			url: url,
			error: function () {
				PW.ui.Message.error(PW.t('unknownErrorText'));
			}
		})
	}

	function closeBannerMessage(messageId) {
		const message = getMessage(messageId)
		message.remove()

		const url = Suncode.getAbsolutePath("/api/systemMessage/" + messageId + "/read");
		jQuery.ajax({
			type: "POST",
			url: url,
			error: function () {
				PW.ui.Message.error(PW.t('unknownErrorText'));
			}
		})
	}

	function initMessageButtons() {
		const resizeObserver = new ResizeObserver(entries => {
			this.updateButtonsVisibility();
		});

		if(document.getElementById("version-bar")){
			resizeObserver.observe(document.getElementById("version-bar"))
		}

		this.updateButtonsVisibility();

		const messages = document.getElementsByClassName('banner-message')
		for (const message of messages) {
			message.classList.remove('banner-message-loading')
		}
	}

	function updateButtonsVisibility() {
		const messages = document.getElementsByClassName('banner-message')
		for (const message of messages) {
			const messageText = getMessageText(message)
			const showMore = messageText.classList.contains('show-more');

			hideMoreButton(message)
			hideLessButton(message)
			messageText.classList.remove('show-more');

			const overflows = messageText.scrollWidth > messageText.offsetWidth

			if (showMore) {
				messageText.classList.add('show-more')
			}

			if (!overflows) {
				continue
			}

			if (showMore) {
				showLessButton(message)
			} else {
				showMoreButton(message)
			}
		}
	}

	function showMore(messageId) {
		const message = getMessage(messageId)
		const messageText = getMessageText(message)
		messageText.classList.add('show-more')

		hideMoreButton(message)
		showLessButton(message)
	}

	function showLess(messageId) {
		const message = getMessage(messageId)
		const messageText = getMessageText(message)
		messageText.classList.remove('show-more')

		hideLessButton(message)
		showMoreButton(message)
	}

	function showMoreButton(message) {
		const showMoreButton = getShowMoreButton(message)
		showMoreButton.classList.remove('banner-message-action-hidden')
	}

	function showLessButton(message) {
		const showLessButton = getShowLessButton(message)
		showLessButton.classList.remove('banner-message-action-hidden')
	}

	function hideMoreButton(message) {
		const showMoreButton = getShowMoreButton(message)
		showMoreButton.classList.add('banner-message-action-hidden')
	}

	function hideLessButton(message) {
		const showLessButton = getShowLessButton(message)
		showLessButton.classList.add('banner-message-action-hidden')
	}

	function getMessage(messageId) {
		return document.getElementById('banner-message-' + messageId);
	}

	function getMessageText(message) {
		return message.getElementsByClassName('banner-message-text')[0];
	}

	function getShowMoreButton(message) {
		return message.getElementsByClassName('banner-message-action-show-more')[0];
	}

	function getShowLessButton(message) {
		return message.getElementsByClassName('banner-message-action-show-less')[0];
	}
</script>

<body id="page_bg" onload="initMessageButtons()">

	<% if ( showBar )
	{%>
	<div id="version-bar">
		<% if ( showSystemBar )
		{%>
		<div class="system-version-bar">
			<%=barStringBuilder.toString()%>
		</div>
		<% } %>
		<c:forEach items="<%=bannerSystemMessages%>" var="message">
			<div class="banner-message banner-message-loading" id="banner-message-${message.id}">
				<div class="banner-message-text">
					${message.message}
				</div>
				<div class="banner-message-action banner-message-action-hidden banner-message-action-show-more" onclick="showMore(${message.id})">
					<bean:message key="Pokaz_wiecej"/>
				</div>
				<div class="banner-message-action banner-message-action-hidden banner-message-action-show-less" onclick="showLess(${message.id})">
					<bean:message key="Pokaz_mniej"/>
				</div>
				<div class="banner-message-action banner-message-icon dvnt-icon-x-symbol" onclick="closeBannerMessage(${message.id})"></div>
			</div>
		</c:forEach>
	</div>
	<% } %>

	<div class="body-container">
		<tiles:insert name="body"/>
	</div>
	<div>
		<tiles:insert attribute="menu"/>
	</div>

	<div class="floating-component-container">
	</div>

	<% if ( shouldShowSystemMessages )
	{%>
	<div class="system-messages-wrapper">
		<div class="system-messages-inner-wrapper">
			<c:forEach items="<%=windowSystemMessages%>" var="message">
				<div class="message-wrapper" id="system-message-${message.id}">
					<div class="message-actions">
						<a class="dvnt-icon-x-symbol dvnt-table-gray-icon close-button" onclick="closeMessage(${message.id})"></a>
					</div>
					<div class="message">
							${message.message}
					</div>
				</div>
			</c:forEach>
		</div>
	</div>
	<% } %>
</body>
</html>
