<%@page language="Java" contentType="text/html; charset=UTF-8"
        pageEncoding="UTF-8" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/c" prefix="c" %>

<div>
    <div id="init-database-form-container">
        <div class="gl-grid-middle init-database-table">
            <div class="gl-col-12 dvnt-subtitle1">
                <bean:message key="System_PlusWorkflow_dziala_z_wykorzystaniem_wbudowanej_bazy_danych"/>
            </div>
            <div class="gl-col-12 dvnt-body1">
                <bean:message key="Wbudowana_baza_danych_nie_jest_zalecana_i_nie_powinna_byc_uzywana_w_instalacjach_produkcyjnych"/>
            </div>

            <div class="gl-col-12">
                    <input type="submit"
                           class="dvnt-button-secondary"
                           id="embedded"
                           value="<bean:message key="Nadal_korzystaj_z_wbudowanej_bazy_danych"/>"/>
            </div>
            <div class="gl-col-12 dvnt-subtitle2">
                <bean:message key="Skonfiguruj_dostep_do_bazy_danych"/>
            </div>

            <div class="gl-col-3">
                <label class="dvnt-table-black dvnt-body1"
                       for="type"><bean:message key="Typ"/></label>
            </div>
            <div class="gl-col-3">
                <div class="dvnt-combobox-wrapper">
                    <select name="type" id="type">
                        <option value="postgresql">PostgreSQL</option>
                        <option value="mssql">Microsoft SQL Server</option>
                        <option value="oracle">Oracle</option>
                        <option value="db2">IBM DB2</option>
                        <option value="db2as400">IBM DB2 AS400</option>
                    </select>
                </div>
            </div>
            <div class="gl-col-3">
                <label class="dvnt-table-black dvnt-body1"
                       for="host"><bean:message key="Host"/></label>
            </div>
            <div class="gl-col-3">
                <div class="dvnt-input-text-wrapper">
                    <input type="text" name="host" id="host"/>
                </div>
            </div>
            <div class="gl-col-3">
                <label class="dvnt-table-black dvnt-body1"
                       for="port"><bean:message key="Port"/></label>
            </div>
            <div class="gl-col-3">
                <div class="dvnt-input-text-wrapper">
                    <input type="text" name="port" id="port"/>
                </div>
            </div>
            <div class="gl-col-3">
                <label class="dvnt-table-black dvnt-body1"
                       for="name"><bean:message key="Nazwa_bazy_danych"/></label>
            </div>
            <div class="gl-col-3">
                <div class="dvnt-input-text-wrapper">
                    <input type="text" name="name" id="name"/>
                </div>
            </div>
            <div class="gl-col-3">
                <label class="dvnt-table-black dvnt-body1"
                       for="databaseUsername"><bean:message key="Nazwa_uzytkownika"/></label>
            </div>
            <div class="gl-col-3">
                <div class="dvnt-input-text-wrapper">
                    <input type="text" name="username" id="databaseUsername"/>
                </div>
            </div>
            <div class="gl-col-3">
                <label class="dvnt-table-black dvnt-body1"
                       for="databasePassword"><bean:message key="Haslo"/></label>
            </div>
            <div class="gl-col-3">
                <div class="dvnt-input-text-wrapper">
                    <input autocomplete="new-password" type="password" name="password" id="databasePassword"/>
                </div>
            </div>
            <div class="gl-col-6"></div>
            <div class="gl-col-6">
                <input type="submit"
                       class="dvnt-button-primary"
                       id="standalone"
                       value="<bean:message key="Zapisz"/>"/>
            </div>
        </div>
    </div>

    <div id="message-box" class="hidden">
        <div id="message-box-text" class="message-box"></div>
    </div>
</div>

<script>
    $ = jQuery;
    var contextPath = '${pageContext.request.contextPath}';
    var loadingBox = new Ext.LoadMask('loginBody');

    var msgUnknownError = '<bean:message key="Nieoczekiwany_blad_Sprobuj_ponownie"/>';
    var msgCannotConnect = '<bean:message key="Nie_udalo_sie_nawiazac_polaczenia_z_baza_danych"/>';
    var msgRestarting = '<bean:message key="Konfiguracja_zapisana_pomyslnie_system_uruchamia_sie_ponownie"/>';
    var msgNotRestarting = '<bean:message key="Konfiguracja_zapisana_pomyslnie_uruchom_system_ponownie"/>';

    function initStandalone() {
        var formContainer = jQuery('#init-database-form-container');
        var connection = {
            type: formContainer.find('#type').val(),
            host: formContainer.find('#host').val(),
            port: formContainer.find('#port').val(),
            name: formContainer.find('#name').val(),
            username: formContainer.find('#databaseUsername').val(),
            password: formContainer.find('#databasePassword').val()
        };

        $.ajax({
            type: "POST",
            url: contextPath + "/api/init/database/standalone",
            data: JSON.stringify(connection),
            contentType: 'application/json'
        }).done(function (status) {
            if (!status.success) {
                messageBox(msgCannotConnect, "error");
                loadingBox.hide();
            } else {
                if (status.restarting) {
                    loadingBox.show();
                    messageBox(msgRestarting, "success");
                    setTimeout(function () {
                        window.location.reload();
                    }, 20000);
                } else {
                    messageBox(msgNotRestarting, "success");
                    formContainer.hide();
                    loadingBox.hide();
                }
            }
        }).fail(function () {
            messageBox(msgUnknownError, "error");
            loadingBox.hide();
        });
    }


    function initEmbedded() {
        loadingBox.show();
        $.ajax({
            type: "POST",
            url: contextPath + "/api/init/database/embedded"
        }).done(function () {
            window.location.reload();
        }).fail(function () {
            messageBox(msgUnknownError, "error");
            loadingBox.hide();
        });
    }

    function messageBox(message, type) {
        var container = $('#message-box');
        var text = $('#message-box-text');
        text.attr('class', 'message-box');
        if (message) {
            text.text(message);
            text.addClass(type);
            container.removeClass("hidden");
        } else {
            container.addClass("hidden");
        }
    }

    $(function () {
        $.ajaxSetup({
            beforeSend: $.proxy(loadingBox.show, loadingBox)
        });

        $('#standalone').click(function () {
            initStandalone();
        });

        $('#embedded').click(function () {
            initEmbedded();
        });

        $('#init-database-form-container input').on('keypress', function (e) {
            if (e.which == 13) {
                initStandalone();
            }
        });
    })
</script>