Ext.define('ht.view.HistoryTree', {
  extend: 'Ext.tree.Panel',
  requires: ['Ext.data.*', 'Ext.grid.*', 'Ext.tree.*', 'Ext.ux.CheckColumn'],
  xtype: 'historytree',
  title: 'Historia zadania',
  useArrows: true,
  forceFit: true,
  rootVisible: false,
  params: null,
  listeners: {
    itemclick: function (grid, rec, item, index, e, eOpts) {
      if (e.target.name == 'history') {
        Ext.widget('window', {
          autoShow: true,
          title: 'Historia',
          layout: 'fit',
          width: 500,
          minHeight: 400,
          maxHeight: 800,
          items: [this.buildHistory(rec.raw)],
        });
      } else if ((e.target.name = 'details')) {
        Ext.widget('window', {
          autoShow: true,
          title: 'Szczegóły',
          layout: 'fit',
          width: 500,
          minHeight: 400,
          maxHeight: 800,
          items: [this.buildDetails(rec.raw)],
        });
      }
    },
  },
  buildHistory: function (data) {
    var p = Ext.apply({}, this.params);
    p = Ext.apply(p, data);
    var resp = Ext.Ajax.request({
      url: contextPath + '/com.plusmpm.servlet.extension.CUF.GetHistoryDefinition.customServlet',
      params: this.params,
      async: false,
    });
    resp = Ext.JSON.decode(resp.responseText);

    var store = new Ext.data.Store({
      fields: resp.historyFields,
      autoLoad: true,
      proxy: {
        type: 'ajax',
        url: 'com.plusmpm.servlet.extension.CUF.GetHistoryData.customServlet',
        extraParams: p,
      },
    });
    var grid = Ext.widget('grid', {
      store: store,
      forceFit: true,
      layout: 'fit',
      columns: resp.historyColumns,
    });

    return grid;
  },
  buildDetails: function (data) {
    var p = Ext.apply({}, this.params);
    p = Ext.apply(p, data);
    var resp = Ext.Ajax.request({
      url: contextPath + '/com.plusmpm.servlet.extension.CUF.GetTaskDetails.customServlet',
      params: p,
      async: false,
    });
    resp = Ext.JSON.decode(resp.responseText);

    var items = [];
    for (var i in resp) {
      if (resp.hasOwnProperty(i)) {
        items.push({
          fieldLabel: i,
          xtype: 'displayfield',
          value: resp[i],
        });
      }
    }
    var form = Ext.widget('form', {
      bodyPadding: 10,
      items: items,
    });
    return form;
  },
  initComponent: function () {
    var resp = Ext.Ajax.request({
      url: contextPath + '/com.plusmpm.servlet.extension.CUF.GetTreeDefinition.customServlet',
      params: this.params,
      async: false,
    });
    resp = Ext.JSON.decode(resp.responseText);

    var fields = resp.fields;

    var columns = resp.columns;
    columns[0].xtype = 'treecolumn';
    columns.push({
      header: 'Historia',
      renderer: function (v) {
        return '<a href="javascript:;" name="history" >Historia</a>';
      },
    });
    columns.push({
      header: 'Szczegóły',
      renderer: function (v) {
        return '<a href="javascript:;" name="details" >Szczegóły</a>';
      },
    });
    Ext.apply(this, {
      store: new Ext.data.TreeStore({
        fields: fields,
        proxy: {
          type: 'ajax',
          url: 'com.plusmpm.servlet.extension.CUF.GetTreeData.customServlet',
          extraParams: this.params,
        },
      }),
      columns: columns,
    });
    this.callParent();
  },
});
