/**
 * Podgląd dokumentów z poziomu wyników wyszukiwania.
 */
(function($){
    var translations = {};
    window.ProcessSearchDocumentsPreview = {
        translations: function(t){
            translations = t;
        }
    };

    var informationWindow,
    	documentsPreviewWindow;


    /**
     * Funkcja wyswietlająca okno z podlgądem dokumentu
     */
    var showDocumentPreview = function(document) {
        var body = Ext.getBody();
        var windowParams = 'menubar=no,toolbar=no,location=no,';
        windowParams += 'directories=no,status=no,scrollbars=yes,';
        windowParams += 'resizable=yes,fullscreen=no,channelmode=no,';
        windowParams += 'width=' + body.getWidth() / 2 + ',height=' + body.getHeight() + ',';
        windowParams += 'left=' + body.getWidth() / 2 + ',top=0';

        window.open(document.url || document.data.url, 'viewer', windowParams).focus();
    };

    var showDocumentsInformation = function(record, e) {
        informationWindow = showPopup(record.data.urlInformation, translations['document.information'], e.getPageX(), e.getPageY(), {width: 330});
    };

    /**
     * Okno podglądu wielu dokumentów
     */
    var PreviewWindow = Ext.extend(Ext.Window, {
        layout: 'fit',
        width: 650,
        frame: false,
        closable: false,
        resizable: false,
        header: false,
        cls: 'process-search-documents-preview',
        style: 'background-color: white;',

        constructor: function(documents){
        	this.destroyOtherInstance();

        	this.documents = documents;
            this.containsInformation = documents[0].containsInformation;
            PreviewWindow.superclass.constructor.call(this);
        },

        initComponent: function(){
            var me = this;

            var columns = [{
                dataIndex: 'name',
                tpl: '<span ext:qtip="{name}">{name}</span>',
                header: translations['document.name']
            },{
            	dataIndex: 'description',
            	width: 0.3,
            	tpl: '<span ext:qtip="{description}">{description}</span>',
            	header: translations['document.description']
            }, {
            	dataIndex: 'translatedName',
            	width: 0.2,
                tpl: '<span ext:qtip="{translatedName}">{translatedName}</span>',
            	header: translations['document.documentClass']
            }];

            if(this.containsInformation === true) {
            	var informationColumn = {
	                    align: 'center',
	                    width: 0.1,
                        tpl: '<span class="dvnt-icon-info-circle" style="height:16px;width:16px;display:inline-block;"></span>'
                };
            	columns.splice(3, 0, informationColumn);
            }

        	this.items = [{
                xtype: 'listview',
                cls: 'documents-preview-list',
                boxMaxHeight: 300,
                store: new Ext.data.JsonStore({
                    fields: [{
                        name: 'name',
                        convert: function(v){
                            return Ext.util.Format.htmlEncode(v);
                        }
                    }, 'url', 'urlInformation', 'translatedName', 'description',
                    {
                    	name: 'date',
                    	type: 'date'
                    },{
                    	name: 'containsInformation',
                    	type: 'boolean'
                    }],
                    data: this.documents,
                    sortInfo: {
                    	field: 'date',
                    	direction: 'DESC'
                    }
                }),
                columns: columns,
                listeners: {
                    scope: this,
                    click: this.manageCellClick
                },
                refresh: function(){
                    var r = Ext.list.ListView.prototype.refresh.call(this);
                    me.drawOddRows();
                    return r;
                },
                bufferRender: function(){
                    var r = Ext.list.ListView.prototype.bufferRender.call(this);
                    me.drawOddRows();
                    return r;
                }
            }],

            this.bbar = ['->', {
                text: translations["close"],
                iconCls: 'dvnt-icon-x-symbol',
                handler: this.close,
                scope: this
            }];

            this.initAutoClose();
            PreviewWindow.superclass.initComponent.call(this);
        },

        destroyOtherInstance: function() {
        	if(documentsPreviewWindow) {
        		documentsPreviewWindow.close();
        	}
        	documentsPreviewWindow = this;
        },

        showBy: function(target){
            this.show();

            var xy = this.el.getAlignToXY(target, 'tl-bl?');
            var rightArea = xy[0] > (Ext.getBody().getWidth() / 2);
            this.setPosition(xy[0] - (rightArea ? 15 : 0), xy[1]);
        },

        manageCellClick: function(view, index, node, e) {
        	var record = view.getRecord(node);
            var target = $(e.target);

            if(target.is('.dvnt-icon-info-circle') || target.children().is('.dvnt-icon-info-circle')){
                showDocumentsInformation(record, e);
            }
            else {
            	showDocumentPreview(record);
            }
        },

        drawOddRows: function(){
            if(this.el){
                $(this.el.dom).find('dl:odd').addClass('documents-preview-list-odd');
            }
        },

        initAutoClose: function(){
            this.on('afterrender', function(){
                Ext.getBody().on('mousedown', function(e){
                    if(!e.within(this.el)){
                    	if(informationWindow && e.within(informationWindow.el)) {
                			return;
                		}
                		this.close();
                    }
                }, this);
            }, this);
        },

        destroy: function(){
        	documentsPreviewWindow = undefined;

        	Ext.getBody().un('mousedown', this.close, this);
            return PreviewWindow.superclass.destroy.call(this);
        }
     });

    $(function(){
        var singleHoverId;
        var showPreview = function(elem){
        	new PreviewWindow($(elem).data('documents')).showBy(elem);
        };

        var hover = function(target) {
        	return target.on("hover", function(){
                var me = this;
                singleHoverId = setTimeout(function(){
                    showPreview(me);
                }, 1000);
            }, function(){
                clearTimeout(singleHoverId);
            });
        };

        // 1. Linki do pojedynczych dokumentów uruchamiają od razu podgląd dokumentów
        hover($('.document-preview-single')).on("click", function(){
            var doc = $(this).data('documents')[0];
            showDocumentPreview(doc);
            clearTimeout(singleHoverId);
        });

        // 2. Linki do listy dokumentów wyświetlają okno wyboru dokumentu
        hover($('.document-preview-multiple')).on("click", function(){
            showPreview(this);
        });

        // 3. Kursor
        $('.document-preview').parent('td').css('cursor', 'default');

        Ext.onReady(function(){
            Ext.QuickTips.init();
            Ext.apply(Ext.QuickTips.getQuickTip(), {
                dismissDelay: 0
            });
        }, {single: true});
    });

})(jQuery);
