Ext.namespace('Ext.ux.plusmpm');

/**
 * Dodatkowe parametry konfiguracyjne:
 *
 * config.variableSetConfig.storeId : String config.variableSetConfig.processId :
 * String config.variableSetConfig.activityId : String
 * config.variableSetConfig.variables : Array
 * config.variableSetConfig.variablesEditorConfig : Array
 * config.variableSetConfig.targetDivId : String
 * config.variableSetConfig.local : Boolean
 *
 */
Ext.ux.plusmpm.VariableSetEditorGridPanel = function(config) {

    var writer = new Ext.data.JsonWriter({
        encode : true,
        writeAllFields : false
    });

    var proxy = ( config.variableSetConfig.local ) ? new Ext.ux.plusmpm.LocalProxy(config.variableSetConfig.variables) : new Ext.data.HttpProxy( {
        url: 'com.plusmpm.servlet.VariableSetOperationsServlet.customServlet'
    } );

    var store;
    if (config.variableSetConfig.local) {
        store = new Ext.data.JsonStore({
            proxy : proxy,
            writer : writer,
            storeId : config.variableSetConfig.storeId,
            autoSave : true,
            autoDestroy : true,
            batch : true
        });
        proxy.initStore(store); // skojarzenie proxy ze storem
    } else {
        store = new Ext.data.JsonStore({
            proxy : proxy,
            writer : writer,
            storeId : config.variableSetConfig.storeId,
            autoSave : true,
            autoDestroy : true,
            batch : true,
            baseParams : {
                setId : config.variableSetConfig.setId,
                processId : config.variableSetConfig.processId,
                activityId : config.variableSetConfig.activityId,
                workflowVariables : config.variableSetConfig.variables
            }
        });
    }

    var view = new Ext.grid.GridView({
        autoFill : true
    });

    var extKeyMapInsert = {
        key : Ext.EventObject.INSERT,
        handler : function(nKeyCode, extEventObject) {
            return this.onAdd(null, extEventObject);
        },
        scope : this
    };

    var extKeyMapDelete = {
        key : Ext.EventObject.DELETE,
        handler : function(nKeyCode, extEventObject) {
            return this.onRemove(null, extEventObject);
        },
        scope : this
    };

    var selectionModel = new Ext.grid.CellSelectionModel({
        onEditorKey : function(field, e) {
            if (e.getKey() == e.TAB) {
                if (typeof (field.tabAction) != "undefined") {
                    field.tabAction();
                    field.show();
                }
            }
            this.constructor.prototype.onEditorKey.apply(this, arguments);
        },

        /**
         * Sprawdza, czy dana komórka może zostać zaznaczona (przy nawigacji strzałkami)
         */
        isSelectable : function(rowIndex, colIndex, cm){
            return !cm.isHidden(colIndex) && colIndex > 1; // nie jest ukryta i nie jest to kolumna z numerami
        },

        /**
         * Sprawdza, czy zaznaczona komórka jest ostatnią dla tego grida
         */
        isSelectedLast: function() {
            if ( !this.hasSelection() )
                return false;

            var grid = this.grid,
                rows = grid.getStore().getCount(),
                cell = this.getSelectedCell();

            if(cell[0] != rows - 1){
                return false; // nie jest w ostatnim wierszu
            }

            return this.isLastVisible(cell[1]);
        },

        /**
         * Sprawdza, czy zaznaczona komórka jest pierwszą dla tego grida
         */
        isSelectedFirst: function() {
            if ( !this.hasSelection() )
                return false;

            var grid = this.grid,
                cm = grid.getColumnModel(),
                cell = this.getSelectedCell(),
                column;

            for(var i=2; i<cm.config.length; i++){
                var col = cm.config[i];

                // pierwsza, nieukryta kolumna (oprócz kolumn numerowych etc)
                if(!col.hidden ){
                    column = i;
                    break;
                }
            }
            return ( cell[1] <= column ) && ( cell[0] == 0 );
        },

        isLastVisible: function(column){
            var cm = this.grid.getColumnModel(),
                lastColumnIndex = cm.getColumnCount() - 1;

            for(var i=column; i<lastColumnIndex; i++){
                if(cm.isHidden(i) == false){
                    return false;
                }
            }
            return true;
        }
    });

    config = Ext.apply({
        sm : selectionModel,
        stateful : false,
        iconCls : 'silk-table-edit',
        collapsible : true,
        titleCollapse : true,
        header : true,
        height: 250,
        width : 1000,
        store : store,
        columns : [],
        loadMask : true,
        frame : true,
        view : view,
        columnLines : true,
        keys : [ extKeyMapInsert, extKeyMapDelete ],
        bbar : [ {
            text : this.addRowText,
            tooltip : this.addRowTip,
            iconCls : 'dvnt-icon-plus-symbol',
            handler : this.onAdd,
            scope : this
        }, {
            ref : '../removeBtn',
            text : this.removeRowText,
            tooltip : this.removeRowTip,
            iconCls : 'dvnt-icon-x-symbol',
            disabled : true,
            handler : this.onRemove,
            scope : this
        }, {
            ref : '../copyBtn',
            text : this.copyRowText,
            tooltip : this.copyRowTip,
            iconCls : 'dvnt-icon-pen',
            disabled : true,
            handler : this.onCopy,
            scope : this
        } ],
        tools : [ {
            id : 'refresh',
            handler : this.onRefresh,
            scope : this,
            qtip : this.refreshTip
        } ]
    }, config);

    Ext.ux.plusmpm.VariableSetEditorGridPanel.superclass.constructor.call(this,
            config);
}; // end of Ext.ux.plusmpm.VariableSetEditorGridPanel constructor

Ext
        .extend(
                Ext.ux.plusmpm.VariableSetEditorGridPanel,
                Ext.grid.EditorGridPanel,
                {

                    // public
                    addRowText : PW.t('addRowText'),

                    // public
                    addRowTip : PW.t('addRowTip'),

                    // public
                    addRowErrorText : PW.t('addRowErrorText'),

                    // public
                    removeRowText : PW.t('removeRowText'),

                    // public
                    removeRowTip : PW.t('removeRowTip'),

                    // public
                    copyRowText : PW.t('copyRowText'),

                    // public
                    copyRowTip : PW.t('copyRowTip'),

                    // public
                    copyRowErrorText : PW.t('copyRowErrorText'),

                    // public
                    infoMsgTitle : PW.t('infoMsgTitle'),

                    // public
                    errorMsgTitle : PW.t('errorMsgTitle'),

                    // public
                    unknownErrorText : PW.t('unknownErrorText'),

                    // public
                    refreshTip : PW.t('refreshTip'),

                    // public
                    variablesDescription : "",

                    // public
                    showVariableDescToolTip : false,

                    // private
                    initComponent : function() {
                        Ext.ux.plusmpm.VariableSetEditorGridPanel.superclass.initComponent
                                .call(this);

                        this.relayEvents(this.getStore(), [ 'metachange', 'write', 'exception', 'load']);
                        this.on('metachange', this.onMetachange, this);
                        this.on('exception', this.onException, this);
                        this.on('expand', this.onCollapseExpand, this);
                        this.on('collapse', this.onCollapseExpand, this);
                        this.on('afterrender', this.onAfterRender, this);
                        this.on('validateedit', this.validateField, this);
                        this.on( Ext.EventManager.useKeydown ? 'keydown' : 'keypress', this.onTabKeyDown, this);

                        if(this.variableSetConfig.local == false){
                            this.on('write', this.onWrite, this);
                        }

                        this
                                .getSelectionModel()
                                .on(
                                        'selectionchange',
                                        function(sm) {
                                            if ((Ext.isDefined(this.removeBtn) === true)
                                                    && (this.removeBtn != null)) {
                                                this.removeBtn
                                                        .setDisabled(sm
                                                                .getSelectedCell() === null);
                                            }

                                            if ((Ext.isDefined(this.copyBtn) === true)
                                                    && (this.copyBtn != null)) {
                                                this.copyBtn
                                                        .setDisabled(sm
                                                                .getSelectedCell() === null);
                                            }
                                        }, this);
                    },

                    // private
                    onAfterRender : function() {
                        /**
                         * Usuwamy listener mouseWhell - standardowo edycja była zatrzymywana a zmiany anulowane.
                         */
                        this.removeWhellListener();

                        if (this.showVariableDescToolTip) {
                            var img = "<img style=\"padding-left: 5px\" src=\"pages/images/tooltip.png\"/>";

                            this.setTitle(this.title ? this.title + img : img);

                            var tooltipTarget = this.header.dom.children[2];
                            if (tooltipTarget) {
                                new Ext.ux.plusmpm.DescriptionToolTip({
                                    target : tooltipTarget,
                                    html : this.variablesDescription
                                });
                            }
                        }

                        // obejscie dla IE7 - wyswietlanie przycisków po lewej
                        // stronie
                        if (Ext.isIE7 && this.bbar) {
                            var toolbar = this.bbar.query("td.x-toolbar-left");
                            if (toolbar[0])
                                toolbar[0].id = "left";
                        }

                    },

                    removeWhellListener: function(){
                        var el = this.getGridEl();
                            whellListeners = Ext.EventManager.getListeners(el, 'mousewheel');

                        for(var i=0; i<whellListeners.length; i++){
                            var listener = whellListeners[i],
                                scope = listener[2],
                                fn = listener[0];

                            Ext.EventManager.removeListener(el, 'mousewheel', fn, scope);
                        }
                    },

                    // private
                    toggleCollapse : function(animate) {
                        if (this.showVariableDescToolTip) {
                            var tooltipTarget = this.header.dom.children[2];
                            if (!animate.within(tooltipTarget)
                                    && tooltipTarget != animate.target) {
                                Ext.ux.plusmpm.VariableSetEditorGridPanel.superclass.toggleCollapse
                                        .call(this, [ animate ]);
                            }
                        } else {
                            Ext.ux.plusmpm.VariableSetEditorGridPanel.superclass.toggleCollapse
                                    .call(this, [ animate ]);
                        }
                    },

                    // private
                    onCollapseExpand : function() {
                        this.onRefresh(null, null, this);
                        var panel = Ext.getCmp('activity_form_panel');
                        if (panel) {
                            panel.recalculateHeights();
                        }
                    },

                    // private
                    createRegex : function(sRegEx, sAttribute, sColumnHeader) {
                        var oRegEx = null;
                        try {
                            if (sRegEx && sRegEx.length > 0) {
                                oRegEx = new RegExp(sRegEx, "");
                            }
                        } catch (oError) {
                            oRegEx = null;
                            alert(oError + " Dotyczy atrybutu: '" + sAttribute
                                    + "' w kolumnie: " + sColumnHeader);
                        }
                        return oRegEx;
                    },

                    // private
                    onMetachange : function(oStore, oJsonMeta) {
                        /*
                         * wykonuje operacje redefiniowania tylko jezeli tabelka
                         * jeszcze nie zostala wyswietlona
                         */
                        if (this.rendered === false) {

                            // ustawiam parametry 'meta' obiektu 'writer'
                            // uzywanego przez 'oStore'
                            if (Ext.isDefined(oJsonMeta.root) === true) {
                                oStore.writer.meta.root = oJsonMeta.root;
                            }

                            if (Ext.isDefined(oJsonMeta.idProperty) === true) {
                                oStore.writer.meta.idProperty = oJsonMeta.idProperty;
                            }

                            if (Ext.isDefined(oJsonMeta.successProperty) === true) {
                                oStore.writer.meta.successProperty = oJsonMeta.successProperty;
                            }

                            // ustawiam kolumny przekazane w danych jsonData
                            if (Ext.isArray(oStore.reader.jsonData.columns) === true) {
                                var oJsonColumns;
                                if (Ext
                                        .isFunction(oStore.reader.jsonData.columns.clone) === true) {
                                    oJsonColumns = oStore.reader.jsonData.columns
                                            .clone();
                                } else {
                                    oJsonColumns = oStore.reader.jsonData.columns;
                                }

                                // od 1 bo na 0 pozycji jest id kolumy
                                for ( var nJCIterator = 1; nJCIterator < oJsonColumns.length; nJCIterator = nJCIterator + 1) {
                                    var oJsonColumn = oJsonColumns[nJCIterator];
                                    if (oJsonColumn.editor
                                            && oJsonColumn.editor.xtype) {
                                        // dodaje wybieracze combobox'owe
                                        if (oJsonColumn.editor.xtype == "combo") {
                                            // pozycja - 1, bo na 0 pozycji w
                                            // oJsonColumns jest id kolumy
                                            var oEditorConfig = this.variableSetConfig.variablesEditorConfig[nJCIterator - 1];

                                            if (oEditorConfig) {
                                                // dodaje referencje do obiektu
                                                // grid, zeby edytor typu
                                                // combobox mogl wplywac na
                                                // obiekt store tego grid'a
                                                oEditorConfig.comboboxConfig.oParentGrid = this;

                                                // tworze wybieracz
                                                var oComboBox = show_data_chooser_combobox(
                                                        oEditorConfig.chooserConfig,
                                                        oEditorConfig.comboboxConfig);

                                                // ustawiam zaznaczanie
                                                // zawartości po kliknięciu
                                                oComboBox.selectOnFocus = (oJsonColumn.editor.selectOnFocus == true);

                                                // ustawiam obsluge walidacji
                                                // wlasnym wyrazeniem regularnym
                                                oComboBox.regex = this
                                                        .createRegex(
                                                                oJsonColumn.editor.regex,
                                                                "regex",
                                                                oJsonColumn.header);

                                                // ustawiam obsluge wykluczenia
                                                // wprowadzania znakow wlasnym
                                                // wyrazeniem regularnym
                                                oComboBox.maskRe = this
                                                        .createRegex(
                                                                oJsonColumn.editor.maskRe,
                                                                "maskRe",
                                                                oJsonColumn.header);

                                                oJsonColumn.editor = oComboBox;
                                            }
                                        } else if (oJsonColumn.editor.xtype == "numberfield") {
                                            oJsonColumn.renderer = Ext.util.Format.mpm_numberEU;

                                            // ustawiam obsluge walidacji
                                            // wlasnym wyrazeniem regularnym
                                            oJsonColumn.editor.regex = this
                                                    .createRegex(
                                                            oJsonColumn.editor.regex,
                                                            "regex",
                                                            oJsonColumn.header);
                                        } else {
                                            // ustawiam obsluge walidacji
                                            // wlasnym wyrazeniem regularnym
                                            oJsonColumn.editor.regex = this
                                                    .createRegex(
                                                            oJsonColumn.editor.regex,
                                                            "regex",
                                                            oJsonColumn.header);

                                            // ustawiam obsluge wykluczenia
                                            // wprowadzania znakow wlasnym
                                            // wyrazeniem regularnym
                                            oJsonColumn.editor.maskRe = this
                                                    .createRegex(
                                                            oJsonColumn.editor.maskRe,
                                                            "maskRe",
                                                            oJsonColumn.header);
                                        }


                                        // ustawiam maksymalna wielkosc pola:
                                        oJsonColumn.editor.maxLength=4000;

                                        // ustawiam 'renderer' zawijajacy
                                        // wiersze
                                        // TODO poszukać lepszego sposobu na
                                        // zrobienie tego
                                        if (oJsonColumn.editor.xtype != "numberfield"
                                                && oJsonColumn.editor.xtype != "datefield") {
                                            oJsonColumn.renderer = function(
                                                    oValue, oMetadata, rRecord,
                                                    nRowIndex, nColIndex,
                                                    oStore) {
                                                oMetadata.attr = "style=\"white-space:normal;\"";
                                                return Ext.util.Format.htmlEncode(oValue);
                                            };
                                        }
                                    }

                                    // podkreślenie wymaganych kolumn
                                    var oJsonColumnField = this.getStore().fields
                                            .get(oJsonColumn.dataIndex);
                                    if (oJsonColumnField.allowBlank === false) {
                                        oJsonColumn.header = "<div style=\"text-decoration:underline;\">"
                                                + oJsonColumn.header + "</div>";
                                    }
                                }

                                oJsonColumns
                                        .unshift(new Ext.grid.RowNumberer());
                                // ustawiam fixed na false aby moc rozszerzac
                                // kolumne z numeracja
                                // w przypadku duzej ilosc wpisow
                                oJsonColumns[0].fixed = false;
                                oJsonColumns[0].width = 0;
                                // ustawiam model kolumn na podstawie otrzymanej
                                // konfiguracji
                                this.getColumnModel().setConfig(oJsonColumns,
                                        true);
                            }

                            // ustawiam listener'y zdefiniowane w metaData
                            try {
                                if (Ext.isDefined(oJsonMeta.listeners) === true
                                        && oJsonMeta.listeners !== null
                                        && oJsonMeta.listeners.length > 0) {
                                    for ( var nListenersIterator = 0; nListenersIterator < oJsonMeta.listeners.length; nListenersIterator = nListenersIterator + 1) {
                                        var oListener = oJsonMeta.listeners[nListenersIterator];
                                        switch (oListener.objectType) {
                                        case "STORE":
                                            oStore.addListener(
                                                    oListener.eventName,
                                                    eval(oListener.handler));
                                            break;
                                        case "GRID":
                                            this.addListener(
                                                    oListener.eventName,
                                                    eval(oListener.handler));
                                            break;
                                        case "SM":
                                            this
                                                    .getSelectionModel()
                                                    .addListener(
                                                            oListener.eventName,
                                                            eval(oListener.handler));
                                            break;
                                        }
                                    }
                                }
                            } catch (oError) {
                                alert("Błąd przy tworzeniu niestandardowych zdarzeń dla tabelki: "
                                        + oError);
                            }

                            // ustawiam dodatkowe przyciski zdefiniowane w
                            // metaData
                            try {
                                if (Ext.isDefined(oJsonMeta.buttons) === true
                                        && oJsonMeta.buttons !== null
                                        && oJsonMeta.buttons.length > 0) {
                                    Ext
                                            .each(
                                                    oJsonMeta.buttons,
                                                    function(oButton, nIndex,
                                                            oAllItems) {
                                                        oButton.ref = '../'
                                                                + oButton.id;
                                                        oButton.handler = eval(oButton.handler);
                                                        this.bottomToolbar
                                                                .addButton(oButton);
                                                    }, this);
                                }
                            } catch (oError) {
                                alert("Błąd przy tworzeniu dodatkowych przycisków dla tabelki: "
                                        + oError);
                            }

                            // ustawiam tytul tabelki
                            if (Ext.isDefined(oJsonMeta.dt_title) === true) {
                                this.setTitle(oJsonMeta.dt_title);
                            }

                            // tworzymy duzy opis dla wszystkich zmiennych
                            if (Ext.isDefined(oJsonMeta.fields) === true) {
                                if (!this.showVariableDescToolTip) {
                                    var tpl = Ext.DomHelper
                                            .createTemplate('<tr class=\"variable-description\"><td class=\"variable-description bold\">{0}</td><td class=\"variable-description\">{1}</td></tr>');

                                    this.variablesDescription = "<table><tbody>";
                                    for ( var i = 0; i < oJsonMeta.fields.length; i++) {
                                        if (oJsonMeta.fields[i].description) {
                                            var desc = oJsonMeta.fields[i].description;
                                            var variableName = oJsonMeta.fields[i].variableName;
                                            if (desc != null && desc != "") {
                                                this.showVariableDescToolTip = true;
                                                this.variablesDescription += tpl
                                                        .apply([
                                                                variableName
                                                                        + ':',
                                                                desc ]);
                                            }
                                        }
                                    }
                                    this.variablesDescription += "</tbody></table>";
                                }
                            }

                            // ustawiam 'zwijalnosc' tabelki
                            if (Ext.isDefined(oJsonMeta.dt_collapsible) === true) {
                                this.collapsible = oJsonMeta.dt_collapsible;
                                this.titleCollapse = oJsonMeta.dt_collapsible;
                            }

                            // ustawiam zapisywanie stanu w ciasteczkach
                            if (Ext.isDefined(oJsonMeta.dt_stateful) === true) {
                                this.stateful = oJsonMeta.dt_stateful;
                            } else {
                                // domyśle wartości
                                this.stateful = true;
                            }

                            // odtwarzam stan tabelki -
                            // GridPanel/EditorGridPaanel
                            if (this.stateful === true) {
                                // sprawdzam czy tabelka ma zapisany stan w
                                // ciasteczku, jezeli tak,
                                // to wylaczam automatyczne dopasowywanie
                                // szerokosci kolumn
                                if (Ext.state.Manager.get(this.getStateId(),
                                        false) !== false) {
                                    this.getView().autoFill = false;

                                    // i odczytuje zapisany stan tabelki
                                    this.mpm_restoreState();
                                }
                            }

                            this.render(this.variableSetConfig.targetDivId);
                        }
                    },

                    // private
                    onWrite : function(oStore, sAction, oResult,
                            transactionRes, rRs) {
                        // zeby odswiezyc numery wierszy, jedyny sposob
                        // identyfikacji wiersza tabelki
                        if (sAction === Ext.data.Api.actions.destroy
                                && transactionRes.success === true) {
                            oStore.reload({
                                params : {
                                    bNoMetaChange : true
                                }
                            });
                        }
                    },

                    // private
                    onException : function(oDataProxy, sType, sAction,
                            oOptions, oResponse, mixedArg) {
                        var sTitle = this.errorMsgTitle;
                        var sMsg = this.unknownErrorText;

                        if ((Ext.isDefined(oResponse.raw) === true)
                                && (Ext.isDefined(oResponse.raw.message) === true)) {
                            sMsg = oResponse.raw.message;
                        } else if (Ext.isDefined(mixedArg) === true) {
                            sMsg = mixedArg;
                        }

                        Ext.Msg.show({
                            title : sTitle,
                            msg : sMsg,
                            buttons : Ext.MessageBox.OK,
                            icon : Ext.MessageBox.ERROR
                        });

                        // na wszelki wypadek odswiezam tabelke, zeby uniknac
                        // niespojnosci po wystapieniu bledu
                        this.getStore().reload({
                            params : {
                                bNoMetaChange : true
                            }
                        });
                    },

                    // private
                    onAdd : function(oButton, oEvent) {
                        var oStore = this.getStore();
                        if (oStore.mpm_hasPhantomRecords() === false) {
                            try {
                                // wylaczam auto-zapis zeby nie wysylac pustego
                                // wiersza do serwera
                                oStore.autoSave = false;

                                var oNewRecord = new oStore.recordType({});
                                oStore.fields.each(function(oItem, nIndex,
                                        nLength) {
                                    oNewRecord.set(oItem.name, '');
                                });
                                oNewRecord.markDirty();

                                this.stopEditing();
                                oStore.add(oNewRecord);
                                this.getView().refresh();
                                this.startEditing((oStore.getCount() - 1), 2);
                            } finally {
                                oStore.autoSave = true;
                            }
                        } else {
                            Ext.Msg.show({
                                title : this.infoMsgTitle,
                                msg : this.addRowErrorText,
                                buttons : Ext.MessageBox.OK,
                                animEl : oButton,
                                icon : Ext.MessageBox.INFO,
                                scope : this,
                                fn : function(sButtonId, sText, oOpt) {
                                    this.startEditing((this.getStore()
                                            .getCount() - 1), 2);
                                }
                            });
                            return false;
                        }
                    },

                    // private
                    onRemove : function(oButton, oEvent) {
                        var index = this.getSelectionModel().getSelectedCell();
                        if (!index) {
                            return false;
                        }

                        this.stopEditing();
                        this.getStore().removeAt(index[0]);
                        this.getView().refresh();
                    },

                    // private
                    onCopy : function(oButton, oEvent) {
                        if (this.getStore().mpm_hasPhantomRecords() === false ) {
                            var index = this.getSelectionModel()
                                    .getSelectedCell();
                            if (!index) {
                                return false;
                            }
                            this.stopEditing();

                            var oSelectedRecord = this.getStore().getAt(
                                    index[0]);
                            var oNewRecord = oSelectedRecord.copy(-1);

                            oNewRecord.id = Ext.data.Record.id(oNewRecord);
                            oNewRecord.markDirty();

                            this.getStore().add(oNewRecord);
                            this.getView().refresh();
                            this.startEditing((this.getStore().getCount() - 1),
                                    2);
                        } else {
                            Ext.Msg.show({
                                title : this.infoMsgTitle,
                                msg : this.copyRowErrorText,
                                buttons : Ext.MessageBox.OK,
                                animEl : oButton,
                                icon : Ext.MessageBox.INFO,
                                scope : this,
                                fn : function(sButtonId, sText, oOpt) {
                                    this.startEditing((this.getStore()
                                            .getCount() - 1), 2);
                                }
                            });
                            return false;
                        }
                    },

                    // private
                    onRefresh : function(event, toolEl, panel, tc, saveState) {
                        try {
                            // zawieszam zdarzenia na czas resetowania
                            panel.suspendEvents(false);

                            // wlaczam automatyczne dopasowywanie szerokosci
                            // kolumn
                            panel.getView().forceFit = true;

                            // przerywam edycje kolumn
                            panel.stopEditing();

                            // pobieram początkowe definicje kolumn
                            var oJsonColumns = panel.getStore().reader.jsonData.columns;

                            // resetuje widoczność kolumn
                            var nRowNumbererColIndex = panel.getColumnModel()
                                    .getIndexById(
                                            Ext.grid.RowNumberer.prototype.id);
                            panel.getColumnModel().moveColumn(
                                    nRowNumbererColIndex, 0);

                            if ( oJsonColumns ) {
                                oJsonColumns.each(function(oItem, nIndex, nLength) {
                                    var nColumnIndex = panel.getColumnModel()
                                            .getIndexById(oItem.id);
                                    panel.getColumnModel().setHidden(nColumnIndex,
                                            oItem.hidden === true);
                                    // +1 bo pierwsza kolumna to numeracja
                                    panel.getColumnModel().moveColumn(nColumnIndex,
                                            (nIndex + 1));
                                });
                            }

                            // odswiezam widok kolumn
                            panel.getView().fitColumns(false);
                            panel.getView().refresh(true);
                        } finally {
                            // wylaczam automatyczne dopasowywanie szerokosci
                            // kolumn
                            panel.getView().forceFit = false;

                            if(saveState){
                                // usuwam ciasteczko zapisanego stanu
                                panel.mpm_clearState();
                            }

                            // odwieszam zdarzenia po zakonczeniu resetowania
                            panel.resumeEvents();
                        }
                    },

                    /**
                     * Waliduje edytowane pole. Nie pozwala na zapis średnków, wyświetla okienko z propozycją zamiany
                     */
                    validateField: function(event){
                        var value = event.value;

                        if(Ext.isString(value) && value.indexOf(';') > -1){
                            value = value.replace(/;/g,',');
                            event.value = value;
                        }
                    },

                    onTabKeyDown: function( event ) {
                        if ( event.getKey() != event.TAB )
                            return;

                        var sm = this.getSelectionModel();

                        if(event.shiftKey && sm.isSelectedFirst()){
                            // focus na pierwszy TD - przeglądarka wykona akcję i przejdzie to poprzedniego elementu
                            this.view.scroller.child('td[tabindex]').focus();
                            return false;
                        }
                        else if(!event.shiftKey && sm.isSelectedLast()){
                            // focus na ten element - bo w tym momencie focus moze mieć np. jakiś TD
                            this.view.focusEl.focus();
                            return false;
                        }
                    }
                });
