// Zmienna reprezentuje pole z przewijanym tekstem 

var Slider = {

	isAnimating : false,
	container : null,
	text : null,
	counterField : [],
	counter: 0,
	headerNotification: null,
	headerNotificationCounterField: null,
	
	unconfirmedFailure : false,
	
	activeSuccessCls: 'active-success',
	activeFailureCls: 'active-failure',
	

	store : new Ext.data.JsonStore({
		autoDestroy : true,
		url : Suncode.getAbsolutePath('com.plusmpm.servlet.notifications.NotificationManagerServlet.customServlet'),
		baseParams : {
			type : 'latest'
		},
		autoLoad : false,
		fields : [ {
			name : 'id',
			type : 'string'
		}, {
			name : 'sender',
			type : 'string'
		}, {
			name : 'date',
			type : 'date',
			dateFormat : 'Y-m-d H:i:s'
		}, {
			name : 'message',
			type : 'string'
		}, {
			name : 'failure',
			type : 'bool'
		} ]
	}),
	
	setHeaderNotificationCounterVisibility : function(visibility){
		if(visibility){
			this.headerNotificationCounterField.removeClass('hide');
		}
		else{
			this.headerNotificationCounterField.addClass('hide');
		}
	},
	
	updateCounterField : function(failure){
		this.counter++;
		Ext.each(this.counterField, function(field){
			field.innerHTML = this.counter;
		}, this);
		
		if(failure){
		    this.unconfirmedFailure = true;
		}
	},
	
	setCounterField : function(count){
		Ext.each(this.counterField, function(field){
			field.innerHTML = count;
		}, this);
		if(count>0){
			this.setHeaderNotificationCounterVisibility(true);
		}
		else{
			this.setHeaderNotificationCounterVisibility(false);
		}
	},
	
	addToCounterField : function(add){
		this.counter += add;
		Ext.each(this.counterField, function(field){
			field.innerHTML = this.counter;
		}, this);
		this.setHeaderNotificationCounterVisibility(true)
	},
	
	resetCounterField : function(){
		this.counter = 0;
		this.unconfirmedFailure = false;
		Ext.each(this.counterField, function(field){
			field.innerHTML = this.counter;
		}, this);
		this.setHeaderNotificationCounterVisibility(false);
	},
	
	initializeCounterField : function(){
		Ext.Ajax.request({
			url : Suncode.getAbsolutePath('com.plusmpm.servlet.notifications.NotificationManagerServlet.customServlet'),
		   success: function(result){
		   		var jsonData = Ext.util.JSON.decode(result.responseText);
		   		if(jsonData.count >0)
		   		{
		   		    Slider.unconfirmedFailure = jsonData.failure;
		   			Slider.setCounterField(jsonData.count);
		   		}
		   		else
		   		{
		   			Slider.resetCounterField();
		   		}
		   },
		   failure: null,
		   headers: {
		       'my-header': 'foo'
		   },
		   params: { 
				type : 'unconfirmed'
		   }
		});
	},

	initialize : function() {
		this.headerNotificationCounterField = Ext.get('header-notification-counter');
		this.counterField = Ext.query('.notification-counter');
		
		this.initializeCounterField();
	},

	queue : new Array(),

	animateNextInQueue : function() {
		if (Slider.queue.length > 0) {
		    
			Slider.isAnimating = true;
			var record = Slider.queue[0];
			Slider.queue.shift();
			Slider.reload(record.get('id'),record.get('date'), record.get('message'), record.get('sender'));
		} else {
			Slider.isAnimating = false;
		}

	},

	reload : function(id,date, message, sender) {
		this.hide(function() {
			Slider.text.dom.innerHTML = "[<b>"+sender+"</b>](" + Ext.util.Format.date(date,'Y-m-d H:i:s') + ") " + message;
			Slider.show(Slider.slide());
		});
		setTimeout(function(){
		    Slider.confirmNotif(id);
		},2000);
	},

	confirmNotif : function(id){
		Ext.Ajax.request({
			url : Suncode.getAbsolutePath('com.plusmpm.servlet.notifications.NotificationManagerServlet.customServlet'),
			success: function(result){
	
			},
			failure: null,
			headers: {
				'my-header': 'foo'
			},
			params: { 
				type : 'confirm',
				id: id
			}
		});
	},

	slide : function() {
		var containerWidth = this.container.getWidth();
		var textWidth = this.text.getWidth();

		if (containerWidth < textWidth) {
			setTimeout(function() {
				Slider.text.animate({
					left : {
						to : -1 * (textWidth - containerWidth + 10),
						unit : 'px'
					}
				}, 5,
				function() {
					setTimeout(function() {
						Slider.text.animate({
							left : {
								to : 0,
								unit : 'px'
							}
						}, 3,
						Slider.animateNextInQueue, 
						'easeOut', 
						'scroll' 

						);
					}, 3000);
				}, 
				'easeOut', 
				'scroll'
				);
			}, 3000);
		} else {
			setTimeout(function(){
				Slider.animateNextInQueue();
			},4000);
		}
	},

	notify : function(message) {
		Ext.Ajax.request({
			url : Suncode.getAbsolutePath('com.plusmpm.servlet.notifications.NotificationManagerServlet.customServlet'),
			success : function(data) {
				// Slider.reload(data);
			},
			failure : function() {
				console.warn("Wystapil blad podczas wysyłania powiadomienia");
				// Slider.text.dom.innerHTML = "";
			},
			headers : {
				'my-header' : 'foo'
			},
			params : {
				type : 'add',
				message : Ext.util.JSON.encode(message)
			}
		});
	},

	hide : function(callback) {
		this.text.setTop(-20);
		this.text.animate({
			top : {
				from : 0,
				to : -20,
				unit : 'px'
			}
		}, 0.35, // animation duration
		callback, // callback
		'easeOut', // easing method
		'scroll' // animation type ('run','color','motion','scroll'))
		);
	},

	show : function(callback) {
		this.text.setTop(20);
		this.text.animate({
			top : {
				from : 20,
				to : 0,
				unit : 'px'
			}
		}, 0.35, // animation duration
		callback, // callback
		'easeOut', // easing method
		'scroll' // animation type ('run','color','motion','scroll'))

		);
	}

};

/** ******************************************************** */
/* Ext.ux.plusmpm.NotificationPopupWindow */
/** ****************************************************** */

Ext.ux.plusmpm.NotificationPopupWindow = function(config) {

	var messagesStore = new Ext.data.JsonStore({
		autoDestroy : true,
		url : Suncode.getAbsolutePath('com.plusmpm.servlet.notifications.NotificationManagerServlet.customServlet'),
		autoLoad : {
			params : {
				start : 0,
				limit : config.pageSize
			}
		},
		baseParams : {
			type : 'list'
		},
		totalProperty : 'totalCount',
		root : 'records',
		fields : [ {
			name : 'id',
			type : 'int'
		}, {
			name : 'sender',
			type : 'string'
		}, {
			name : 'receiver',
			type : 'string'
		},{
			name : 'date',
			type : 'date',
			dateFormat : 'Y-m-d H:i:s'
		},{
			name : 'message',
			type : 'string'
		}, {
			name : 'failure',
			type : 'boolean'
		},{
			name : 'confirmed',
			type : 'boolean'
		} ]
	});
	
	messagesStore.on('exception', function(store, records, options){
			console.warn('Wystapil blad podczas pobierania powiadomień');
	});

	// pasek odpowiedzialny za przewijanie
	var bottomBar = new Ext.PagingToolbar({
		store : messagesStore,
		pageSize : config.pageSize,
		displayInfo : true,
		displayMsg : this.displaying,
		emptyMsg : this.empty
	});

	var grid = new Ext.grid.GridPanel({
		viewConfig : {
			forceFit : true,
			// zaznaczam wiersze, ktore zostaly oznaczone jako "fail"
			getRowClass : function(record, index) {
				var c = record.get('failure');
				if (c == true) {
					return 'fail-notification';
					
					
				}
			}
		},
		border: false,
		disableSelection : true,
		store : messagesStore,
		loadMask : true,
		stateful : true,
		stateId : 'notification-grid',
		autoExpandColumn : 'message',
		bbar : bottomBar,
		columns : [ {
			width : 50,
			header : this.dateText,
			sortable : true,
			renderer : Ext.util.Format.dateRenderer('Y-m-d H:i:s'),
			dataIndex : 'date'
		}, {
			width : 40,
			header : this.senderText,
			sortable : true,
			dataIndex : 'sender'
		}, {
			width : 150,
			header : this.messageText,
			sortable : true,
			dataIndex : 'message',
			renderer : function(value, p, record) {
				return String.format('<p style=\"white-space:normal\";>{0}</p>', record.data['message']);
			}
		} ]
	});

	config = Ext.apply({
		layout : 'fit',
		height : 400,
		width : 700,
		minHeight : 400,
		minWidth : 400,
		closable : true,
		modal : true,
		stateful : true,
		frame: false,
		shadow: false,
		stateId : 'notication-window',
		constrainHeader : true,
		title : this.titleMessage,
		items : grid,
		defaultButton : grid

	}, config);

	Ext.ux.plusmpm.NotificationPopupWindow.superclass.constructor.call(this, config);
}; // End of Ext.ux.plusmpm.NotificationPopupWindow

Ext.extend(Ext.ux.plusmpm.NotificationPopupWindow, Ext.Window, {
	messageText : PW.t('messageText'),
	dateText : PW.t('dateText'),
	senderText : PW.t('senderText'),
	titleMessage : PW.t('titleMessage'),
	empty: PW.t('empty'),
	displaying: PW.t('displaying')
});