Ext.namespace('Ext.suncode.dashboard');

var messages = Suncode.context('dashboard').messages;

/**
 * Panel layout auto: -> panele z layout-column
 */
Ext.suncode.dashboard.Dashboard = Ext.extend(Ext.Container, {
  layoutManager: undefined,
  boxMinHeight: 500,
  gadgetsCount: 0,
  gadgetsLoaded: 0,

  constructor: function (targetDiv, config) {
    const promiseStartDate = new Promise((resolve, reject) => {
      Ext.Ajax.request({
        scope: this,
        url: 'api/server/time',
        success: function (response) {
          resolve(JSON.parse(response.responseText));
        },
        failure: function (response) {
          PW.Logger.error('Audit save error status:' + response.status + ' response: ' + response.responseText);
          resolve(null);
        },
      });
    });

    promiseStartDate.then(result => {
      this.startGenerateDate = result;

      this.layoutManager = new Ext.suncode.dashboard.LayoutManager({
        owner: config.owner.userName,
        gadgets: config.gadgets,
      });

      this.renderTo = targetDiv;

      this.id = config.id;
      this.owner = config.owner;
      this.name = config.name;
      this.isOwner = Suncode.getCurrentUser() === this.owner.userName;

      this.isEditMode = false;

      Ext.suncode.dashboard.Dashboard.superclass.constructor.call(this, {
        applyTo: config.applyTo,
      });

      this.items.get('toolbar').items.get('dashboardsCombo').setRawValue(config.translatedName);
    });
  },

  initComponent: function () {
    Ext.suncode.dashboard.Dashboard.superclass.initComponent.call(this);
    // ustawienie instancji ogolniedostepnej
    Ext.suncode.dashboard.Dashboard.instance = this;

    // toolbar
    this.add(this.getToolbar());

    // gadgets
    this.gadgetArea = new Ext.Container({
      defaultType: 'dashboard-gadget',
      cls: 'gadget-area',
      net: undefined,
      minHeight: 500,
      height: 500,
      items: [],
      listeners: {
        render: function (gadgetArea) {
          gadgetArea.setWidth(gadgetArea.getWidth());
          gadgetArea.net = Math.floor(gadgetArea.getWidth() / 12);
        },
      },
    });
    this.add(this.gadgetArea);
  },

  listeners: {
    afterrender: function (dashboard) {
      dashboard.getLayoutManager().setGadgetArea(dashboard.gadgetArea);
      this.gadgetsCount = dashboard.getLayoutManager().gadgets.items.filter(gadget => gadget.available).length;
      dashboard.getLayoutManager().loadGadgets();
    },
  },

  increaseGadgetsLoaded: function () {
    this.gadgetsLoaded++;

    if (this.gadgetsCount == this.gadgetsLoaded) {
      this.saveAudit();
    }
  },

  saveAudit: function () {
    Ext.Ajax.request({
      scope: this,
      url: 'api/dashboard/audit',
      method: 'POST',
      params: {
        dashboardId: this.id,
        started: this.startGenerateDate,
      },
      failure: function (response, options) {
        PW.Logger.error('Audit save error status:' + response.status + ' response: ' + response.responseText);
      },
    });
  },

  getToolbar: function () {
    var store = new Ext.data.JsonStore({
        proxy: new Ext.data.HttpProxy({
            method: 'GET',
            url: 'api/dashboards/query?type=all',
        }),
        root: 'data',
        fields: [
            {name: 'id', type: 'int'},
            {name: 'name', type: 'string'},
            {name: 'translatedName', type: 'string'},
        ],
        listeners: {
            load: function (store) {
                store.each(function (record) {
                    const encodedName = Ext.util.Format.htmlEncode(record.get('translatedName'));
                    record.set('translatedName', encodedName);
                });
            }
        }
    });

    var dashboardsCombo = new Ext.form.ComboBox({
      itemId: 'dashboardsCombo',
      name: 'dashboards',
      forceSelection: true,
      store: store,
      triggerAction: 'all',
      editable: false,
      displayField: 'translatedName',
      valueField: 'name',
      listClass: 'dashboard-select-list',
      triggerClass: 'dvnt-icon-chevron-right dvnt-table-black-icon',
      width: 430,
      listeners: {
        select: function(combo, record, index) {
          var mask = new Ext.LoadMask(Ext.getBody());
          mask.show();

          window.location.href = '?id=' + record.get('id');
        }
      },
    });

    var toolbarMargin = window.localStorage.hasOwnProperty('dockMenu') && window.localStorage.getItem('dockMenu') === 'true' ? 0 : 30;

    return {
      xtype: 'toolbar',
      itemId: 'toolbar',
      cls: 'dashboard-toolbar',
      scope: this,
      style: 'margin-right: ' + toolbarMargin + 'px;',
      items: [
        dashboardsCombo,
        '->',
        {
          xtype: 'button',
          id: 'save',
          iconCls: 'dvnt-icon-save dvnt-blue-icon',
          text: messages('button.save'),
          hidden: true,
          scope: this,
          handler: function () {
            this.getLayoutManager().saveLayout(true);
          },
        },
        {
          xtype: 'button',
          id: 'add',
          iconCls: 'dvnt-icon-plus-circle dvnt-blue-icon',
          text: messages('button.addgadget'),
          scope: this,
          handler: this.showGadgetBrowser,
          hidden: true,
        },
        {
          xtype: 'button',
          id: 'edit',
          iconCls: 'dvnt-icon-edit dvnt-blue-icon',
          text: messages('button.editmode'),
          enableToggle: true,
          disabled: !this.isOwner,
          handler: function (button, e) {
            if (button.pressed === true) {
              button.ownerCt.find('id', 'save')[0].setVisible(true);
              button.ownerCt.find('id', 'add')[0].setVisible(true);

              this.isEditMode = true;

              this.gadgetArea.items.each(function (gadget) {
                this.getLayoutManager().activateDD(gadget);
                this.getLayoutManager().activateResizer(gadget);
                gadget.tools.maximize.addClass('disabled-tool');
                gadget.tools.maximize.disabled = true;

                if (gadget.valid) {
                  gadget.settingsMenu.find('itemId', 'autoheight')[0].setDisabled(false);
                }
                if (gadget.gadget.borderHidden) {
                  gadget.removeClass('header-hidden');
                  this.getLayoutManager().recalculatePositions();
                }
              }, this);
            } else {
              button.ownerCt.find('id', 'save')[0].setVisible(false);
              button.ownerCt.find('id', 'add')[0].setVisible(false);

              this.isEditMode = false;

              this.gadgetArea.items.each(function (gadget) {
                this.getLayoutManager().deactivateDD(gadget);
                this.getLayoutManager().deactivateResizer(gadget);
                gadget.tools.maximize.removeClass('disabled-tool');
                gadget.tools.maximize.disabled = false;

                gadget.settingsMenu.find('itemId', 'autoheight')[0].setDisabled(true);

                if (gadget.gadget.borderHidden) {
                  gadget.addClass('header-hidden');
                  this.getLayoutManager().recalculatePositions();
                }
              }, this);
            }
          },
          scope: this,
        },
      ],
    };
  },

  showGadgetBrowser: function () {
    if (!this.gadgetBrowser) {
      this.gadgetBrowser = new Ext.suncode.dashboard.gadget.GadgetBrowser();
    }

    this.gadgetBrowser.show();
  },

  getCurrentLayout: function () {
    return this.getLayoutManager().getLayout();
  },

  getLayoutManager: function () {
    return this.layoutManager;
  },

  beforeDestroy: function () {
    this.dragdrop.unreg();
    Ext.suncode.dashboard.Dashboard.superclass.beforeDestroy.call(this);
  },

  setAddGadgetAndSaveButtonDisabled: function (disabled) {
    this.find('id', 'add')[0].setDisabled(disabled);
    this.find('id', 'save')[0].setDisabled(disabled);
  },
});

Ext.suncode.dashboard.Dashboard.setup = function (targetDiv, config) {
  return new Ext.suncode.dashboard.Dashboard(targetDiv, config);
};

Ext.suncode.dashboard.Dashboard.getInstance = function () {
  return Ext.suncode.dashboard.Dashboard.instance;
};

String.prototype.ellipse = function (maxLength) {
  if (this.length > maxLength) {
    return this.substr(0, maxLength - 3) + '...';
  }
  return this;
};
