(function (Ext) {
  Ext.define('Favourites.support.AssociationWriter', {
    extend: 'Ext.data.writer.Json',
    alias: 'writer.favourites-associations',

    getRecordData: function (record, operation) {
      var me = this,
        data;

      data = me.callParent(arguments);

      record.associations.each(function (as) {
        if (as.type === 'hasMany') {
          data[as.name] = me.getAssociationData(record, as);
        }
      });

      return data;
    },

    getAssociationData: function (record, association) {
      var me = this,
        data = [];

      record[association.name]().each(function (record) {
        data.push(me.getRecordData(record));
      });

      return data;
    },
  });
})(window.Ext4);
