(function (Ext) {
  /**
   * Ustawienia ulubionych
   */
  Ext.define('Favourites.Settings', {
    extend: 'Favourites.support.DestroyableApplication',

    statics: {
      create: function (renderTo) {
        Favourites.support.DestroyableApplication.destroyApp('Favourites.settings');

        Ext.application({
          extend: 'Favourites.Settings',
          name: 'Favourites.settings',
          appFolder: Favourites.resourcesPath('/js/favourites/settings'),
          renderTo: renderTo,
          autoCreateViewport: true,
          controllers: ['SettingsController'],
        });
      },
    },

    initViewport: function () {
      var me = this,
        renderTo = me.renderTo,
        viewport = me.getView('Viewport');

      if (viewport && renderTo) {
        me.viewport = viewport.create({
          renderTo: renderTo,
          listeners: {
            afterrender: Suncode.ui.hideLoading,
          },
        });
      }
    },
  });
})(Ext4);
