const ENDPOINT_URL = "/api/swagger/"

const urlToNameMap = {
    "plusworkflow": "Plusworkflow",
};

function getContextPath() {
    return window.location.pathname.split("/swagger-ui")[0];
}

function prepareURLS(urlToNameMap) {
    const API_URL = getContextPath() + ENDPOINT_URL;

    return Object.entries(urlToNameMap).map(([key, value]) => ({
        url: API_URL + key,
        name: value
    }));
}

const GlobalSecurityPlugin = (system) => ({
    rootInjects: {
        injectGlobalSecurity: () => {
            const jsonSpec = system.getState().toJSON().spec.json;

            if (!jsonSpec.security) {
                const updatedSpec = {
                    ...jsonSpec,
                    security: [{basicAuth: []}]
                };

                return system.specActions.updateJsonSpec(updatedSpec);
            }
        }
    }
});

const UrlMutatorPlugin = (system) => ({
    rootInjects: {
        setBasePath: (basePath) => {
            const jsonSpec = system.getState().toJSON().spec.json;
            const newJsonSpec = {...jsonSpec, basePath};

            return system.specActions.updateJsonSpec(newJsonSpec);
        },
        normalizePaths: () => {
            const jsonSpec = system.getState().toJSON().spec.json;
            const originalPaths = jsonSpec.paths || {};
            const normalizedPaths = {};

            Object.keys(originalPaths).forEach(path => {
                const normalizedPath = path.startsWith('/') ? path : '/' + path;
                normalizedPaths[normalizedPath] = originalPaths[path];
            });

            const newJsonSpec = {...jsonSpec, paths: normalizedPaths};
            return system.specActions.updateJsonSpec(newJsonSpec);
        }
    }
});

window.onload = function () {
    window.ui = SwaggerUIBundle({
        urls: prepareURLS(urlToNameMap),
        dom_id: '#swagger-ui',
        deepLinking: true,
        presets: [
            SwaggerUIBundle.presets.apis,
            SwaggerUIStandalonePreset
        ],
        plugins: [
            UrlMutatorPlugin,
            GlobalSecurityPlugin,
            SwaggerUIBundle.plugins.DownloadUrl
        ],
        layout: "StandaloneLayout",
        requestSnippetsEnabled: true,
        tryItOutEnabled: true,
        onComplete: () => {
            window.ui.setBasePath(getContextPath() + '/api');
            window.ui.normalizePaths(); //some paths start with '/', some not ;) TODO:PWFL-11812
            window.ui.injectGlobalSecurity();
        }
    });
};
