(function (Ext) {
  var messages = Suncode.context('dashboard').messages;

  Ext.define('Suncode.dashboard.settings.view.CreateDashboardForm', {
    extend: 'Suncode.dashboard.settings.view.StatusForm',
    alias: 'widget.dashboard-create-form',

    title: messages('dashboard.title'),
    bodyStyle: {
      border: '0',
    },
    initComponent: function () {
      Ext.apply(this, {
        style: {
          margin: '5px',
        },
        items: [
          {
            xtype: 'textfield',
            fieldLabel: messages('dashboard.name'),
            allowBlank: false,
            name: 'name',
          },
          {
            xtype: 'textarea',
            fieldLabel: messages('dashboard.description'),
            name: 'description',
          },
          {
            xtype: 'combobox',
            store: Ext.create('Suncode.dashboard.settings.store.Dashboards', { autoDestroy: true }),
            fieldLabel: messages('form.gadget.import'),
            name: 'importDashboard',
            queryMode: 'remote',
            displayField: 'translatedName',
            valueField: 'id',
            itemId: 'import',
            pageSize: 20
          },
            {
                xtype: 'textfield',
                fieldLabel: messages('TranslatedFieldType_ABBREVIATION'),
                maxLength: 3,
                name: 'abbreviation',
                fieldStyle: 'text-transform:uppercase;'
            },
            {
                xtype: 'combobox',
                store: Ext.create('Suncode.dashboard.settings.store.Colors', {autoLoad: true}),
                fieldLabel: messages('Kolor'),
                name: 'color',
                queryMode: 'remote',
                displayField: 'name',
                valueField: 'value',
                itemId: 'color',
                editable: false,
                listeners: {
                    afterrender: function() {
                        this.setValue('blue');
                    },
                }
            },
        ],
        dockedItems: [
          {
            xtype: 'toolbar',
            dock: 'bottom',
            ui: 'footer',
            defaults: {
              minWidth: 75,
            },
            items: [
              {
                xtype: 'tbtext',
                style: 'text-align: left;',
                flex: 1,
              },
              {
                xtype: 'button',
                cls: 'toolbar-button-overrides-secondary',
                width: '150px',
                text: messages('form.reset'),
                handler: this.clearForm,
                scope: this,
              },
              {
                xtype: 'button',
                cls: 'toolbar-button-overrides-primary',
                width: '150px',
                text: messages('form.create'),
                handler: this.createDashboard,
                scope: this,
              },
            ],
          },
        ],
      });

      this.callParent();

      this.importDashboardCombo = this.down('#import');
    },

    createDashboard: function () {
      if (this.isValid()) {
        this.setStatusLoading(messages('form.create.wait.msg'));

        let isSystemDashboard = false;
        if (!!this.importDashboardCombo.getValue()) {
          const dashboard = this.importDashboardCombo.getStore()
              .getById(this.importDashboardCombo.getValue())
              .data;
          isSystemDashboard = dashboard.type === 'SYSTEM';
        }

        this.submit({
          url: Suncode.context('dashboard').base + '/api/dashboards',
          params: {
            system: isSystemDashboard
          },
          success: function (form, action) {
            Ext.StoreManager.lookup('MyDashboards').load();
            this.setStatusSuccess(messages('form.create.success.msg'), true);
          },
          failure: function (form, action) {
            this.setStatusFailure(messages('form.create.failure.msg'), true);
          },
          scope: this,
        });
      }
    },
  });
})(Ext4);
