(function(Ext, messages) {

	Ext.define('Suncode.pluginmanager.view.Requirements', {
		extend : 'Ext.window.Window',
		alias : 'widget.pluginmanager-requirements',
		title: messages("view.validation.title"),

		closeAction: 'destroy',
        width: 750,
        modal: true,
        resizable: true,
        layout: {
            type: 'vbox',
            align : 'stretch',
            pack  : 'start'
        },

        constructor: function(props) {
            this.props = props;
            this.callParent();
        },

		initComponent : function() {
            var me = this,
                validation = me.props.validation;

            var items = [];
            if( !validation.licenseResolution.resolved ) {
                this.width = 500;
                items.push({
                    xtype: 'panel',
                    border: false,
                    padding: '10 20',
                    layout: {
                        type: 'vbox',
                        align: 'center',
                        pack: 'center'
                    },
                    items: [{
                        xtype: 'label',
                        text: messages("plugins.view.validation.license.expired")
                    }]
                });
            } else {
                items = [{
                    xtype: "pluginmanager-missingreq",
                    title: messages("view.validation.required.mandatory"),
                    missing: validation.missing.mandatory,
                    required: true,
                    flex: 1
                }, {
                    xtype: "pluginmanager-missingreq",
                    title: messages("view.validation.required.optional"),
                    missing: validation.missing.optional,
                    required: true,
                    flex: 1
                }, {
                    xtype: "pluginmanager-missingreq",
                    title: messages("view.validation.provided.mandatory"),
                    missing: validation.provided.mandatory,
                    flex: 1
                }, {
                    xtype: "pluginmanager-missingreq",
                    title: messages("view.validation.provided.optional"),
                    missing: validation.provided.optional,
                    flex: 1
                }];
            }

	        Ext.apply(me, {
                items: items,
	            buttons: [{
                    text: me.props.primaryText,
                    hidden: me.props.block,
                    handler: function() {
                        me.props.retry();
                        me.close();
                    }
                },{
                    text: me.props.block ? messages("view.validation.ok") : messages("view.validation.cancel"),
                    handler: function() {
                        me.close();
                    }
	            }]
	        });

	        me.callParent(arguments);
		}
	});

	Ext.define('Suncode.pluginmanager.view.MissingRequirements', {
        extend : 'Ext.grid.Panel',
        alias : 'widget.pluginmanager-missingreq',
        hideHeaders: true,
        border: false,
        disableSelection: true,
        viewConfig: {
            enableTextSelection:true
        },
        
        initComponent : function() {
            var me = this;
            
            var store = new Ext.data.JsonStore({
                proxy: {
                    type: 'memory'
                },
                data: me.missing,
                autoDestroy: true,
                fields: ['key', 'requiredVersions', 'resolution']
            });

            Ext.apply(me, {
                hidden: Ext.isEmpty(me.missing),
                store: store,
                columns: [
                    { dataIndex: 'key', flex: 1 },
                    { dataIndex: 'requiredVersions', width: 150, renderer: me.renderVersion},
                    { dataIndex: 'resolution', flex: 1, renderer: me.required ? me.renderResolutionRequired : me.renderResolutionProvided}
                ]
            });

            me.callParent(arguments);
        },

        renderVersion: function(versions){
            return versions.join(',  ');
        },

        renderResolutionRequired: function(resolution) {
            var text = {
                "MISSING": function(){
                    return messages("view.validation.required.missing");
                },
                "VERSION_MISMATCH": function(){
                    return messages("view.validation.required.mismatch", resolution.available);
                },
                "NOT_ACTIVE": function(){
                    return messages("view.validation.required.notActive");
                }
            };
            return text[resolution.type]();
        },

        renderResolutionProvided: function(resolution, meta, record) {
            var text = {
                "VERSION_MISMATCH": function(){
                    return messages("view.validation.provided.mismatch", record.get("requiredVersions"));
                }
            };
            return text[resolution.type]();
        }
    });
    

    Suncode.pluginmanager.view.Requirements.start = function(validation, retry) {
        new Suncode.pluginmanager.view.Requirements({
            block: !validation.licenseResolution.resolved ||
                   !Ext.isEmpty(validation.missing.mandatory),
            validation: validation,
            retry: retry,
            primaryText: messages("view.validation.start")
        }).show();
    };

    Suncode.pluginmanager.view.Requirements.update = function(validation, retry) {
        new Suncode.pluginmanager.view.Requirements({
            block: !Ext.isEmpty(validation.missing.mandatory),
            validation: validation,
            retry: retry,
            primaryText: messages("view.validation.update")
        }).show();
    };

    Suncode.pluginmanager.view.Requirements.stop = function(validation, retry) {
        new Suncode.pluginmanager.view.Requirements({
            block: false,
            validation: validation,
            retry: retry,
            primaryText: messages("view.validation.stop")
        }).show();
    };

    Suncode.pluginmanager.view.Requirements.uninstall = function(validation, retry) {
        new Suncode.pluginmanager.view.Requirements({
            block: false,
            validation: validation,
            retry: retry,
            primaryText: messages("view.validation.uninstall")
        }).show();
    };

}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));