function show_data_chooser_window(oChooserConfig, oWindowConfig)
{
	//-----------------------------------------------------------
	//przepisanie wartosci pol obiektu konfiguracyjnego do zmiennych lokalnych, dla wygody
	var sClassFullName = oChooserConfig.sClassFullName;
	var sCriteriaIds = oChooserConfig.sCriteriaIds;
	var sMappings = oChooserConfig.sMappings;
	var sCustomKeys_Keys = oChooserConfig.sCustomKeys_Keys;
	var sCustomKeys_Values = oChooserConfig.sCustomKeys_Values;
	var nPageSize = oChooserConfig.nPageSize;
	var sColumnTextAlign_Keys = oChooserConfig.sColumnTextAlign_Keys;
	var sColumnTextAlign_Values = oChooserConfig.sColumnTextAlign_Values;
	var sDefaultColumnTextAlign = oChooserConfig.sDefaultColumnTextAlign;

	var sWindowTitle = oWindowConfig.sWindowTitle;
	var sComboElementId = oWindowConfig.sComboElementId;
	//-----------------------------------------------------------
    //parsowanie mapowan
    var sChooserElementIds = new Array(sMappings.length);
    var sFormElementIds = new Array(sMappings.length);
    var sChooserElementNames = new Array(sMappings.length);

    for(var i = 0; i < sMappings.length; i = i + 1)
    {
        var sMappingsSplit = sMappings[i].split(";", 3);

        sChooserElementIds[i] = sMappingsSplit[0];
        sFormElementIds[i] = sMappingsSplit[1];
        sChooserElementNames[i] = sMappingsSplit[2];
    }

    //-----------------------------------------------------------
    //przygotowanie parametrow konfiguracyjnych

    var oFiltersItems = new Array(sMappings.length);
    var oColumnItems = new Array(sMappings.length);

    for(var j = 0; j < sMappings.length; j = j + 1)
    {
        //filtry
        var oFilterItem = new Object();
        oFilterItem.type = 'string';
        oFilterItem.dataIndex = sChooserElementIds[j];
        oFiltersItems[j] = oFilterItem;

        //kolumny
        var oColumnItem = new Object();
        oColumnItem.dataIndex = sChooserElementIds[j];
        oColumnItem.sortable = true;

        if(sChooserElementNames[j].length > 0)
        {
            oColumnItem.header = sChooserElementNames[j];
            oColumnItem.hidden = false;
        }
        else
        {
            oColumnItem.header = oColumnItem.dataIndex;
            oColumnItem.hidden = true;
        }

        //ustawienie wyrownania
        var textAlign = sDefaultColumnTextAlign;
		var columnTextAlignIndex = sColumnTextAlign_Keys.indexOf(oColumnItem.header);
		if(columnTextAlignIndex > -1)
		{
			textAlign = sColumnTextAlign_Values[columnTextAlignIndex];
		}
        oColumnItem.align = textAlign;

        oColumnItems[j] = oColumnItem;
    }
    oColumnItems.unshift(new Ext.grid.RowNumberer());

    //-----------------------------------------------------------
    //pobranie wartosci kryteriow
    var sCriteriaReal_Ids = new Array();
    var sCriteriaReal_Values = new Array();
    for(var k = 0; k < sCriteriaIds.length; k = k + 1)
    {
        var oDocumentElement = document.getElementById(sCriteriaIds[k]);
        if(oDocumentElement)
        {
            sCriteriaReal_Ids.push(sCriteriaIds[k]);
            if(oDocumentElement.value)
            {
                sCriteriaReal_Values.push(oDocumentElement.value);
            }
            else
            {
                sCriteriaReal_Values.push('');
            }
        }
        else
        {
        	oDocumentElement = document.getElementsByName(sCriteriaIds[k]);
        	if( (oDocumentElement !== null) && (oDocumentElement.length > 0) )
        	{
        		sCriteriaReal_Ids.push(sCriteriaIds[k]);
        		if(oDocumentElement[0] && oDocumentElement[0].value)
        		{
        			sCriteriaReal_Values.push(oDocumentElement[0].value);
        		}
                else
                {
                    sCriteriaReal_Values.push('');
                }
        	}
        	else
        	{
        		var objectValue;
        		try
        		{
	        		objectValue = eval(sCriteriaIds[k]);
        		}
        		catch(unhandledError)
        		{
        		}

        		sCriteriaReal_Ids.push(sCriteriaIds[k]);
        		if(Ext.isDefined(objectValue) && objectValue !== null)
        		{
        			sCriteriaReal_Values.push(objectValue);
        		}
                else
                {
                    sCriteriaReal_Values.push('');
                }
        	}
        }
    }

    //-----------------------------------------------------------
    //obiekty ExtJs
    var oFilters = new Ext.ux.grid.GridFilters({
      filters     : oFiltersItems
    });

    var oStore = new Ext.data.JsonStore({
        url         : 'com.plusmpm.servlet.GetDataChooserContentServlet.customServlet',
        remoteSort  : true,
        autoLoad    : {params:{start:0, limit:nPageSize}},
        autoDestroy : true,
        baseParams  : {
                       sClassFullName       : sClassFullName,
                       sCriteriaReal_Ids    : sCriteriaReal_Ids,
                       sCriteriaReal_Values : sCriteriaReal_Values,
                       sChooserElementIds   : sChooserElementIds,
                       sCustomKeys_Keys     : sCustomKeys_Keys,
                       sCustomKeys_Values   : sCustomKeys_Values,
                       sActivityId			: activityId,
                       sDataChooserId		: sComboElementId,
                       query                : Ext.get(sComboElementId).getValue()
                      }
    });

    // Po zaladowaniu zasobow probuje zaznaczyc pierwszy wiersz
    oStore.on('load',function(e){
    	oGrid.getSelectionModel().selectFirstRow();
    });


    var oPagingBar = new Ext.PagingToolbar({
       pageSize    : nPageSize,
       store       : oStore,
       displayInfo : true,
       plugins     : oFilters
    });

	var EnterKey = {
			key     : Ext.EventObject.ENTER,
			handler : function(field,e){
			   if(e.getKey()==e.ENTER){
				   oGrid.fireEvent('rowdblclick',oGrid,0, e, oGrid.getSelectionModel().getSelected());
			   }
			},
			scope   : oGrid
		};

    var oGrid = new Ext.grid.GridPanel({
       title            : '',
       store            : oStore,
       trackMouseOver   : false,
       disableSelection : false,
       loadMask         : true,
       stripeRows       : true,
       bbar             : oPagingBar,
       plugins          : oFilters,
       columns          : oColumnItems,
       keys				: [EnterKey],
       viewConfig       : {forceFit: true}
    });
    oGrid.colModel.defaultSortable = true;

	var data_window = new Ext.Window({
		layout         : 'fit',
        height         : 400,
        width          : 700,
        minHeight      : 400,
        minWidth       : 400,
        x          	   : 10,
        closable       : true,
        autoScroll     : true,
        modal          : true,
        stateful       : true,
        stateId		 	 : 'stateId_'+ processDefId + '_' + sComboElementId,
        constrainHeader: true,
        title          : sWindowTitle,
        items          : oGrid,
        defaultButton  : oGrid
    });


	data_window.on('close', function(eventObj){
		var zmienna = Ext.get(sComboElementId).focus();
	});

	oGrid.on('rowdblclick', function(oThisGrid, nRowIndex, eventObject, enterRow){

		// sprawdzamy czy event zostal wywolany przez klikniecie mysza czy nacisniecie Enter.
		var oThisDataRecordTMP;
		if (enterRow)
		{
			oThisDataRecordTMP = enterRow;
		}
		else
		{
			var oThisStoreTMP = oThisGrid.getStore();
			oThisDataRecordTMP = oThisStoreTMP.getAt(nRowIndex);
		}

		for(var nFormElementNum = 0; nFormElementNum < sFormElementIds.length; nFormElementNum = nFormElementNum + 1)
		{
			var oFormElement = document.getElementById( sFormElementIds[nFormElementNum] );
			if(oFormElement)
			{
				var oElementValue = oThisDataRecordTMP.get( sChooserElementIds[nFormElementNum] );
				oFormElement.value = oElementValue;
			}
		}
		//zamykam okno po wybraniu wiersza
		data_window.close();
    });



  	//wyswietlenie okna
    data_window.show();

    //ustawia focus na gridzie
	oGrid.getView().focusEl.focus();
}

function show_data_chooser_combobox(oChooserConfig, oComboboxConfig)
{
	//przepisanie wartosci pol obiektu konfiguracyjnego do zmiennych lokalnych, dla wygody
	var sClassFullName = oChooserConfig.sClassFullName;
	var sCriteriaIds = oChooserConfig.sCriteriaIds;
	var sMappings = oChooserConfig.sMappings;
	var sCustomKeys_Keys = oChooserConfig.sCustomKeys_Keys;
	var sCustomKeys_Values = oChooserConfig.sCustomKeys_Values;
	var nPageSize = oChooserConfig.nPageSize;
	var sColumnTextAlign_Keys = oChooserConfig.sColumnTextAlign_Keys;
	var sColumnTextAlign_Values = oChooserConfig.sColumnTextAlign_Values;
	var sDefaultColumnTextAlign = oChooserConfig.sDefaultColumnTextAlign;

	var bForceSelection = oComboboxConfig.bForceSelection;
	var bDisableKeyFilter = oComboboxConfig.bDisableKeyFilter;
	var lazyInit = oComboboxConfig.lazyInit;
	var sComboElementId = oComboboxConfig.sComboElementId;
	var bIsGridEditor = oComboboxConfig.bIsGridEditor;
	var oParentGrid = oComboboxConfig.oParentGrid;

	//-----------------------------------------------------------
    //parsowanie mapowan
    var sChooserElementIds = new Array(sMappings.length);
    var sFormElementIds = new Array(sMappings.length);
    var sChooserElementNames = new Array(sMappings.length);

    for(var i = 0; i < sMappings.length; i = i + 1)
    {
        var sMappingsSplit = sMappings[i].split(";", 3);

        sChooserElementIds[i] = sMappingsSplit[0];
        sFormElementIds[i] = sMappingsSplit[1];
        sChooserElementNames[i] = sMappingsSplit[2];
    }

    //-----------------------------------------------------------
    //przygotowanie parametrow konfiguracyjnych
    var sValueField = sChooserElementIds[0];
    var oColumnItems = new Array(sMappings.length);

    for(var j = 0; j < sMappings.length; j = j + 1)
    {
        var oColumnItem = new Object();
        oColumnItem.dataIndex = sChooserElementIds[j];

        if(sChooserElementNames[j].length > 0)
        {
            oColumnItem.header = sChooserElementNames[j];
            oColumnItem.hidden = false;
        }
        else
        {
            oColumnItem.header = oColumnItem.dataIndex;
            oColumnItem.hidden = true;
        }
        oColumnItems[j] = oColumnItem;

        // wartosc zwiazana ze sprawdzaniem poprawnego wprowadzenia
        if(sFormElementIds[j] == sComboElementId)
        {
        	sValueField = oColumnItem.dataIndex;
        }
    }

    //-----------------------------------------------------------
    //obiekty ExtJs
    var oStore = new Ext.data.JsonStore({
        url         : 'com.plusmpm.servlet.GetDataChooserContentServlet.customServlet',
        remoteSort  : true,
        autoDestroy : true,
        baseParams  : {
                        sClassFullName       : sClassFullName,
                        sCriteriaReal_Ids    : null,
                        sCriteriaReal_Values : null,
                        sChooserElementIds   : sChooserElementIds,
                        sCustomKeys_Keys     : sCustomKeys_Keys,
                        sCustomKeys_Values   : sCustomKeys_Values,
                        sActivityId			 : activityId,
                        sDataChooserId		 : sComboElementId
                      },
        queryInProgress : false
    });

    oStore.on('exception', function( dataProxy, type, action, options, response, arg ){
    	//odblokowanie zapytań
    	this.queryInProgress = false;
    }, oStore);

    oStore.on('load', function( store, records, options ){
    	store.queryInProgress = false;
    	if(options.params.query !== store.baseParams.query)
    	{
    		store.reload();
    	}
    });

    oStore.on('beforeload', function(oThisStore, oOptions){

    	if(oThisStore.queryInProgress)
    	{
    		return false;
    	}
    	else
    	{
    		oThisStore.queryInProgress = true;
    	}

	    //pobranie wartosci kryteriow
	    var sCriteriaReal_Ids_beforeload = new Array();
	    var sCriteriaReal_Values_beforeload = new Array();

	    for(var k_beforeload = 0; k_beforeload < sCriteriaIds.length; k_beforeload = k_beforeload + 1)
	    {
	    	//informuje, czy znaleziono wartosc, czy szukac dalej
	    	var bValueFound = false;

	    	if(bIsGridEditor === true)
	    	{
	    		if(oParentGrid && oParentGrid.rendered === true)
	    		{
    				var oParentGrid_SM = oParentGrid.getSelectionModel();
    				if(oParentGrid_SM && oParentGrid_SM.hasSelection())
    				{   
    				    var nSelectedRowIndex;
    				    if(oParentGrid_SM.getSelectedCell)
    					{
				            nSelectedRowIndex = oParentGrid_SM.getSelectedCell()[0];
    					}
    				    else if(oParentGrid_SM.getSelected)
                        {
    				        var record = oParentGrid_SM.getSelected();
    				        nSelectedRowIndex = record.store.indexOf(record);
                        }
    				    
    				    if ( Ext.isEmpty( nSelectedRowIndex ) == false ) {
                            try {
                                var oParentGrid_Store = oParentGrid.getStore();
                                var oParentGrid_SelectedRecord = oParentGrid_Store.getAt( nSelectedRowIndex );
                                if ( oParentGrid_SelectedRecord && oParentGrid_SelectedRecord.fields.containsKey(sCriteriaIds[k_beforeload]) ) {
                                    var oParentGrid_SelectedRecord_Value = oParentGrid_SelectedRecord.get( sCriteriaIds[k_beforeload] );
                                    sCriteriaReal_Ids_beforeload.push( sCriteriaIds[k_beforeload] );
                                    sCriteriaReal_Values_beforeload.push( oParentGrid_SelectedRecord_Value );
                                    bValueFound = true;
                                }
                            }
                            catch ( oError ) {
                                alert( "Zdarzenie obiektu Ext.data.JsonStore 'beforeload': " + oError );
                            }
                        }
		    		}
	    		}
	    	}

	    	if(bValueFound === false)
	    	{
		        var oDocumentElement_beforeload = document.getElementById(sCriteriaIds[k_beforeload]);
		        if(oDocumentElement_beforeload && oDocumentElement_beforeload.value!=undefined)
		        {
	            	sCriteriaReal_Ids_beforeload.push(sCriteriaIds[k_beforeload]);
	                sCriteriaReal_Values_beforeload.push(oDocumentElement_beforeload.value);
	                bValueFound = true;
		        }
		        else
		        {
		        	var oDocumentElements_beforeload = document.getElementsByName(sCriteriaIds[k_beforeload]);
		        	if( (oDocumentElements_beforeload !== null) && (oDocumentElements_beforeload.length > 0) )
		        	{
		        		if(oDocumentElements_beforeload[0] && oDocumentElements_beforeload[0].value)
		        		{
			            	sCriteriaReal_Ids_beforeload.push(sCriteriaIds[k_beforeload]);
			                sCriteriaReal_Values_beforeload.push(oDocumentElements_beforeload[0].value);
			                bValueFound = true;
		        		}
		        	}
		        	else
		        	{
		        		var objectValue;
		        		try
		        		{
			        		objectValue = eval(sCriteriaIds[k_beforeload]);
		        		}
		        		catch(unhandledError)
		        		{
		        		}

		        		if(Ext.isDefined(objectValue) && objectValue !== null)
		        		{
		        			sCriteriaReal_Ids_beforeload.push(sCriteriaIds[k_beforeload]);
		        			sCriteriaReal_Values_beforeload.push(objectValue);
		        			bValueFound = true;
		        		}
		        	}
		        }
	    	}

	    	if(bValueFound === false)
	    	{
            	sCriteriaReal_Ids_beforeload.push(sCriteriaIds[k_beforeload]);
                sCriteriaReal_Values_beforeload.push("");
                bValueFound = true;
	    	}
	    }
	    oThisStore.baseParams['sCriteriaReal_Ids'] = sCriteriaReal_Ids_beforeload;
	    oThisStore.baseParams['sCriteriaReal_Values'] = sCriteriaReal_Values_beforeload;

	    oThisStore.lastOptions.params['sCriteriaReal_Ids'] = sCriteriaReal_Ids_beforeload;
	    oThisStore.lastOptions.params['sCriteriaReal_Values'] = sCriteriaReal_Values_beforeload;
    });

	//buduje wyglad danych w listboxie
	var sResultTpl = "";
	var nCellWidth = 100 / oColumnItems.length;

	sResultTpl = sResultTpl.concat("<tpl for=\".\"><div class=\"search-item\"><table width = \"100%\"><tr style=\"height: 15px\">");
    for(var l = 0; l < oColumnItems.length; l = l + 1)
    {
    	if(oColumnItems[l].hidden === false)
    	{
    		var textAlign = sDefaultColumnTextAlign;
    		var columnTextAlignIndex = sColumnTextAlign_Keys.indexOf(oColumnItems[l].header);
    		if(columnTextAlignIndex > -1)
    		{
    			if(sColumnTextAlign_Values[columnTextAlignIndex] == "right" || sColumnTextAlign_Values[columnTextAlignIndex] == "left" || sColumnTextAlign_Values[columnTextAlignIndex]=="center")
    			{
    				textAlign = sColumnTextAlign_Values[columnTextAlignIndex];
    			}
    		}

    		sResultTpl = sResultTpl.concat("<td style=\"text-align: " + textAlign + "\" width = \"" + nCellWidth + "%\">{" + oColumnItems[l].dataIndex + "}</td>");
    	}
    }
	sResultTpl = sResultTpl.concat("</tr></table></div></tpl>");

    var oComboBox_tpl = new Ext.XTemplate(sResultTpl);

    var sComboBox_applyTo = sComboElementId;
	var	bComboBox_lazyRender = false;
	var bComboBox_selectOnFocus = true;

	if(bIsGridEditor)
	{
		sComboBox_applyTo = null;
		bComboBox_lazyRender = true;
		bComboBox_selectOnFocus = null; // jeżeli combobox jest edytorem grid'a, ustawiane przy tworzeniu grid'a
	}

	if(sComboBox_applyTo)
	{
		var inputBox = Ext.get(sComboBox_applyTo);
		if(inputBox)
			inputBox.dom.setAttribute("autocomplete", "off");
	}

    var oComboBox = new Ext.form.ComboBox({
        store            : oStore,
        itemSelector     : 'div.search-item',
        minChars         : 0,
        width            : 205,
        pageSize         : nPageSize,
        resizable        : true,
        valueField       : sValueField,
        displayField     : sValueField,
        forceSelection   : false,
        applyTo			 : sComboBox_applyTo,
        lazyRender       : bComboBox_lazyRender,
        selectOnFocus    : bComboBox_selectOnFocus,
        tpl              : oComboBox_tpl,
        autoSelect		 : false,
        stateful		 : true,
        stateId		 	 : 'stateId_'+ processDefId + '_' + sComboElementId,
        stateEvents		 : ['collapse'],
        getState 		 : function(){
        	return{
	        	listWidth: this.listWidth
        	}
        }
    });

    // wyłączenie filtrowania zawartości
    if(bDisableKeyFilter === true)
    {
    	oComboBox.triggerAction = 'all';
    }

    oComboBox.on('expand', function(combo) {
	// workaround dla IE7 - niewidoczny pasek stronicowania
		if (oComboBox.pageSize > 0 && Ext.isIE7) {
			combo.assetHeight = 28;
		}
	});


    if(!lazyInit)
    {
    	// Uwaga! Funkcja getRawValue() jest prywatna w klasie Ext.form.ComboBox
    	oComboBox.doQuery( oComboBox.getRawValue(), true );
    }

    oComboBox.on('beforequery', function(oQueryEvent){
    	//dzięki temu, zawartość listy będzie przeładowana zawsze, gdy lista będzie rozwijana
    	delete oQueryEvent.combo.lastQuery;

    	//wyłącza filtrowanie list na podstawie wprowadzonych znaków
    	if(bDisableKeyFilter === true && oQueryEvent.query.length > 0)
    	{
    		oQueryEvent.cancel = true;
    		return false;
    	}
    });

	oComboBox.on('select', function(oThisComboBox, oThisDataRecord, nRowIndex){
		if( Ext.isDefined(oThisComboBox.gridEditor) === true && oThisComboBox.gridEditor != null )
		{
			try
			{
				oThisComboBox.gridEditor.record.store.autoSave = false;
				oThisComboBox.gridEditor.record.beginEdit();

				for(var nElementNum = 0; nElementNum < sFormElementIds.length; nElementNum = nElementNum + 1)
				{
					var oNewValue = oThisDataRecord.get( sChooserElementIds[nElementNum] );
					if(oThisComboBox.gridEditor.record.store.fields.containsKey( sFormElementIds[nElementNum] ) === true)
					{
    					oThisComboBox.gridEditor.record.set( sFormElementIds[nElementNum], oNewValue );
					}
					else
			    	{
						var oFormElement = document.getElementById( sFormElementIds[nElementNum] );
						if(oFormElement)
						{
							oFormElement.value = oNewValue;
						}
			    	}
				}

				oThisComboBox.gridEditor.record.endEdit();
				oThisComboBox.gridEditor.record.store.save();
			}
			catch(oError)
			{
				alert(oError);
				oThisComboBox.gridEditor.record.cancelEdit();
				oThisComboBox.gridEditor.record.store.rejectChanges();
			}
			finally
			{
				oThisComboBox.gridEditor.record.store.autoSave = true;
			}
		}
		else
		{
			for(var nElementNum = 0; nElementNum < sFormElementIds.length; nElementNum = nElementNum + 1)
			{
				var oFormElement = document.getElementById( sFormElementIds[nElementNum] );
				if(oFormElement)
				{
					var oNewElementValue = oThisDataRecord.get( sChooserElementIds[nElementNum] );
					oFormElement.value = oNewElementValue;
				}
			}
		}
    });

    oComboBox.minListWidth = 245;
    if(oComboBox.width > oComboBox.minListWidth)
    {
    	oComboBox.minListWidth = oComboBox.width;
    }

    return oComboBox;
}

function add_chooser_link_to_field(sFieldId, sLinkHtml)
{
	var oField = document.getElementById(sFieldId);
	if(oField)
	{
		if(oField.parentNode)
		{
			oField.parentNode.innerHTML = oField.parentNode.innerHTML.concat(sLinkHtml);
		}
	}
}
