(function (Ext) {
    Ext.define('Suncode.deactivateUsers.view.TasksAssignment', {
        extend: 'Ext.container.Container',
        alias: 'widget.tasks-assignment',
        layout: {type: 'hbox', padding: 10, pack: 'center', align: 'middle'},
        defaults: {margin: '0 10 0 0'},
        initComponent: function () {

            Ext.apply(this, {
                items: [{
                    xtype: 'combo',
                    id: 'typeCombo',
                    fieldLabel: PW.t('assignto-label'),
                    labelWidth: 70,
                    disabled: true,
                    displayField: 'display',
                    valueField: 'type',
                    queryMode: 'local',
                    editable: false,
                    width: 250,
                    store: new Ext.data.Store({
                        fields: ['type', 'display'],
                        data: [{'type': 'USER', 'display': PW.t('assign-users')}, {
                            'type': 'GROUP',
                            'display': PW.t('assign-group')
                        }]
                    })
                }, {
                    xtype: 'combo',
                    id: 'datalist',
                    disabled: true,
                    pageSize: 10,
                    minChars: 1,
                    valueField: 'objectId',
                    displayField: 'name',
                    queryMode: 'remote',
                    flex: 1,
                    matchFieldWidth: false
                }, {
                    xtype: 'button',
                    text: PW.t('dodaj'),
                    iconCls: 'dvnt-icon-plus-circle',
                    id: 'addAssignButton',
                    action: 'addAssignButton',
                    disabled: true,
                    margin: '0 20 0 0'
                }, {
                    xtype: 'button',
                    text: PW.t('clean'),
                    iconCls: 'dvnt-icon-x-symbol',
                    id: 'clearButton',
                    action: 'clearButton',
                    disabled: true,
                    margin: 0
                }]
            });

            this.callParent();
        }
    });
}(this.Ext4));