(function(Ext) {
    
    Ext.define('Suncode.datasourcemanager.component.ParametersForm', {
        extend: 'Ext.form.FieldContainer',
        alias: 'widget.parametersContainer',
        mixins: ['Suncode.datasourcemanager.mixins.ToolTip'],
        cls: 'data-source-parameters-container',
        layout : {
            type : 'vbox',
            align: 'stretch'
        },
        defaults: {
            labelWidth: 200,
            labelPad: 10,
            allowBlank: false
        },
        
        parametersDefinition: new Ext.util.MixedCollection(),
        values: new Ext.util.MixedCollection(),

        findField: function(key){
            var fields = this.down('field');
            if(fields){
                return fields.findBy(function(field){
                    return f.id === key || f.name === key;
                });
            }
            return null;
        },

        buildParameters: function( componentDefinition, operation ) {
            this.removeAllParameters();
            this.registerParameters( componentDefinition.parameters );

            if( PW.DataSources.contains( componentDefinition.id ) ) {
                var formScript = PW.DataSources.get(componentDefinition.id);
                formScript.buildParams.call(formScript, new Suncode.datasourcemanager.api.DynamicFormApi(this), {
                    operation: operation
                } );
            }
            else {
                Ext.each(componentDefinition.parameters, function(parameter){
                    this.addParameter(parameter);
                }, this);
            }
        },
        
        removeAllParameters: function() {
            this.removeAll(true);
            this.parametersDefinition.removeAll();
        },
        
        isComponentParameter: function( id ) {
            return this.parametersDefinition.contains( id );
        },
        
        registerParameters: function(parameters){
            Ext.each(parameters, function(parameter){
                this.parametersDefinition.add(parameter.id, parameter);
            }, this);
        },
        
        addParameter: function(parameter){
            var lastPosition = this.items.getCount();
            this.insertParameter(lastPosition, parameter);
        },
        
        insertParameter: function(position, config, extraConfig){
            var field = this._prepareField(config, extraConfig);
            
            if(config.description && config.description != ''){
            	this.initTooltip(field, config);
            }
            
            return this.insert(position, field);
        },
        
        _prepareField: function(config, extraConfig){
        	var me = this,
	        	field = {};
	        
	        field.itemId = config.id;
	        field.name = config.id;
	        field.fieldLabel = config.name;
	        field.listeners = config.listeners;
	        field.allowBlank = config.optional === false ? false : true;
	        field.hidden = config.hidden;
            field.value = config.defaultValue == null ? undefined : config.defaultValue;
	        //field.readOnly = config.readOnly;
	        Ext.apply(field, me.getParamConfig(config));
	        
	        if(extraConfig){
	            Ext.apply(field, extraConfig);
	        }
	        
	        if(config.array && !config.grouped){
	        	field =  {
	        		xtype: 'multivaluefield',
	        		fieldLabel: config.name,
	        		itemId: config.id,
	        		name: config.id,
	        		fields: [field],
	        		grouped: false
	        	}
	        }

	        return field;
        },
        
        add: function(position, field) {
            if(this.isRow && this.items.getCount() > 0) {
                field.margin = '0 0 0 ' + this.fieldsSpace;
            }
            return this.callParent(arguments);
        },
        
        getParamConfig: function(parameter){
            var config = {};
            
            if(parameter.type == 'string'){
                config.xtype = 'textfield';
            }
            else if(parameter.type == 'float') {
                config.xtype = 'numberfield';
            }
            else if(parameter.type == 'integer') {
                config.xtype = 'numberfield';
                config.decimalPrecision = 0;
            }
            else if(parameter.type == 'date' ) {
                
                Ext.apply(config, {
                    xtype: 'datefield',
                    format: 'Y-m-d',
                    getSubmitValue: function(){
                        var me = this,
                        submitValue = Ext.form.field.Date.prototype.getSubmitValue.call(me);
                        
                        if(!Ext.isEmpty(submitValue)) {
                            return new Date(submitValue).getTime();
                        }
                        
                        return submitValue;
                    },
                    setValue: function(value){
                        var me = this;
                        
                        if(Ext.isNumeric(value)) {
                            value = new Date(value);
                        }
                        Ext.form.field.Date.prototype.setValue.call(me, value);
                    }
                });
            }
            else if( parameter.type == 'datetime' ) {
                Ext.apply(config, {
                    xtype: 'extendeddatetimefield',
                });
            }
            else if( parameter.type == 'boolean' ) {
                Ext.apply(config, {
                    xtype: 'checkbox',
                });
            }
            else {
                config.xtype = 'textfield';
            }
            
            return config;
        },
        
        getParametersCount: function(){
            return this.items.getCount();
        },
        
        setValues: function( values ) {
            this.values = new Ext.util.MixedCollection();
            Ext.iterate(values, function(parameterId, value){
                value = Ext.isArray(value) ? value : value.value;
                this.values.add(parameterId, value);
            }, this);
    
            this.items.each(function(item) {
                if(item.isXType('groupedmultivaluefield') || item.isXType('parametersContainer')){
                    item.setValues(values);
                }
                else {
                    if(this.values.containsKey(item.itemId)) {
                        var value = this.values.get(item.itemId);
                        if(item.isXType('combo')) {
                            item.setValue(value, true);
                        }
                        else {
                            item.setValue(value);
                        }
                    }
                }
            }, this);
        },
        
        _readDefinition: function( config ) {
            if( Ext.isString( config ) ) {
                config = {
                	id: config
                }
            }
            var definition = this.parametersDefinition.get( config.id );
            definition = Ext.apply({}, definition, config);
            
            return definition;
        }
        
    });
    
})(Ext4);