function getChangePasswordApp() {
    return new Vue({
        data: {
            currentPassword: '',
            newPassword: '',
            newPasswordConfirmed: '',
            isDomain: false,
            username: '',
            uuid: '',
            recoveryUpdate: false,
            domain: ''
        },

        computed: {
            samePasswords: function () {
                if (this.newPassword && this.newPasswordConfirmed) {
                    return this.newPassword == this.newPasswordConfirmed;
                }
                else {
                    return true;
                }
            },

            passwordStrength: function () {
                var score = 0;
                var newPassword = this.newPassword;

                if (!newPassword)
                    return score;

                var letters = {};
                newPassword.split('').forEach(function (character) {
                    letters[character] = (letters[character] || 0) + 1;
                    score += 5.0 / letters[character];
                });

                var variations = {
                    digits: /\d/.test(newPassword),
                    lower: /[a-z]/.test(newPassword),
                    upper: /[A-Z]/.test(newPassword),
                    nonWords: /\W/.test(newPassword),
                }

                var variationCount = 0;
                for (var check in variations) {
                    variationCount += (variations[check] == true) ? 1 : 0;
                }
                score += (variationCount - 1) * 10;
                score = parseInt(score);
                if (score > 100) {
                    score = 100;
                }

                return score;
            },

            passwordStrengthText: function () {
                var text = '';
                if (this.passwordStrength > 60) {
                    text = PW.t('Silne');
                }
                else if (this.passwordStrength > 30) {
                    text = PW.t('Srednie');
                }
                else {
                    text = PW.t('Slabe');
                }

                return text;
            },

            passwordColor: function () {
                var text = '';
                if (this.passwordStrength > 60) {
                    text = 'green';
                }
                else if (this.passwordStrength > 30) {
                    text = 'yellow';
                }
                else {
                    text = 'red';
                }

                return text;
            },

            dynamicStyleObject: function () {
                return {
                    width: this.passwordStrength + "%",
                    "background-color": this.passwordColor
                }
            }
        },

        mounted: function () {
			if (!this.ldapPasswordChange) {
				var me = this;
				jQuery.ajax({
					url: 'api/password/policy/profile',
					method: 'GET',
					data: {
						username: me.username,
					},
					success: function (data) {
						me.passwordPolicy = data;
					},
					error: function () {
						PW.Logger.error('Cannot get password policy profile');
					}
				});
			}
        },

        methods: {
            tryChangePassword: function () {
                var me = this;
                var mask = new Ext.LoadMask(Ext.getBody());
                mask.show();

                this.validate({
                    onSuccess: function () {
                        me.changePassword({
                            onComplete: function () {
                                mask.hide();
                            }
                        });
                    },
                    onError: function (error) {
                        PW.ui.Message.error(error);
                        mask.hide();
                    }
                });
            },

            validate: function (callback) {
                var resolve = callback.onSuccess;
                var reject = callback.onError;
                var newPassword = this.newPassword;
                var newPasswordConfirmed = this.newPasswordConfirmed;
                var oldPassword = this.currentPassword;

                if (this.recoveryUpdate && !this.uuid) {
                    reject(PW.t('Kod_jest_pusty'));
                    return;
                }

                if (!this.recoveryUpdate && !oldPassword) {
                    reject(PW.t('Obecne_haslo_jest_puste'));
                    return;
                }

                if (!newPassword) {
                    reject(PW.t('Nowe_haslo_jest_puste'));
                    return;
                }

                if (newPassword != newPasswordConfirmed) {
                    reject(PW.t('Hasla_nie_sa_takie_same'));
                    return;
                }

                if (!this.recoveryUpdate && newPassword == oldPassword) {
                    reject(PW.t('Nowe_haslo_jest_takie_samo_jak_stare_haslo'));
                    return;
                }

                this.validateByPasswordPolicyProfile({
                	onSuccess: function () {
                		resolve();
                	},
                	onError: function (message) {
                		reject(message);
                	}
               	});
            },

            validateByPasswordPolicyProfile: function (callback) {
                var resolve = callback.onSuccess;
                var reject = callback.onError;
                var newPassword = this.newPassword;

                if (this.passwordPolicy) {
                    if (newPassword.length < this.passwordPolicy.minPasswordLength) {
                        reject(PW.t('Haslo_jest_zbyt_krotkie', this.passwordPolicy.minPasswordLength))
                        return;
                    }

                    if (newPassword.length > this.passwordPolicy.maxPasswordLength) {
                        reject(PW.t('Haslo_jest_zbyt_dlugie', this.passwordPolicy.maxPasswordLength))
                        return;
                    }

                    if (this.passwordPolicy.requireNumbers && this.numberOfDigits(newPassword) == 0) {
                        reject(PW.t('Haslo_musi_posiadac_przynajmniej_jedna_cyfre'));
                        return;
                    }

                    if (this.passwordPolicy.requireVariableLetterSize && !this.containsVariableLetterSize(newPassword)) {
                        reject(PW.t('Haslo_musi_skladac_sie_z_wielkich_i_malych_liter'));
                        return;
                    }

                    if (this.passwordPolicy.requireSpecialCharacters && this.numberOfSpecialCharacters(newPassword) == 0) {
                        reject(PW.t('Haslo_musi_posiadac_przynajmniej_jeden_znak_specjalny'));
                        return;
                    }

                    if (newPassword.indexOf(' ') >= 0) {
                        reject(PW.t('Haslo_nie_moze_zawierac_spacji'));
                        return;
                    }

                    jQuery.ajax({
                        url: 'api/password/available',
                        method: 'POST',
                        data: {
                            username: this.username,
                            password: this.newPassword
                        },
                        success: function (data) {
                            if (data.newPasswordAvailable) {
                                resolve();
                            }
                            else {
                                reject(PW.t('Podane_nowe_haslo_zostalo_juz_uzyte_w_przeszlosci'))
                            }
                        },
                        error: function () {
                            reject(PW.t('Wystapil_problem_przy_sprawdzaniu_hasla'));
                        }
                    });
                }
                else {
                    resolve();
                }
            },

            changePassword: function (callback) {
                var me = this;

                var url = '';
                var data = {
                    password: this.newPassword,
                };

                if (this.recoveryUpdate) {
                    url = 'api/password/change/recovery';
                    data.uuid = this.uuid;
                }
                else if (this.ldapPasswordChange) {
                    url = 'api/password/ldap/change';
                    data.currentPassword = this.currentPassword;
                    data.username = this.username;
                    data.domain = this.domain;
                }
                else {
                    url = 'api/password/change';
                    data.currentPassword = this.currentPassword;
                    data.username = this.username;
                }

                jQuery.ajax({
                    url: url,
                    method: 'POST',
                    data: data,
                    complete: callback.onComplete,
                    success: function () {
                        PW.ui.Message.success(PW.t('Haslo_zostalo_zmienione'));
                        me.currentPassword = '';
                        me.newPassword = '';
                        me.newPasswordConfirmed = '';
                        me.uuid = '';

                        if (me.onPasswordChangedInUserTab) {
                            me.onPasswordChangedInUserTab();
                        }
                        if (me.onPasswordChanged) {
                            me.onPasswordChanged();
                        }

                    },
                    error: function (response) {
                        var message = PW.t('Wystapil_blad_podczas_zmiany_hasla');

                        if (response.responseJSON) {
                            if (response.responseJSON.incorrectCurrentPassword) {
                                message = PW.t('Aktualne_haslo_jest_nieprawidlowe');
                            } else if (response.responseJSON.incorrectUuid) {
                                message = PW.t('Wprowadzone_kod_jest_nieprawidlowy');
                            } else if (response.responseJSON.serverRestrictions) {
                                message = response.responseJSON.serverRestrictions;
                            } else if (response.responseJSON.message) {
                                message = response.responseJSON.message;
                            }
                        }

                        PW.ui.Message.error(message);
                    }
                });
            },

            isDigit: function (character) {
                return '0123456789'.split('').indexOf(character) >= 0;
            },

            numberOfDigits: function (text) {
                var me = this;
                var numberOfDigits = 0;
                text.split('').forEach(function (character) {
                    if (me.isDigit(character)) {
                        numberOfDigits++;
                    }
                });

                return numberOfDigits;
            },

            isLetter: function (character) {
                return character.match(/[a-z]/i);
            },

            containsVariableLetterSize: function (text) {
                var hasUppercase = false;
                var hasLowercase = false;

                var me = this;
                text.split('').forEach(function (character) {
                    if (me.isLetter(character)) {
                        if (character == character.toUpperCase()) {
                            hasLowercase = true;
                        }

                        if (character == character.toLowerCase()) {
                            hasUppercase = true;
                        }
                    }
                });

                return hasUppercase && hasLowercase;
            },

            numberOfSpecialCharacters: function (text) {
                var me = this;
                var numberOfSpecialCharacters = 0;
                text.split('').forEach(function (character) {
                    if (!(me.isLetter(character) || me.isDigit(character))) {
                        numberOfSpecialCharacters++;
                    }
                });

                return numberOfSpecialCharacters;
            }
        }
    });
}

module.exports = getChangePasswordApp();