(function (Ext) {
    Ext.define('Suncode.deactivateUsers.view.TasksGrid', {
        extend: 'Ext.tree.Panel',
        alias: 'widget.tasks-grid',
        id: 'tasks-grid',
        useArrows: true,
        rootVisible: true,
        multiSelect: true,
        singleExpand: false,
        columnLines: false,
        viewConfig: {markDirty: false},
        initComponent: function () {
            Ext.apply(this, {
                store: Ext.create('Suncode.deactivateUsers.store.TasksGridStore'),
                columns: [{
                    xtype: 'treecolumn',
                    itemId: 'treecolumn',
                    text: PW.t('processes'),
                    flex: 1,
                    sortable: true,
                    dataIndex: 'name',
                    scope: this
                }, {
                    text: PW.t('required'),
                    width: 120,
                    sortable: true,
                    dataIndex: 'assigned',
                    renderer: function (value) {
                        if (value === false) {
                            return '<p style="text-align:center">' + PW.t('no') + '</p>';
                        } else if (value === true) {
                            return '<p style="color:red;text-align:center">' + PW.t('yes') + '</p>';
                        } else {
                            return value;
                        }
                    }
                }, {
                    text: PW.t('type'), width: 60, sortable: false, dataIndex: 'group', renderer: function (value) {
                        if (value === false) {
                            return '<p class="dvnt-icon-user" style="height:16px;text-align:center"></p>';
                        } else if (value === true) {
                            return '<p class="dvnt-icon-users" style="height:16px;text-align:center"></p>';
                        }

                        return value;
                    }
                }, {
                    text: PW.t('assignedto'), flex: 1, sortable: true, dataIndex: 'assignments'
                }]
            });

            this.callParent();
        }

    });
}(this.Ext4));