if (typeof window.isDeactivationPanelLoaded === 'undefined') {
    window.isDeactivationPanelLoaded = false;
}

window.isDeactivationEditMode = false;
window.userToDeactivate = null;

window.createDeactivationWindow = function (username, isEdit) {
    Ext4.Ajax.request({
        url: 'api/userdeactivation/emptyTaskUser',
        method: 'GET',
        params: {
            userToDeactivate: username
        },
        success: function (response) {
            if (response.status === 200) {
                var emptyTaskUsers = Ext.decode(response.responseText);

                Ext4.create('Suncode.deactivateUsers.view.WindowManager', {
                    id: 'deactivation',
                    userid: username,
                    editMode: isEdit,
                    emptyTaskUsers: emptyTaskUsers,
                    title: PW.t('window-manager-title') + ' <span class="dvnt-orange">' + username + '</span>'
                });

                var outerPane = document.getElementById('FreezePane');
                if (outerPane !== null)
                    outerPane.className = 'FreezePaneOff';
            }
        }
    });
}

window.initDeactivatePanel = function (username, isEdit) {
    window.userToDeactivate = username;
    window.isDeactivationEditMode = isEdit; //parametr mówiący, czy edytujemy przypisania dla zdezaktywowanego juz uzytkownika

    Suncode.requireExt(function () {
        (function (Ext) {
            Ext.destroy(Ext.get('app'));
            if (window.isDeactivationPanelLoaded === false) {
                Ext.application({
                    name: 'Suncode.deactivateUsers',
                    appFolder: 'scripts/DeactivateUsers',
                    requires: ['Suncode.deactivateUsers.api.MessageService'],
                    controllers: ['DeactivateUserController'],
                    id: 'app',
                    launch: function () {
                        createDeactivationWindow(username, isEdit);
                    }
                });

                window.isDeactivationPanelLoaded = true;
            } else {
                createDeactivationWindow(username, isEdit);
            }
        }(this.Ext4));
    }, this, false);
};