/**
 * Nadpisuje standardowe działanie Ext4.
 * 
 * Musi być ładowany po /resources/js/common/common.js
 */

jQuery.extend(Suncode, {
    
    applyExt4Overrides : function(){
    	if( window.Ext4) {
    		Suncode._overrideMessageBox();
    		Suncode._overrideWindow();
    		Suncode._overrideComboBox();
    		Suncode._overridePluginEditing();
        Suncode._overrideDoFormUpload();
        Suncode._overrideStandardSubmitAction();
    	}
	},

    _overrideMessageBox : function(){
    	 Ext4.override(Ext4.window.MessageBox, {
			shadow : false
		});
	},

    _overrideWindow : function(){
    	Ext4.override(Ext4.Window, {
			shadow : false
		});
    },
	
	/**
	* Zachowane działanie dot forceSelection jak w 4.2.1
	*/
     _overrideComboBox : function(){
    	 Ext4.override( Ext4.form.field.ComboBox, {
			onDataChanged : function() {
				var me = this;
				if (me.resizeComboToGrow()) {
					me.updateLayout();
				}
			},
			onLoad : function(store, records, success) {
				var me = this;
				if (me.ignoreSelection > 0) {
					--me.ignoreSelection;
				}
				// If not querying using the raw field value, we can set the value now we have data
				if (success && !store.lastOptions.rawQuery) {
					// Set the value on load
					// There's no value.
					if (me.value == null) {
						// Highlight the first item in the list if autoSelect: true
						if (me.store.getCount()) {
							me.doAutoSelect();
						} else {
							// assign whatever empty value we have to prevent change from firing
							me.setValue(me.value);
						}
					} else {
						me.setValue(me.value);
					}
				}
			}
		});
     },
     
     _overridePluginEditing: function() {
         // PWFL-4028, PLWZD-77, PWFL-4898
         Ext4.override( Ext4.grid.plugin.Editing, {
             startEdit: function(record, columnHeader, context) {
                 if (this.cmp.isDestroyed) {
                     return;
                 }
                 var me = this,
                     context,
                     layoutView = me.grid.lockable ? me.grid : me.view,
                     bufferedRenderer = me.grid.view.bufferedRenderer;

                 if (!layoutView.componentLayoutCounter) {
                     layoutView.on({
                         boxready: Ext4.Function.bind(me.startEdit, me, [
                             record,
                             columnHeader
                         ]),
                         single: true
                     });
                     return false;
                 }

                 if (me.grid.collapsed || !me.grid.view.isVisible(true)) {
                     return false;
                 }

                 if (bufferedRenderer) {

                     //PWFL-4898
                     bufferedRenderer.handleViewScroll();

                     // PWFL-4028
                     // Sprawdzenie czy wiersz komórki jest widoczny.
                     // Jeżeli nie, scrolluj do niego.
                     
                     var firstVisibleIndex = bufferedRenderer.getFirstVisibleRowIndex();
                     var lastVisibleIndex = bufferedRenderer.getLastVisibleRowIndex();
                     var recordIndex = bufferedRenderer.store.indexOf(record);

                     if(recordIndex < firstVisibleIndex || recordIndex > lastVisibleIndex) {
                         bufferedRenderer.scrollTo(record);
                     }
                 }

                 
                 context = me.getEditingContext(record, columnHeader);
                 if (context == null) {
                     return false;
                 }
                 if (!me.preventBeforeCheck) {
                     if (me.beforeEdit(context) === false || me.fireEvent('beforeedit', me, context) === false || context.cancel) {
                         return false;
                     }
                 }
                 return context;
             }
         });
     },

    _overrideDoFormUpload : function() {
      Ext4.override( Ext4.data.Connection, {
        upload: function(form, url, params, options) {
          form = Ext4.getDom(form);
          options = options || {};

          var id = Ext4.id(),
            frame = document.createElement('iframe'),
            hiddens = [],
            encoding = 'multipart/form-data',
            buf = {
              target: form.target,
              method: form.method,
              encoding: form.encoding,
              enctype: form.enctype,
              action: form.action
            },
            addField = function(name, value) {
              hiddenItem = document.createElement('input');
              Ext4.fly(hiddenItem).set({
                type: 'hidden',
                value: value,
                name: name
              });
              form.appendChild(hiddenItem);
              hiddens.push(hiddenItem);
            },
            hiddenItem, obj, value, name, vLen, v, hLen, h;

          /*
           * Originally this behaviour was modified for Opera 10 to apply the secure URL after
           * the frame had been added to the document. It seems this has since been corrected in
           * Opera so the behaviour has been reverted, the URL will be set before being added.
           */
          Ext4.fly(frame).set({
            id: id,
            name: id,
            cls: Ext4.baseCSSPrefix + 'hide-display',
            src: Ext4.SSL_SECURE_URL
          });

          document.body.appendChild(frame);

          // This is required so that IE doesn't pop the response up in a new window.
          if (document.frames) {
            document.frames[id].name = id;
          }

          Ext4.fly(form).set({
            target: id,
            method: 'POST',
            enctype: encoding,
            encoding: encoding,
            action: url || buf.action
          });

          // add dynamic params
          if (params) {
            obj = Ext4.Object.fromQueryString(params) || {};

            for (name in obj) {
              if (obj.hasOwnProperty(name)) {
                value = obj[name];
                if (Ext4.isArray(value)) {
                  vLen = value.length;
                  for (v = 0; v < vLen; v++) {
                    addField(name, value[v]);
                  }
                } else {
                  addField(name, value);
                }
              }
            }
          }

          // PWFL-11449
          if (!Suncode.isExternalUrl(url || buf.action)) {
            addField(Suncode.getCsrfParameterName(), Suncode.getCsrfToken());
          }

          Ext4.fly(frame).on('load', Ext4.Function.bind(this.onUploadComplete, this, [frame, options]), null, {single: !Ext4.isOpera});
          form.submit();

          Ext4.fly(form).set(buf);

          hLen = hiddens.length;

          for (h = 0; h < hLen; h++) {
            Ext4.removeNode(hiddens[h]);
          }
        },
      });
    },

  _overrideStandardSubmitAction: function() {
    Ext4.override( Ext4.form.action.StandardSubmit, {
      doSubmit: function() {
        var formInfo = this.buildForm();

        // PWFL-11449
        if (!Suncode.isExternalUrl(formInfo.action)) {
          Suncode.applyCsrfTokenToForm(formInfo.formEl);
        }

        formInfo.formEl.submit();
        this.cleanup(formInfo);
      }
    });
  }
});

        

