(function (Ext) {
  Ext.define('Favourites.model.FavouritesSet', {
    extend: 'Ext.data.Model',
    requires: ['Favourites.model.Favourite', 'Favourites.support.AssociationWriter'],

    fields: [
      { name: 'id', type: 'int', useNull: true },
      { name: 'name', type: 'string' },
      { name: 'description', type: 'string' },
      { name: 'favourites', type: 'auto', defaultValue: [] },
    ],

    hasMany: {
      model: 'Favourites.model.Favourite',
      name: 'favourites',
      foreignKey: 'set',
    },

    proxy: {
      type: 'rest',
      url: Favourites.contextPath('/rest/sets'),
      writer: {
        type: 'favourites-associations',
      },
    },

    copyFrom: function (sourceRecord) {
      var me = this,
        store = me.favourites();

      me.callParent(arguments);

      if (sourceRecord.favourites) {
        store.removeAll(true);
        store.loadRecords(sourceRecord.favourites().getRange());
      }
    },
  });
})(window.Ext4);
