// konflikt z prototype.js
$.noConflict();


PlusWorkflow = (function(window) {
	var contextPath, currentUser, databaseType;
	return {
		
		init : function(config) {
			contextPath = config.contextPath;
			currentUser = config.user;
			databaseType = config.databaseType;
		},
		
		getCurrentUser : function() {
			return currentUser;
		},
		
		getContextPath : function() {
			return contextPath;
		},
		
		getAbsolutePath : function(url) {
			if (url.indexOf('/') != 0) {
				url = '/' + url;
			}
			return this.getContextPath() + url;
		},

		getDatabaseType: function () {
			return databaseType;
		}
	};
})(window);

PW = window.PW || PlusWorkflow;

// Suncode - Singleton
Suncode = (function(window) {

	function csrfSafeMethod(method) {
		return (/^(GET|HEAD|OPTIONS)$/.test(method));
	}

	jQuery.ajaxSetup({
		cache : true,
		beforeSend: function(xhr, settings) {
			if (Suncode.isExternalUrl(settings.url)) {
				return;
			}

			if (!csrfSafeMethod(settings.type) && !this.crossDomain) {
				xhr.setRequestHeader(Suncode.getCsrfHeaderName(), Suncode.getCsrfToken());
			}
		}
	});

	var xhrOpenMethod = XMLHttpRequest.prototype.open;
	XMLHttpRequest.prototype.open = function(){
		var result = xhrOpenMethod.apply(this, arguments);

		this.__suncodeRecentUrl = arguments[1];
		if (Suncode.isExternalUrl(arguments[1])) {
			return result;
		}

		if (!csrfSafeMethod(arguments[0])) {
			this.setRequestHeader(Suncode.getCsrfHeaderName(), Suncode.getCsrfToken());
		}
		return result;
	};

	// zapobiegamy ustawianiu nagłówka z tokenem CSRF więcej niż raz,
	// gdyż metoda open(...) powinna to zrobić automatycznie tylko raz
	// inne wywołania setRequestHeader(...) (np. z Exta) mogłyby
	// zduplikować wartość nagłówka, co serwer by odrzucił
	var xhrSetRequestHeaderMethod = XMLHttpRequest.prototype.setRequestHeader;
	XMLHttpRequest.prototype.setRequestHeader = function(){
		if (Suncode.getCsrfHeaderName() !== arguments[0]) {
			xhrSetRequestHeaderMethod.apply(this, arguments);
			return;
		}

		if (Suncode.isExternalUrl(this.__suncodeRecentUrl)) {
			return;
		}

		if (!this.__suncodeHasCsrfToken) {
			xhrSetRequestHeaderMethod.apply(this, arguments);
			this.__suncodeHasCsrfToken = true
		}
	};

	var fetchMethod = window.fetch;
	window.fetch = function (urlOrRequest, options) {
		if (arguments.length === 0) {
			return fetchMethod.apply(this, arguments);
		}

		if (urlOrRequest instanceof Request) {
			if (!Suncode.isExternalUrl(urlOrRequest.url)) {
				urlOrRequest.headers.set(Suncode.getCsrfHeaderName(), Suncode.getCsrfToken());
			}
			return fetchMethod.apply(this, arguments);
		}

		if (Suncode.isExternalUrl(urlOrRequest)) {
			return fetchMethod.apply(this, arguments);
		}

		options = options || {};
		options.headers = options.headers || {};

		if (options.headers instanceof Headers) {
			options.headers.set(Suncode.getCsrfHeaderName(), Suncode.getCsrfToken());
			return fetchMethod.call(this, urlOrRequest, options);
		}
		else {
			options.headers[Suncode.getCsrfHeaderName()] = Suncode.getCsrfToken();
			return fetchMethod.call(this, urlOrRequest, options);
		}
	}

	var contextPath, currentUser, locale, contexts = {}, sessionTimeout, userPageSize;

	return {
	    
		init : function(config) {
			contextPath = config.contextPath;
			currentUser = config.user;
			locale = config.locale;
			sessionTimeout = config.sessionTimeout;
			userPageSize = config.userPageSize;
		},
		
		getCurrentUser : function() {
			if (currentUser == null)
				return null;
			return currentUser.userName;
		},

		isAnonymousUser : function () {
			return currentUser && currentUser.anonymous;
		},

		getUserLocale: function(){
			return locale;
		},

		getUserPageSize: function(){
			return userPageSize;
		},
		
		getSessionTimeout: function(){
		    return sessionTimeout;
		},
		
		getContextPath : function() {
			return contextPath;
		},
		
		getAbsolutePath : function(url) {
			if (url.indexOf('/') != 0) {
				url = '/' + url;
			}
			return this.getContextPath() + url;
		},

		getCsrfToken : function() {
			return document
				.querySelector("meta[name='csrf-token']")
				.getAttribute("content");
		},

		refreshCsrfToken: function(token) {
			document
				.querySelector("meta[name='csrf-token']")
				.setAttribute("content", token);
		},

		applyCsrfTokenToForm: function (formEl) {
			if (formEl.querySelector("input[name='" + Suncode.getCsrfParameterName() + "']")) {
				return;
			}

			var csrfField = document.createElement('input');
			csrfField.setAttribute('type', 'hidden');
			csrfField.setAttribute('name', Suncode.getCsrfParameterName());
			csrfField.setAttribute('value', Suncode.getCsrfToken());
			formEl.appendChild(csrfField);
		},

		getCsrfHeaderName : function() {
			return document
				.querySelector("meta[name='csrf-token-header']")
				.getAttribute("content");
		},

		getCsrfParameterName : function() {
			return document
				.querySelector("meta[name='csrf-token-parameter']")
				.getAttribute("content");
		},

		isExternalUrl: function(url) {
			if (!url) {
				return false;
			}

			try {
				var targetUrl = new URL(url, window.location.origin);
				return targetUrl.origin !== window.location.origin;
			}
			catch (e) {
				return false;
			}
		},

		redirectToLogInPageIfUserIsLoggedOut: function () {
			jQuery.ajax({
				url: Suncode.getAbsolutePath('/api/heartbeat?status=IDLE')
			}).fail(function (xhr) {
				if (xhr.status == 401) {
					location.href = Suncode.getAbsolutePath('/LoginManual.do');
				}
			});
		},

		loadScript: function(url) {
			jQuery.ajax({
				url: url,
				dataType: 'script',
				async: true
			});
		},

		/**
		 * Zleca załadowanie framework'a ExtJs4 oraz odpowiedniego języka. Ładowanie jest synchroniczne.
		 */
		requireExt : function(config) {
		    var me = this,
	            config = config || {},
		        callaback = Ext.emptyFn,
		        scope = window,
		        debug;
			 
		    if(Ext.isFunction(config)){
		        callback = config;
		        if(Ext.isDefined(arguments[1])){
		        	scope = arguments[1]
		        }
		        if(Ext.isDefined(arguments[2])){
		        	debug = arguments[2]
		        }
		    }
		    else {
		    	callback = config.fn || Ext.emptyFn;
		    	scope = config.scope || scope;
		    	debug = config.debug || debug;
		    }

			// załadowany
			if (window.Ext4) {
				me.applyOverrides();
				me.setupExt4();
				callback.call(scope, Ext4);
				return;
			}

			// załaduj Ext'a
			jQuery.ajax({
				url: me.getAbsolutePath("/resources/lib/extjs-4/ext-all-sandbox" + (debug ? "-debug" : "") + ".js"),
				dataType: "script",
				cache: true,
				async: false,
				success: function() {
					me.applyOverrides();
					me.setupExt4();

					// załaduj locale
					me.requireLang();
					callback.call(scope, Ext4);
				}
			});
		},

		setupExt3 : function() {
			Ext.Ajax.on("beforerequest", this._onBeforeAjaxRequest );
			Ext.Ajax.on("requestcomplete", this._onAjaxRequestComplete );
		},

		setupExt4 : function() {
			if (!window.Ext4) {
				return;
			}

			Ext4.Ajax.on("beforerequest", this._onBeforeAjaxRequest );
			Ext4.Ajax.on("requestcomplete", this._onAjaxRequestComplete );
		},

		_onBeforeAjaxRequest : function (conn, options) {
			if (Suncode.isExternalUrl(options.url)) {
				return;
			}

			conn.headers = conn.headers || {};
			conn.headers[Suncode.getCsrfHeaderName()] = Suncode.getCsrfToken();
		},

		_onAjaxRequestComplete : function (conn, response, options) {
			if (!response.getResponseHeader) {
				return;
			}

			var csrfToken = response.getResponseHeader(Suncode.getCsrfHeaderName());
			if (csrfToken) {
				Suncode.refreshCsrfToken(csrfToken);
			}
		},
		
		applyOverrides: function() {
			// definicja jest umieszczona w /resources/lib/extjs-4/override.js
			Suncode.applyExt4Overrides();
		},
		
		/**
		 * Zleca załadowanie odpowiedniego języka dla ExtJs4. Ładowanie jest synchroniczne.
		 */
		requireLang : function() {
			// załaduj locale
			jQuery.ajax({
				url : this.getAbsolutePath('/resources/lib/extjs-4/locale/ext-lang-' + this.getUserLocale() + '-sandbox.js'),
				dataType : 'script',
				cache : true,
				async : false
			});
		},
		
		context: function(name){
			if(!contexts[name]){
				contexts[name] = {};
			}
			return contexts[name];
		}
	};
})(window);

/**
 * Włącza mechanizm automatycznego wylogowywania użytkownika po dłuższym czasie nieaktywności.
 * 
 * Co 5 minut (lub sessionTimeout/4) wysyłany jest do serwera '/api/heartbeat' informacja,
 * czy użytkownik jest aktywczny 'ACTIVE' czy nie 'IDLE'.
 * 
 * Serwer odpowiada statusem 401, nie jest już zalogowany. 
 */
Suncode.initAutoLogout = function(){
    
    var sessionTimeout = Suncode.getSessionTimeout();
    if(sessionTimeout <= 0){
        return;
    }
    
    var $ = jQuery,
        sessionTimeout = sessionTimeout * 1000,
        idleTimeout = Math.min(5 * 60 * 1000, sessionTimeout/4);


    function heartbeat(status){
        $.ajax({
            url: Suncode.getAbsolutePath('/api/heartbeat?status=' + status)
        }).fail(function(xhr){
            if(xhr.status == 0 || xhr.status == 401){
            	if (xhr.getResponseHeader("location") != null)
            	{
            		location.href = xhr.getResponseHeader("location");
            	}
            	else
        		{
            		location.href = Suncode.getAbsolutePath('/');
        		}
            }
        });
    };
    
    setInterval(function(){
        var idle = $( document ).idleTimer("isIdle");
        heartbeat(idle ? 'IDLE' : 'ACTIVE');
    }, idleTimeout );
    
    $.idleTimer(idleTimeout);
};