<%@ page import="com.suncode.pwfl.SystemVersion" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<div class="password-recovery-card">
	<div class="logo-text-container">
		<div id="login-logo">
			<img src="${pageContext.request.contextPath}/resources/images/plusworkflow_color_full.png"/>
		</div>
		<div class="system-version">
			<%=SystemVersion.getVersionIdentifier() %>
		</div>
	</div>
	<div id="message" class="message-box info">
		<bean:message key="Formularz_resetowania_hasla"/>
	</div>
	<div id="login-form">
		<div class="gl-grid-middle"
			 id="passwordRecoveryForm">
			<div class="gl-col-4">
				<label class="dvnt-table-black dvnt-body1">
					<bean:message key="Login"/>
				</label>
			</div>
			<div class="gl-col-8">
				<div class="dvnt-input-text-wrapper">
					<input v-model="username"
						   @keyup.enter="tryRequestPasswordRecovery"
						   type="text"
						   autocomplete="off">
				</div>
			</div>
			<div class="gl-col-4">
				<label class="dvnt-table-black dvnt-body1">
					<bean:message key="Email"/>
				</label>
			</div>
			<div class="gl-col-8">
				<div class="dvnt-input-text-wrapper">
					<input v-model="email"
						   @keyup.enter="tryRequestPasswordRecovery"
						   type="text"
						   autocomplete="off">
				</div>
			</div>
			<div class="gl-col-6"></div>
			<div class="gl-col-6">
				<input @click="tryRequestPasswordRecovery"
					   class="dvnt-button-primary"
					   :disabled="sent"
					   type="button"
					   value="<bean:message key="Resetuj_haslo"/>"/>
			</div>
		</div>
	</div>
</div>

<script src="${pageContext.request.contextPath}/resources/lib/vue.min.js"></script>

<script>
	new Vue({
		el: '#passwordRecoveryForm',
		data: {
			username: '',
			email: '',
			sent: false
		},
		methods: {
			tryRequestPasswordRecovery: function() {
				var me = this;
				this.validate({
					onSuccess: function() {
						me.requestPasswordRecovery();
					},
					onError: function(error) {
						PW.ui.Message.error(error);
					}
				})
			},

			validate: function(callback) {
				var resolve = callback.onSuccess;
				var reject = callback.onError;

				this.username = this.username.trim();
				this.email = this.email.trim();

				if(!this.username) {
					reject(PW.t('Uzytkownik_nie_moze_byc_pusty'));
					return;
				}

				if(!this.email) {
					reject(PW.t('Email_nie_moze_byc_pusty'));
					return;
				}

				if(!this.validateEmail(this.email)) {
					reject(PW.t('Email_ma_nieprawidlowy_format'));
					return;
				}

				resolve();
			},

			validateEmail: function(email) {
				var regex = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
				return regex.test(email);
			},

			requestPasswordRecovery: function() {
				var me = this;
				var loginMask = new Ext.LoadMask(Ext.getBody());
				loginMask.show();

				jQuery.ajax({
					url: 'api/password/recovery/request',
					method: 'POST',
					data: {
						username: this.username,
						email: this.email
					},
					complete: function() {
						loginMask.hide();
						loginMask.destroy();
					},
					success: function(data) {
						me.sent = true;

						PW.ui.Message.success(PW.t('Kod_zostal_wyslany'));
						setTimeout(function() {
							window.location.href = Suncode.getContextPath() + '/ChangePassword.do?recovery=true';
						}, 1500);
					},
					error: function(response) {
						var error = PW.t('Wystapil_blad_przy_wysylaniu_maila_resetowania_hasla');
						if(response.responseJSON) {
							var data = response.responseJSON;
							if(data.passwordRecoveryUnavailable) {
								error = PW.t('Funkcja_przywracania_hasla_nie_jest_dostepna');
							}
							else if(data.userNotFound) {
								error = PW.t('Nie_znaleziono_uzytkownika');
							}
							else if(data.notDefinedEmail) {
								error = PW.t('Uzytkownik_nie_ma_okreslonego_adresu_email')
							}
							else if(data.incorrectEmail) {
								error = PW.t('Email_nie_jest_prawidlowy_dla_tego_uzytkownika');
							}
						}

						PW.ui.Message.error(error);
					}
				});
			}
		}
	});
</script>
