(function ($) {

	function prepareAddDocumentButtons() {
		$('.documents-attach').on("click",
			function (item) {
				var processInfo = getProcessInfo(item);
				showAddDocumentModal(processInfo.processId,
					processInfo.activityId);
			});
	}

	function getProcessInfo(item) {
		var target = $(item.currentTarget);
		return target.data('attach');
	}

	function showAddDocumentModal(processId, activityId) {
		var currentUrl = encodeURIComponent(window.location.pathname
			+ window.location.search);
		var modalConfig = {
				width: 800
		}

		PW.ui.ModalWindow.show(PW.t('Dodawanie_dokumentu'),
			'AddingDocumentFromDisk.do?processId=' + processId
			+ '&activityId=' + activityId + '&redirect='
			+ currentUrl + '&searchProcessesSource=true', modalConfig);
	}

	$(function () {
		prepareAddDocumentButtons();
	});

})(jQuery);