Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

Ext.ux.plusmpm.scheduledtasks.FileField = function (config) {
  var paramData = config.paramData;

  var fileFieldConfig = {
    xtype: 'fileuploadfield',
    buttonText: PW.t('Przegladaj'),
    ref: 'fileField',
    flex: 1,
    margins: '0 2 0 0',
  };
  Ext.apply(fileFieldConfig, paramData.fieldInfo);

  var fileId = paramData.valueInfo.value;
  if (fileId) {
    Ext.apply(fileFieldConfig, {
      value: fileId,
      fileId: fileId,
    });
  }

  var valueMetadata = paramData.valueInfo.valueMetadata;

  if (valueMetadata) {
    var fileName = valueMetadata.fileName;
    Ext.apply(fileFieldConfig, {
      value: fileName,
    });
  }

  var items = [fileFieldConfig];

  if (!Ext.isEmpty(fileId)) {
    items.push({
      xtype: 'button',
      itemId: 'preview-button',
      iconCls: 'dvnt-icon-file',
      ref: 'previewButton',
      width: 42,
      height: 42,
      scale: 'medium',
      handler: function (button) {
        window.location.href = 'api/customfiles?id=' + fileId;
      },
    });
  }

  Ext.apply(config, {
    layout: 'hbox',
    items: items,
  });

  Ext.ux.plusmpm.scheduledtasks.FileField.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.FileField, Ext.Container, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.FileField.superclass.initComponent.call(this);
    this.fileField.on('fileselected', this.onFileSelected, this);
    this.on('enable', this.onEnable, this);
    this.on('disable', this.onDisable, this);
  },

  onFileSelected: function () {
    if (this.items.items.length > 1) {
      this.remove(this.previewButton);
      this.doLayout();
    }
  },

  getValue: function () {
    return this.fileField.getValue();
  },

  setValue: function (value) {
    this.fileField.setValue(value);
    if (this.items.items.length > 1) {
      this.remove(this.previewButton);
      this.doLayout();
    }
  },

  setReadOnly: function (readOnly) {
    if (readOnly) {
      this.fileField.fileInput.hide();
      this.fileField.button.disable();
    } else {
      this.fileField.fileInput.show();
      this.fileField.button.enable();
    }
  },

  setRequired: function (isRequired) {
    this.fileField.allowBlank = !isRequired;
  },

  onEnable: function () {
    this.items.each(function (item) {
      item.enable();
    });
  },

  onDisable: function () {
    this.items.each(function (item) {
      item.disable();
    });
  },
});

Ext.reg('st_filefield', Ext.ux.plusmpm.scheduledtasks.FileField);
