Ext.namespace('Ext.ux.plusmpm');

/**
 * Dodatkowe parametry konfiguracyjne:
 * 
 * config.processId : String
 * config.activityId : String 
 * */
Ext.ux.plusmpm.StatusesHistoryWindow = function(config) {

	var proxy = new Ext.data.HttpProxy({
	    url : 'com.plusmpm.servlet.GetActivityStatusesHistoryServlet.customServlet'
	});
	
	var store = new Ext.data.JsonStore({
	    proxy         : proxy,
	    root          : 'records',
	    autoDestroy   : true,
	    baseParams    : {processId:config.processId, activityId:config.activityId},
	    fields        : [
	        {name:'id', type:'int'},
	        {name:'processId', type:'string'},
	        {name:'activityId', type:'string'},
	        {name:'authorUserName', type:'string'},
	        {name:'acceptanceTime', type:'int'},
	        {name:'createDate', type:'date', dateFormat:'time'},
	        {name:'message', type:'string'},
	        {name:'newest', type:'boolean'},
	        {name:'type', type:'string'}
	    ],
	    idProperty    : 'id',
        sortInfo      : {field:'createDate', direction: 'DESC'}
	});
	
	store.load();
	
	var view = new Ext.grid.GridView({
		scrollOffset : 20
	});
	
	var grid = new Ext.grid.GridPanel({        
        store            : store,
        view             : view,
        loadMask         : true,
        columnLines      : true,
        autoScroll       : true,
        border           : false,
        autoExpandColumn : 'theAutoExpandColumnId',
        columns          : [
            {
                header: this.typeColumnHeader,
                sortable: true,
                resizable: true,
                dataIndex: 'type',
                width: 60,
                renderer: function(oValue, oMetadata, rRecord, nRowIndex, nColIndex, oStore){
            		if(oValue == 'SUCCESSFUL')
            		{
            			return "<img src=\"style/img/fam/tick.png\"/>";
            		}
            		else if(oValue == 'FAILED')
            		{
            			return "<img src=\"style/img/fam/cross.png\"/>";
            		}
            		else
            		{
            			return "<img src=\"style/img/fam/hourglass.png\"/>";
            		}
				}
            },
            {
            	xtype:'datecolumn',
        	    header: this.acceptanceDateColumnHeader,
        	    sortable: true,
        	    resizable: true,
        	    format: 'Y-m-d H:i:s',
        	    dataIndex: 'createDate',        	    
        	    width: 150
            },
            {
            	xtype:'numbercolumn',
                header: this.acceptanceTimeColumnHeader,
                sortable: true,
                resizable: true,
                format:'0',
                dataIndex: 'acceptanceTime',
                width: 150
            },
            {
            	id: 'theAutoExpandColumnId',
                header: this.messageColumnHeader,
                sortable: true,
                resizable: true,
                dataIndex: 'message',
                renderer: function(oValue, oMetadata, rRecord, nRowIndex, nColIndex, oStore){
					oMetadata.attr = "style=\"white-space:normal;\"";
					return oValue;
				}
            }]
	});
		
    config = Ext.apply({
    	title           : this.windowTitlePart1 + ': [' + config.activityId + '] ' + this.windowTitlePart2 + ': [' + config.processId + ']',
        width           : 1000,
        height          : 400,
        modal           : true,
        constrain       : true,
        layout          : 'fit',
        items           : grid,
        frame           : false
    }, config);
    
	Ext.ux.plusmpm.StatusesHistoryWindow.superclass.constructor.call(this, config);
}; // end of Ext.ux.plusmpm.StatusesHistoryWindow constructor

Ext.extend(Ext.ux.plusmpm.StatusesHistoryWindow, Ext.Window, {
	
	typeColumnHeader : PW.t('typeColumnHeader'),
	
	acceptanceDateColumnHeader : PW.t('acceptanceDateColumnHeader'),
	
	acceptanceTimeColumnHeader : PW.t('acceptanceTimeColumnHeader'),
	
	messageColumnHeader : PW.t('messageColumnHeader'),
	
	windowTitlePart1 : PW.t('windowTitlePart1'),
	
	windowTitlePart2 : PW.t('windowTitlePart2'),
	
	initComponent: function() {
		Ext.ux.plusmpm.StatusesHistoryWindow.superclass.initComponent.call(this);
	}
}); // end of Ext.extend

function showStatusHistoryWindow(processId, activityId)
{
	var window = new Ext.ux.plusmpm.StatusesHistoryWindow({
		processId  : processId,
		activityId : activityId
	});

	window.show();
}
