(function (Ext) {
  Ext.define('Suncode.dashboard.administration.view.StatusForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.status-form',
    layout: 'form',

    fieldDefaults: {
      msgTarget: 'under',
      labelWidth: 100,
    },

    loadingIconCls: Ext.baseCSSPrefix + 'mask-msg-text',
    successIconCls: 'dvnt-icon-check-circle dvnt-green-icon form-status',
    failureIconCls: 'dvnt-icon-x-symbol dvnt-red-icon form-status',

    currentIconCls: undefined,
    statusComponent: undefined,
    currentTimeoutId: undefined,

    setStatusLoading: function (text) {
      this.setStatus(text, this.loadingIconCls);
    },

    setStatusSuccess: function (text, clear) {
      this.setStatus(text, this.successIconCls, clear);
    },

    setStatusFailure: function (text, clear) {
      this.setStatus(text, this.failureIconCls, clear);
    },

    setStatus: function (text, icon, clear) {
      var me = this;

      if (!me.statusComponent) {
        me.statusComponent = this.down('toolbar tbtext');
        me.setStatus(text, icon);
        return;
      }

      Ext.suspendLayouts();

      // zmiana teksu
      me.statusComponent.setText(text);

      // zmiana ikony
      if (me.currentIconCls) {
        me.statusComponent.removeCls(me.currentIconCls);
        me.currentIconCls = null;
      }
      if (icon) {
        me.currentIconCls = icon;
        me.statusComponent.addCls(icon);
      }

      if (me.currentTimeoutId) {
        // jeżeli jest jakaś akcja -> kończe ją
        clearTimeout(me.currentTimeoutId);
      }

      if (clear) {
        me.currentTimeoutId = Ext.defer(me.clearStatus, 10000, me);
      }

      Ext.resumeLayouts(true);
    },

    clearStatus: function () {
      this.setStatus('');
    },

    clearForm: function () {
      this.getForm().reset();
      this.clearStatus();
    },
  });
})(Ext4);
