(function (Ext) {
    Ext.define('Suncode.deactivateUsers.view.OthersSection', {
        extend: 'Ext.form.FieldSet',
        alias: 'widget.others-section',
        id: 'others-section',

        title: PW.t('others-fieldset'),
        cls: 'fieldset',
        itemId: 'others-section',
        collapsible: true,

        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        defaultType: 'container',

        initComponent: function () {

            Ext.apply(this, {
                items: [{
                    layout: 'column',
                    defaults: {
                        margin: '10 10 10 10'
                    }, items: [{
                        columnWidth: 1,
                        layout: {
                            type: 'vbox',
                            align: 'left'
                        }, border: false,
                        items: [{
                            xtype: 'userscombo',
                            store: new Suncode.deactivateUsers.store.UsersStore(),
                            itemId: 'defaultUser',
                            fieldLabel: PW.t('default-user'),
                            width: 400,
                            labelWidth: 150,
                            margin: 0,
                            allowBlank: true
                        }]
                    }]
                },{
                    xtype: 'fieldset',
                    cls: 'fieldset',
                    collapsible: false,
                    title: PW.t('details'),
                    layout: 'column',
                    defaults: {
                        margin: 10
                    },
                    margin: '10 10 20 10',
                    items: [{
                        columnWidth: 0.5,
                        border: false,
                        items: [{
                            id: 'otherSectionColumn-0',
                            xtype: 'container',
                            layout: {
                                type: 'vbox',
                                align: 'stretch'
                            }, items: [{
                                xtype: 'userscombo',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'delegations',
                                fieldLabel: PW.t('delegations'),
                                margin: '0 0 20 0'
                            }, {
                                xtype: 'userscombo',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'views',
                                fieldLabel: PW.t('views'),
                                margin: '0 0 20 0'
                            }, {
                                xtype: 'userscombo',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'favouriteSets',
                                fieldLabel: PW.t('settings.sets'),
                                margin: '0 0 20 0'
                            }]
                        }]
                    }, {
                        columnWidth: 0.5,
                        border: false,
                        items: [{
                            id: 'otherSectionColumn-1',
                            xtype: 'container',
                            layout: {
                                type: 'vbox',
                                align: 'stretch'
                            }, items: [{
                                xtype: 'userscombo',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'reports',
                                fieldLabel: PW.t('reports'),
                                margin: '0 0 20 0'
                            }, {
                                xtype: 'userscombo',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'notifications',
                                fieldLabel: PW.t('notifications'),
                                margin: '0 0 20 0'
                            },
                            {
                                xtype: 'userscombo',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'otherActivities',
                                fieldLabel: PW.t('otherActivities'),
                                margin: '0 0 20 0'
                            }]
                        }]
                    }]
                }]
            });

            this.callParent();
        },

        initExtraTransfers: function (extraTransfers) {
            this.extraTransfers = extraTransfers;

            var columnsCount = 2;
            for (var i = 0; i < columnsCount; i++) {
                var components = [];
                this._forEvery(extraTransfers, columnsCount, i, function (extraTransfer) {
                    components.push({
                        id: 'extraTransferField-' + extraTransfer.id,
                        xtype: 'userscombo',
                        store: new Suncode.deactivateUsers.store.UsersStore(),
                        fieldLabel: extraTransfer.text,
                        margin: '0 0 20 0',
                        listeners: {
                            select: function (combo) {
                                extraTransfer.value = combo.getValue();
                            }
                        }
                    })
                })

                Ext.getCmp('otherSectionColumn-' + i).add(components);
            }
        },

        _forEvery: function (array, count, offset, handler) {
            var i = offset;
            while (i < array.length) {
                handler(array[i]);
                i += count;
            }
        },

        getExtraTransfers: function () {
            return this.extraTransfers
        },

        getExtraTransfersDto: function () {
            return this.extraTransfers.map(function (extraTransfer) {
                var extraTransfer = extraTransfer;

                return {
                    id: extraTransfer.id,
                    value: extraTransfer.value
                };
            })
        },

        getExtraTransferCombo: function (id) {
            return Ext.getCmp('extraTransferField-' + id);
        }
    });
}(this.Ext4));