(function (Ext) {
  Ext.define('Favourites.settings.view.FavouriteBaseWindow', {
    extend: 'Ext.window.Window',
    requires: ['Favourites.model.Favourite'],

    layout: {
      type: 'hbox',
      align: 'stretch',
    },
    closeAction: 'hide',

    bindFavouriteBase: function (favourite, parameter) {
      this.nameField.originalValue = favourite.data.name;
      this.form.loadRecord(favourite);

      let parameterField = this.form.query('#parameter')[0];
      if (parameter && parameter.renderable) {
        this.buildParameterLabel(parameter, parameterField);
        parameterField.allowBlank = !parameter.required;
        this.form.getForm().isValid();
        parameterField.show();
      } else {
        parameterField.allowBlank = true;
        this.form.getForm().isValid();
        parameterField.hide();
      }
    },

    buildParameterLabel: function (parameter, parameterField) {
      let id = Ext.id();
      let tooltipIcon = `<div class="form-field-description-img" id="${id}"/>`;
      let label = parameter.name;
      if (parameter.description) {
        label += tooltipIcon;
      }
      parameterField.setFieldLabel(label);

      if (parameter.description) {
        Ext4.create('Ext4.tip.ToolTip', {
          target: Ext4.getElementById(id),
          html: parameter.description,
          dismissDelay: 0,
        });
      }
    },

    handleCustomNameCheckboxChange: function (checkbox, newValue) {
      let displayNameMode = checkbox.nextSibling();

      if (newValue) {
        checkbox.previousSibling().enable();
        displayNameMode.setValue('CUSTOM');
      } else {
        let nameFiled = checkbox.previousSibling();
        nameFiled.setValue(nameFiled.originalValue);
        nameFiled.disable();
        displayNameMode.setValue('SYSTEM');
      }
    }
  });
})(window.Ext4);
