<%@page import="org.springframework.context.i18n.LocaleContextHolder" %>
<%@page import="org.apache.commons.lang3.StringUtils" %>
<%@page import="org.apache.commons.lang3.StringEscapeUtils" %>
<%@page import="com.suncode.pwfl.administration.user.UserContext" %>
<%@ page import="com.suncode.pwfl.util.SpringContext" %>
<%@ page import="com.suncode.pwfl.administration.user.UserSettingsService" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>

<%@ taglib uri="suncode-tiles" prefix="tiles" %>

<%@ taglib uri="/tags/c" prefix="c" %>
<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html>
<head>
    <meta http-equiv="pragma" content="no-cache"/>
    <meta http-equiv="cache-control" content="no-cache"/>
    <meta http-equiv="expires" content="0"/>
    <meta http-equiv="X-UA-Compatible" content="IE=Edge"/>
    <meta name="csrf-token" content="${_csrf.token}"/>
    <meta name="csrf-token-header" content="${_csrf.headerName}"/>
    <meta name="csrf-token-parameter" content="${_csrf.parameterName}"/>

    <title><bean:message key="System_zarzadzania_procesami_biznesowymi"/></title>

    <link rel="icon" href="${pageContext.request.contextPath}/resources/images/plusworkflow_logo.png" type="image/x-icon"/>
    <link rel="shortcut icon" href="${pageContext.request.contextPath}/resources/images/plusworkflow_logo.png"/>

    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/style/style.css"/>
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/style/site.css"/>

    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/lib/jquery.min.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/lib/jquery-plugins/selectize/js/selectize.min.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/common.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/common-ui.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/selectize.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/Logger.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/ServerLogger.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/common/I18N.js"></script>

    <script type="text/javascript" src="${pageContext.request.contextPath}/resources/js/dist/shared.js"></script>

    <script type="text/javascript">
        var userObject;
        <% if(UserContext.isActive()){%>
        userObject = JSON.parse("<%=StringEscapeUtils.escapeEcmaScript( UserContext.current().getUserJson() )%>");
        <%}%>

        PlusWorkflow.init({
            contextPath: '${pageContext.request.contextPath}',
            user: userObject
        });

        Suncode.init({
            contextPath: '${pageContext.request.contextPath}',
            user: userObject,
            locale: '<%=LocaleContextHolder.getLocale().getLanguage()%>'
        });
    </script>

    <%
        String user = (String) session.getAttribute( "username" );
        String skinPath = "";
        if ( StringUtils.isNotEmpty( user ) )
        {
            skinPath = SpringContext.getBean( UserSettingsService.class ).getSkinPathForUser( user );
        }
    %>

    <jsp:include page="/pages/util/extjs_header_base.jsp"></jsp:include>

    <script type="text/javascript">
        let finalSkinPath = "<%=skinPath%>";

        if (!finalSkinPath) {
            finalSkinPath = localStorage.getItem('skinPath') || 'pwfl_blue.css';
        }

        document.write("<link rel='stylesheet' type='text/css' href='${pageContext.request.contextPath}/resources/css/" + finalSkinPath + "'/>");
    </script>

    <link rel="stylesheet" href="${pageContext.request.contextPath}/resources/lib/fontawesome/css/fontawesome-all.min.css">
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/resources/lib/jquery-plugins/selectize/css/selectize.min.css"/>
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/resources/lib/gridlex/gridlex.min.css"/>
</head>

<body id="loginPage">
<div class="login-gradient">
    <div id="loginBody"><tiles:insert name="body"/></div>
    <div id="loginFooter"><tiles:insert name="footer"/></div>
</div>
</body>
</html>

