Ext4.define('Suncode.passwordpolicy.view.ProfilesList', {
	extend: 'Ext.grid.Panel',

	alias: 'widget.passwordpolicy-profileslist',

	title: PW.t('Zdefiniowane_profile'),

	emptyText: 'Brak zdefiniowanych profili',

	viewConfig: {
		plugins: {
			ptype: 'gridviewdragdrop',
		}
	},

	initComponent: function () {
		var me = this;
		Ext4.apply(me, {
			columns: [{
				xtype: 'rownumberer',
				sortable: false
			}, {
				text: PW.t('Nazwa_profilu'),
				dataIndex: 'name',
				flex: 1,
				sortable: false
			}],

			tools: [{
				type: 'help',
				tooltip: PW.t('Kolejnosc_na_liscie'),
				width: '20px',
				height: '20px'
			}, {
				type: 'refresh',
				tooltip: PW.t('odswiez'),
				handler: me.refreshList,
				scope: this,
				width: '20px',
				height: '20px'
			}],

			dockedItems: [{
				id: 'buttonBar',
				xtype: 'toolbar',
				dock: 'bottom',
				layout: {
					type: 'vbox',
					align: 'stretch',
					pack: 'center'
				},
				items: [{
					xtype: 'panel',
					border: false,
					layout: 'fit',
					margin: '0 0 5px 0',
					items: {
						id: 'savePrioritiesButton',
						disabled: true,
						xtype: 'button',
						flex: 1,
						text: PW.t('Zapisz_priorytety'),
						tooltip: PW.t('Kolejnosc_na_liscie'),
						iconCls: 'dvnt-icon-save',
						handler: me.savePriorities,
						scope: this
					}
				}, {
					xtype: 'panel',
					border: false,
					layout: 'hbox',
					items: [{
						xtype: 'button',
						text: PW.t('Dodaj_profil'),
						iconCls: 'dvnt-icon-plus-circle',
						flex: 1,
						handler: me.addProfile,
						scope: this
					}, {
						id: 'deleteProfileButton',
						disabled: true,
						xtype: 'button',
						text: PW.t('Usun_profil'),
						iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
						flex: 1,
						handler: me.deleteProfile,
						scope: this
					}]
				}]
			}],

			listeners: {
				beforedrop: function (node, data, overModel, dropPosition, dropHandlers) {
					var reject = false;
					data.records.forEach(function (profile) {
						if (profile.get('defaultProfile')) {
							reject = true;
						}
					});

					if (!reject) {
						if (overModel.get('defaultProfile')) {
							reject = true;
						}
					}

					if (reject) {
						dropHandlers.cancelDrop();
					}
					else {
						dropHandlers.processDrop();
					}
				},
				drop: function () {
					me.getView().refresh();
					me.updateSavePrioritiesButton();
				},
				selectionchange: function (selectionModel) {
					var selectedItems = selectionModel.selected.items;
					if (selectedItems.length > 0) {
						var selectedProfile = selectedItems[0];
						Ext4.getCmp('deleteProfileButton').setDisabled(selectedProfile.get('defaultProfile'));
					}
					else {
						Ext4.getCmp('deleteProfileButton').setDisabled(true);
					}

					me.fireEvent('selectedprofilechanged', selectedItems);
				}
			}
		});
		this.callParent(arguments);

		me.getStore().on('load', function () {
			me.getSelectionModel().deselectAll();
			me.defaultProfilesOrder = me.getProfilesOrder();
			me.updateSavePrioritiesButton();
		});
	},

	refreshList: function () {
		this.store.load();
	},

	addProfile: function () {
		this.fireEvent('addprofile');
	},

	deleteProfile: function () {
		this.fireEvent('deleteprofile');
	},

	getProfilesOrder: function () {
		var profilesOrder = [];
		this.store.each(function (record) {
			profilesOrder.push({
				id: record.get('id'),
				defaultProfile: record.get('defaultProfile')
			});
		});

		return profilesOrder;
	},

	savePriorities: function () {
		this.fireEvent('savePriorities', this.getProfilesOrder());
	},

	updateSavePrioritiesButton: function () {
		var edited = false;
		var profilesStore = this.getStore();
		for (var i = 0; i < this.defaultProfilesOrder.length; i++) {
			if (profilesStore.getAt(i).get('id') != this.defaultProfilesOrder[i].id) {
				edited = true;
				break;
			}
		}

		Ext4.getCmp('savePrioritiesButton').setDisabled(!edited);
	}
});
