
    Ext4.define( 'Suncode.license.view.LicenseInfo', {
        extend: 'Ext4.container.Container',
        
        height: 850,
		autoScroll: true,
        margin: '10px 0',
        layout: 'border',
        style: {
			background: 0
		},

        initComponent: function() {
            this.items = [{
                xtype: 'panel',
                region: 'west',
                layout: {
				    type: 'vbox',
				    align : 'stretch'
				},
				frame: true,
				width: 560,
				minWidth: 560,
                title: PW.t('management'),
                collapsible: true,
                split: true,
                bodyStyle: {
					padding: '5px',
					border: '0'
				},
				defaults : {
					bodyPadding: 10,
					collapsible : true,
					titleCollapse: true,
					animCollapse : false
				},
                items: [{
                	xtype: 'upload'
                	,cls : 'licenseupload-panel-clear'
                },
                {
                	id:"submitTrialLicenseButton",
                	xtype: 'button',
                	height: 30,
                	disabled: true,
                	text: PW.t('loading'),
                	listeners: {
                		scope: this,
                		afterrender: this.checkTrialLicense
                	}
                }]
            },{
                region: 'center',
                xtype: 'panel',
                title: PW.t('licenseInfo'),
                titleAlign: 'center',
                layout: 'fit',
				frame: true,
				bodyStyle: {
					border: '0'
				},
                items:[{
                	xtype: 'restrictions'
                }]
            }];
            
            this.callParent();
        },

        checkTrialLicense: function(button) {
        	var me = this;

        	jQuery.ajax({
        		url: 'api/trial/get',
        		success: function(license) {
        			if(license.valid) {
        				button.setText(PW.t('trialLicenseActive'));
        			}
        			else if(license.empty) {
        				me.activateStartTrialButton(button);
        			}
        			else {
        				if (license.disabled || !license.datesValid){
        					button.setText(PW.t('trialLicenseDisabled'));
        				}
        				else if(license.expired) {
        					button.setText(PW.t('trialLicenseExpired'));
        				}
        			}
        		},
        		error: function() {
        			button.setText(PW.t('cannotLoadTrialInfo'));
        		}
        	})
    	},

    	activateStartTrialButton: function(button) {
    		var me = this;

    		button.setDisabled(false);
			button.setText(PW.t('startNewTrialText'));
			button.setIconCls('dvnt-icon-upload');

			button.on('click', function() {
				Ext.Msg.show({
	    			title: PW.t('warningText'),
	    			msg: PW.t('startTrialMessage'),
	    			buttons: {
	                    yes: PW.t('yes'),
	                    no: PW.t('no')
	                },
	                fn: function( buttonId ) {
	                    switch ( buttonId ) {
	                        case 'yes':
	                        	jQuery.ajax({
	                        		url: 'api/trial/start',
	                        		method: 'POST',
	                        		success: function(data) {
	                        			if(data.success) {
	                        				me.showLoadingTrialSuccess();
	                        			}
	                        			else {
	                        				PW.ui.Message.error(PW.t('cannotStartTrial'));
	                        			}
	                        		},
	                        		error: function() {
	                        			PW.ui.Message.error(PW.t('trialErrorOccured'));
	                        		}
	                        	});
	                            break;
	                        default:
	                            break;
	                    }
	                },
	                icon: Ext.Msg.QUESTION
	    		});
			});
    	},

    	showLoadingTrialSuccess: function() {
            Ext4.Msg.show( {
                title: PW.t('successText'),
                msg: PW.t('successMsg'),
                buttons: Ext4.Msg.OK,
                icon: Ext4.MessageBox.INFO,
                width: 450,
                fn: function() {
                    window.location = 'Logout.do';
                }
            });
    	}
    });