Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

/**
 * Pojedyncza zakładka z zadaniami - kategoria
 *
 * config.categoryName: wyświetlana nazwa kategorii
 * config.categoryId: id kategorii (jeżeli brak - bez kategorii)
 *
 */
Ext.ux.plusmpm.scheduledtasks.TaskTab = function (config) {
  config = Ext.apply(
    {
      categoryName: config.categoryName,
      categoryId: config.categoryId,
      title: config.categoryName,
      layout: 'fit',
      items: [
        {
          xtype: 'container',
          autoScroll: true,
          cls: 'x-st-tasktab',
          ref: 'tasks',
        },
      ],
    },
    config
  );

  Ext.ux.plusmpm.scheduledtasks.TaskTab.superclass.constructor.call(this, config);
}; // end of Ext.ux.plusmpm.scheduledtasks.TaskTab constructor

Ext.extend(Ext.ux.plusmpm.scheduledtasks.TaskTab, Ext.Container, {
  /**
   * Zakładka została aktywowana. Pobieranie zadań zaplanowanych dla tej kategorii.
   */
  onActivate: function () {
    var storeId = 'st-';
    if (this.categoryId !== undefined) storeId += this.categoryId;
    else storeId += '0';

    if (this.store) {
      this.store.destroy();
    }

    this.store = new Ext.data.JsonStore({
      storeId: storeId,
      autoDestroy: true,
      baseParams: { category: this.categoryId },
      proxy: new Ext.data.HttpProxy({
        method: 'GET',
        url: 'api/scheduledtasks',
      }),
      root: 'data',
      idProperty: 'id',
      fields: [
        { name: 'id', type: 'int' },
        { name: 'name', type: 'string' },
        { name: 'annotationName', type: 'string' },
        { name: 'description', mapping: 'desc' },
        { name: 'annotationDescription', mapping: 'annotationDesc' },
        { name: 'methodName', type: 'string' },
        { name: 'className', type: 'string' },
        { name: 'active', type: 'boolean' },
        { name: 'processing', type: 'boolean' },
        { name: 'cancelable', type: 'boolean', defaultValue: true },
        { name: 'saveHistory', type: 'boolean' },
        { name: 'progress', type: 'float', defaultValue: -1 },
        { name: 'firstRun', type: 'date', dateFormat: 'Y-m-d H:i:s' },
        { name: 'nextRun', type: 'date', dateFormat: 'Y-m-d H:i:s' },
        { name: 'lastRun', type: 'date', dateFormat: 'Y-m-d H:i:s' },
        { name: 'runOnce', type: 'boolean' },
        { name: 'period', type: 'int' },
        { name: 'periodUnit', type: 'string' },
        { name: 'available', type: 'boolean' },
        { name: 'pluginId', type: 'string' },
        { name: 'isComponent', type: 'boolean' },
        { name: 'componentTaskId', type: 'string' },
        { name: 'parameters' },
      ],
    });

    this.store.on({
      scope: this,
      add: this.onStoreAdd,
      remove: this.onStoreRemove,
      datachanged: this.onStoreDataChange,
    });

    this.ownerCt.getBottomToolbar().bindStore(this.store);

    this.loadMask = new Ext.LoadMask(
      this.el,
      Ext.apply(
        {
          store: this.store,
        },
        Ext.LoadMask.prototype.msg
      )
    );

    this.loadFirstPage();
  },

  refreshStore() {
    this.store.reload();
  },

  loadFirstPage: function () {
    var filter = this.ownerCt.taskFilter;
    var sortInfo = this.ownerCt.sortInfo;

    this.store.setBaseParam('query', filter.query);
    this.store.setBaseParam('active', filter.active);
    this.store.setBaseParam('processing', filter.processing);
    this.store.setBaseParam('direction', sortInfo.type);
    this.store.setBaseParam('propertyName', sortInfo.field);

    this.store.load({
      params: {
        start: 0,
        limit: 20,
      },
    });
  },

  /**
   * Uaktualnij dane tej kategorii
   * @param record
   */
  updateCategory: function (record) {
    this.categoryName = record.data.name;
    this.title = this.categoryName;
    this.fireEvent('titlechange', this, this.title);
  },

  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.TaskTab.superclass.initComponent.call(this);

    this.addEvents('titlechange', 'beforeparametersrender');

    this.on('activate', this.onActivate, this);
  },

  /**
   * Obsługa zdarzeń store'a
   */
  onStoreDataChange: function (store) {
    this.refresh();
  },

  onStoreAdd: function (store, records, index) {},

  onStoreRemove: function (store, record, index, isUpdate) {},
  /**
   * Obsługa zdarzeń store'a - KONIEC
   */

  /**
   * Tworzy/odświeża zadania z tej kategorii na podstawie stanu store'a
   */
  refresh: function () {
    this.tasks.removeAll();

    this.store.each(function (record, index, lenght) {
      this.tasks.add(
        Ext.create({
          xtype: 'st_taskpanel',
          itemId: record.data.id,
          task: record.data,
          record: record,
          listeners: {
            scope: this,
            beforeparametersrender: this.onBeforeParametersRender,
          },
        })
      );
    }, this);

    this.doLayout();
  },

  onBeforeParametersRender: function () {
    this.fireEvent('beforeparametersrender');
  },

  propagateBeforeParametersRenderEvent: function () {
    this.tasks.items?.each(function (item) {
      item.propagateBeforeParametersRenderEvent();
    }, this);
  },
}); // end of Ext.extend
Ext.reg('st_tasktab', Ext.ux.plusmpm.scheduledtasks.TaskTab);
