Ext.namespace( 'Ext.ux.plusmpm' );

Ext.ux.plusmpm.PopupWindow = function( config ) {

    var updaterConfig = {
        url: config.url,
        scripts: true,
        method: 'GET'
    };

    config = Ext.apply( {
    	autoScroll: true,
        autoLoad: updaterConfig,
        bodyCssClass: "popup-window-body",
        cls: 'popup-window',
        frame: false,
        floating: {
            shadow: false
        },
        draggable: {
        	insertProxy: false,
	        onDrag: function (e) {
	            var pel = this.proxy.getEl();
	            this.x = pel.getLeft(true);
	            this.y = pel.getTop(true);
	        },
	        endDrag: function (e) {
	            var target = this.dragData.panel;
	            target.setPosition(this.x, this.y);
	        }
        },
        tools: [{
        	id: 'close',
        	handler: function(event, toolEl, panel) {
        		panel.destroy();
            }
        }],
        listeners: {
        	afterrender: function() {
				if(config.width){
					this.setWidth(config.width);
        		}else{
        			this.setWidth(this.minResizeWidth);
        		}
        	}
        },
        renderTo: Ext.getBody(),
        config: config
    }, config );

    Ext.ux.plusmpm.PopupWindow.superclass.constructor.call( this, config );
}; // End of Ext.ux.plusmpm.PopupWindow

Ext.extend( Ext.ux.plusmpm.PopupWindow, Ext.Panel, {

	minResizeWidth: 700,

    initComponent: function() {
        Ext.ux.plusmpm.PopupWindow.superclass.initComponent.call( this );

        this.on( "afterrender", this.onAfterRenderHandler, this );
        Ext.getDoc().on( 'mousedown', this.onDocMouseDownHandler, this );
    },

    checkPosition: function() {
        // ustawiam pozycje okna, zeby miescilo sie w oknie przegladarki
    	var scrollX = jQuery(document).scrollLeft();
        var browserWidth = Ext.getBody().dom.clientWidth + scrollX, browserHeight = Ext.getBody().dom.clientHeight,
            scrollTop = jQuery(document).scrollTop(),
        	x = this.x, y = this.y,
        	changePosition = false;
        if ( browserWidth > this.getWidth() && this.x + this.getWidth() > browserWidth ) {
            x = browserWidth - this.getWidth() - 5;
            changePosition = true;
        }
        if ( browserHeight > this.getHeight() && this.y - scrollTop + this.getHeight() > browserHeight) {
        	y = browserHeight - this.getHeight() + scrollTop - 5;
            changePosition = true;
        }
        if(changePosition) {
        	this.setPosition( x, y );
        }
    },

    onAfterRenderHandler: function( elem ) {
        var updater = elem.getUpdater();
        updater.on( 'update', this.onUpdateHandler, this );
        updater.on( 'failure', this.onFailureHandler, this );

        var panel = this,
        	config = {
	            handles: 'all',
	            pinned: false,
	            resizeElement: function() {
	                var box = this.proxy.getBox();
	                panel.updateBox(box);
	                if (panel.layout) {
	                	panel.doLayout();
	                }
	                return box;
	            }
	        };

        if(!this.config.width) {
        	Ext.apply(config, {minWidth: this.minResizeWidth});
        }

        panel.resizer = new Ext.Resizable(panel.el, config);
        this.checkPosition();
    },

    onUpdateHandler: function() {
        this.resolveWidth();
        this.checkPosition();
    },

    resolveWidth: function() {
        var width = this.config.width || this.getWidth();
        this.setWidth(width);
    },

    onFailureHandler: function() {

    },

    onDocMouseDownHandler: function( e ) {
        if ( !e.within( this.el, false ) ) {
            Ext.getDoc().un( 'mousedown', this.onDocMouseDownHandler, this );
            this.destroy();
        }
    }
} );

/**
 * Wyswietla okno typu Popup z dowolna zawartoscią Okno jest zamykane jezeli
 * klikniemy poza okno.
 *
 * @param url
 *            docelowe url wraz z parametrami
 */
function showPopup( url, title, pageX, pageY, config, event ) {

	if ( !pageX || !pageY ) {
    	if(event) {
    		//na IE pozycje przechowywane są tylko w zmiennych client
	        pageX = event.clientX;
	        pageY = event.clientY + document.documentElement.scrollTop;
    	}
    }
    if ( !pageX || !pageY ) {
        pageX = 100;
        pageY = 100;
    }

    config = Ext.apply({
        url: url,
        title: title,
        x: pageX,
        y: pageY
    }, config);

    var tagToTip = new Ext.ux.plusmpm.PopupWindow( config );
    tagToTip.show();

    return tagToTip;
}

function hideActivePopup(sender){
	jQuery(sender).closest('.popup-window').hide();
}

function showUserListPopup( title, destination, type, event ) {
    var x, y;
    if ( event ) {
        x = event.pageX;
        y = event.pageY;

        //na IE pozycje przechowywane są w zmiennych client
	    if(!x && !y) {
	    	x = event.clientX;
	        y = event.clientY + document.documentElement.scrollTop;
	    }
    }

    var userListUrl = 'ShowGetsUsers.do?';
    userListUrl += 'userType=' + type + '&destination=' + destination;

    showPopup( userListUrl, title, x, y );
}

function showDelegationUserListPopup( title, destination, type, usernameElementId, event ) {
    var x, y;
    if ( event ) {
        x = event.pageX;
        y = event.pageY;

        //na IE pozycje przechowywane są w zmiennych client
	    if(!x && !y) {
	    	x = event.clientX;
	        y = event.clientY + document.documentElement.scrollTop;
	    }
    }

    var username = Ext.get( usernameElementId ).getValue();

    var userListUrl = 'ShowGetsUsers.do?';
    userListUrl += 'userType=' + type + '&destination=' + destination + '&delegationUsernameId=' + username;

    showPopup( userListUrl, title, x, y );
}

function showGroupListPopup( title, type, event, additionalParams ) {
    var x, y;
    if ( event ) {
        x = event.pageX;
        y = event.pageY;

        //na IE pozycje przechowywane są w zmiennych client
	    if(!x && !y) {
	    	x = event.clientX;
	        y = event.clientY + document.documentElement.scrollTop;
	    }
    }

    var userListUrl = 'GetGroupList.do?';
    userListUrl += 'userType=' + type;

    if ( additionalParams )
        userListUrl += '&' + additionalParams;

    showPopup( userListUrl, title, x, y );
}

function showUserGroupListPopup( title, groupId, type, event ) {
    var x, y;
    if ( event ) {
        x = event.pageX;
        y = event.pageY;

        //na IE pozycje przechowywane są w zmiennych client
	    if(!x && !y) {
	    	x = event.clientX;
	        y = event.clientY + document.documentElement.scrollTop;
	    }
    }

    var userListUrl = 'ShowGetsUsers.do?';
    userListUrl += 'userType=' + encodeURI(type) + '&groupId=' + encodeURI(groupId);

    showPopup( userListUrl, title, x, y );
}

function showOrgDataListPopup( title, type, event ) {
    var x, y;
    if ( event ) {
        x = event.pageX;
        y = event.pageY;

        //na IE pozycje przechowywane są w zmiennych client
	    if(!x && !y) {
	    	x = event.clientX;
	        y = event.clientY + document.documentElement.scrollTop;
	    }
    }

    var userListUrl = 'GetOrgStructDataList.do?';
    userListUrl += 'type=' + type;

    showPopup( userListUrl, title, x, y );
}

function showAddingDocumentPopup( title, processKey, activityKey, SDocClassId, event ) {
    var x, y;
    if ( event ) {
        x = event.pageX;
        y = event.pageY;

        //na IE pozycje przechowywane są w zmiennych client
	    if(!x && !y) {
	    	x = event.clientX;
	        y = event.clientY + document.documentElement.scrollTop;
	    }
    }

    var userListUrl = 'ShowNewFileAdd.do?';
    userListUrl += 'processId=' + processKey + '&activityId=' + activityKey + '&docclassId=' + SDocClassId;

    showPopup( userListUrl, title, x, y );
}

/** ******************************************************** */
/* Ext.ux.plusmpm.AuthorizationPopupWindow */
/** ****************************************************** */

Ext.ux.plusmpm.AuthorizationPopupWindow = function( config ) {

    var formPanel = new Ext.form.FormPanel( {
        ref: 'formPanel',
        border: false,
        frame: false,
        defaults: {
            labelStyle: 'margin-top: 0.25em'
        },
        items: [ {
            xtype: 'textfield',
            fieldLabel: this.usernameText,
            width: 180,
            readOnly: true,
            value: config.showUsername
        }, {
            xtype: 'textfield',
            fieldLabel: this.passwordText,
            name: 'password',
            width: 180,
            inputType: 'password'
        }, {
            xtype: 'hidden',
            name: 'domainId',
            value: config.domainId
        }, {
            xtype: 'hidden',
            name: 'username',
            value: config.username
        } ],
        buttons: [ {
            text: this.cancelText,
            scope: this,
            handler: this.close
        }, {
            text: this.authorizeText,
            handler: this.onFormSubmit,
            scope: this
        } ],
        keys: {
            key: Ext.EventObject.ENTER,
            fn: this.onFormSubmit,
            scope: this
        }
    } );

    config = Ext.apply( {
        modal: true,
        resizable: false,
        items: formPanel,
        width: 315,
        title: this.userAuthorizationText
    }, config );

    Ext.ux.plusmpm.AuthorizationPopupWindow.superclass.constructor.call( this, config );
}; // End of Ext.ux.plusmpm.AuthorizationPopupWindow

Ext.extend( Ext.ux.plusmpm.AuthorizationPopupWindow, Ext.Window, {

    // public
    successMessage: PW.t('successMessage'),

    // public
    errorText: PW.t('errorText'),

    // public
    userAuthorizationText: PW.t('userAuthorizationText'),

    // public
    pleaseWaitMessage: PW.t('pleaseWaitMessage'),

    // public
    unkownErrorText: PW.t('unkownErrorText'),

    // public
    cancelText: PW.t('cancelText'),

    // public
    authorizeText: PW.t('authorizeText'),

    // public
    usernameText: PW.t('usernameText'),

    // public
    passwordText: PW.t('passwordText'),

    // public
    domainText: PW.t('domainText'),

    onAfterRenderEventHandler: function() {
        this.formPanel.items.get( 1 ).focus( false, 200 );
    },

    onFormSubmit: function() {
        this.formPanel.getForm().submit( {
            clientValidation: true,
            method: 'POST',
            url: 'com.plusmpm.servlet.authorization.UserAuthorizationServlet.customServlet',
            // params: this.formPanel.getForm().getValues(false),
            scope: this,
            success: this.onFormSubmitSuccess,
            failure: this.onFormSubmitFailure
        } );

        this.formPanel.getEl().mask( this.pleaseWaitMessage, 'x-mask-loading' );
    },

    onFormSubmitSuccess: function( form, action ) {
        this.formPanel.getEl().unmask();
        this.formPanel.getEl().mask( this.successMessage, 'x-mask-loading' );

        this.fireEvent( 'success', this );
        this.un( 'close', this.onCloseOrDestroy, this );
        this.un( 'destroy', this.onCloseOrDestroy, this );
    },

    onFormSubmitFailure: function( form, action ) {
        this.formPanel.getEl().unmask();
        var message = this.unkownErrorText;
        if ( action.result && action.result.msg )
            message = action.result.msg;
        Ext.Msg.show( {
            title: this.errorText,
            msg: message,
            buttons: Ext.Msg.OK,
            icon: Ext.MessageBox.ERROR,
            scope: this,
            fn: function() {
                this.formPanel.items.get( 0 ).focus( false, 200 );
            }
        } );
    },

    onCloseOrDestroy: function() {
        this.fireEvent( 'failure', this );
        this.un( 'close', this.onCloseOrDestroy, this );
        this.un( 'destroy', this.onCloseOrDestroy, this );
    },

    initComponent: function() {

        Ext.ux.plusmpm.AuthorizationPopupWindow.superclass.initComponent.call( this );

        this.addEvents( 'success', 'failure' );

        this.on( 'close', this.onCloseOrDestroy, this );
        this.on( 'destroy', this.onCloseOrDestroy, this );
        this.on( 'afterrender', this.onAfterRenderEventHandler, this );
    }
} );
