Ext.namespace('Ext.ux.plusmpm');

/**
 * Wymagane parametry konfiguracyjne:
 * config.informationPanelTitle
 * config.documentPanelTitle
 * 
 * config.document : fileid, html, docIdText, docClassNameText, docVersion 
 */
Ext.ux.plusmpm.FileViewer = function(config){
	
	
	var items = [];
	var informationPanel = new Ext.ux.plusmpm.FileViewerInformationPanel({
		ref: 'informationPanel',
		document: config.document,
		title: config.informationPanelTitle
	});
	informationPanel.on('expand', this.onResizeEventHandler, this);
	informationPanel.on('collapse', this.onResizeEventHandler, this);
	items.push(informationPanel);
		
	if(config.isBuildAssociatedDocumentsTab){
		var associatedDocumentsParentPanel = new Ext.ux.plusmpm.FileViewerAssociatedDocumentsPanel({
			ref: 'associatedDocumentsParentPanel',
			document: config.document,
			pageSize : config.pageSize,
			title: config.associatedDocumentsParentPanelTitle,
			collapsible: true,
			autoScroll: true,
			collapsed : true,
			titleCollapse : true
		});
		associatedDocumentsParentPanel.on('expand', this.onResizeEventHandler, this);
		associatedDocumentsParentPanel.on('collapse', this.onResizeEventHandler, this);
		items.push(associatedDocumentsParentPanel);		
	}

	var documentPanel = new Ext.ux.plusmpm.FileViewerDocumentPanel({
		ref: 'documentPanel',
		document: config.document,
		title: config.documentPanelTitle
	});
	items.push(documentPanel);

	config = Ext.apply({
		layout: {
		    type: 'anchor'
		    
		},
		defaults: {
		    anchor: '-18'
		},
		autoScroll: true,
		items: items
	}, config);
	
	Ext.ux.plusmpm.FileViewer.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpm.FileViewer

Ext.extend(Ext.ux.plusmpm.FileViewer, Ext.Panel, {
	
	onResizeEventHandler: function(){
		this.documentPanel.adjustHeight();
	},
	
	initComponent: function(){
		
		this.on("resize", this.onResizeEventHandler, this);
		
		Ext.ux.plusmpm.FileViewer.superclass.initComponent.call(this);
	}
	
});

/**
 * Panel wyświetlający informacje o dokumencie.
 * 
 * Dodatkowe parametry konfigracyjne:
 */
Ext.ux.plusmpm.FileViewerInformationPanel = function(config){
	
	config = Ext.apply({
		layout: 'anchor',
		collapsible: true,
		titleCollapse : true,
		frame: false,
		autoHeight: true,
		bodyCssClass: 'fileviewer-information-panel'
	}, config);
	
	Ext.ux.plusmpm.FileViewerInformationPanel.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpm.FileViewer

Ext.extend(Ext.ux.plusmpm.FileViewerInformationPanel, Ext.Panel, {

	onRequestSuccessEventHandler: function(jsonObj){
		
		this.add(this.generateBasicDocumentInformation(jsonObj.baseInfo));
		
		var count = jsonObj.baseInfo.idxCount;
		if(count > 0)
		{
			// Grid przechowujący indeksy
			var columnModel = this.generateIndicesColumnModel(count, jsonObj.indices);
			var store = this.createLocalStore(jsonObj);
			
			var grid = new Ext.grid.GridPanel({   
				ref: "indiecesGridPanel",
				frame: false,
			    store      : store,  
			    colModel   : columnModel,
			    columnLines: true,
			    disableSelection: true,
			    autoHeight: true,
			    listeners: {
			    	scope: this,
			    	columnresize: this.adjustGridHeight,
			    	afterrender: this.adjustGridHeight
			    }
			 });
			
			this.add(grid);
		}

		this.getEl().unmask.defer(500, this.getEl());
		this.doLayout();
	},
	
	adjustGridHeight : function(){
		var columnsWidth = this.indiecesGridPanel.getColumnModel().getTotalWidth(false);
		var gridWidth = this.getInnerWidth() - this.indiecesGridPanel.getFrameWidth();
		if(columnsWidth > gridWidth)
		{
			this.indiecesGridPanel.setHeight(80);
		}
		else
		{
			this.indiecesGridPanel.setHeight(60);
		}
	},
	
	generateBasicDocumentInformation : function(baseInfo){
		
		var data = {
				id: baseInfo.id,
				classname: Ext.util.Format.htmlEncode(baseInfo.className),
				version: baseInfo.version
		};
		var tpl = new Ext.XTemplate(
                '<span class="fileviewer-inf-name">' + this.document.docIdText + ': </span><span class="fileviewer-inf-value">{id} </span>',
                '<span class="fileviewer-inf-name">' + this.document.docClassNameText + ': </span><span class="fileviewer-inf-value">{classname} </span>',
                '<span class="fileviewer-inf-name">' + this.document.docVersion + ': </span><span class="fileviewer-inf-value">{version} </span>'
            );
       
        var info = new Ext.BoxComponent({
        	id: "fileviewer-div",
        	ref: "infoComponent",
        	html:  tpl.apply(data)
        });
		return info;
	},
	
	createLocalStore: function(jsonObj){	
		var store = new Ext.data.ArrayStore({
		    data   : this.generateStoreData(jsonObj.baseInfo.idxCount, jsonObj.indices),
		    fields : this.generateStoreFields(jsonObj.baseInfo.idxCount)
		  });
		return store;
	},
	
	generateStoreFields: function(count)
	{
		var fields = new Array();
		for(var i=0; i<count; i++)
		{
			fields.push(i + '');
		}
		return fields;
	},
	
	generateStoreData: function(count, indices)
	{
		var data = [new Array()];
		
		for(var i=0; i<count; i++)
		{
			data[0].push(indices[i].value);
		}
		return data;
	},
	
	generateIndicesColumnModel: function(count, indices){
	
		var columns = new Array();
		for(var i=0; i<count; i++)
		{
			var column = {header: Ext.util.Format.htmlEncode(indices[i].name), dataIndex: i, minWidth: 50, renderer: 'htmlEncode'};
			columns.push(column);
		}
		var columnModel = new Ext.grid.ColumnModel(columns);
		return columnModel;
	},
	
	onAfterRenderEventHandler : function(){
		
	},
	
	onExpandEventHandler : function() {
		
		this.getEl().mask(Ext.LoadMask.prototype.msg, 'x-mask-loading');
		
		Ext.Ajax.request({
			   url: 'com.plusmpm.servlet.DocumentInformationServlet.customServlet',
			   method: 'GET',
			   scope: this,
			   params: {fileId: this.document.fileId },
			   success: function(response, opts) {
			      this.onRequestSuccessEventHandler(Ext.decode(response.responseText));
			   }
			});
		
		this.un("beforeexpand", this.onExpandEventHandler, this);
	},	
	
	initComponent: function(){
		Ext.ux.plusmpm.FileViewerInformationPanel.superclass.initComponent.call(this);
		this.on("afterrender", function(){this.collapse(false)}, this);
		this.on("beforeexpand", this.onExpandEventHandler, this);
	}
});

/**
 * Podgląd dokumentu
 */
Ext.ux.plusmpm.FileViewerDocumentPanel = function(config){	
	config = Ext.apply({
		html : config.document.html,
		tools : [ {
			id : 'dvnt-icon-save',
			qtip : PW.t('save-file'),
			handler : function(event, toolEl, panel) {
				window.location = 'api/documents/download/' + config.document.fileId;
			}
		} ]
	}, config);
	
	Ext.ux.plusmpm.FileViewerDocumentPanel.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpm.FileViewerDocumentPanel

Ext.extend(Ext.ux.plusmpm.FileViewerDocumentPanel, Ext.Panel, {
	
	adjustHeight: function() {
		var windowHeight = this.ownerCt.getHeight();
		var infoHeight = this.ownerCt.informationPanel.getHeight();
		
		this.setHeight(windowHeight - infoHeight);
	},
	
	initComponent: function(){
		
		Ext.ux.plusmpm.FileViewerDocumentPanel.superclass.initComponent.call(this);
	}

});